/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.rubyproject.ScriptDescProvider;
import org.netbeans.modules.ruby.rubyproject.TestNotifierLineConvertor;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.spi.project.ActionProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class RSpecSupport {
    private static final String PLUGIN_SPEC_PATH = "vendor/plugins/rspec/bin/spec";
    private static final String SPEC_OPTS = "spec/spec.opts";
    private static final String NETBEANS_SPEC_OPTS = "spec/spec.opts.netbeans";
    private static final String RSPEC_GEM_NAME = "rspec";
    private final Project project;

    public RSpecSupport(Project project) {
        this.project = project;
    }

    public static boolean hasRSpecInstalled(RubyPlatform platform) {
        return RSpecSupport.getLatestVersion(platform.getGemManager()) != null;
    }

    private static String getLatestVersion(GemManager gemManager) {
        return gemManager == null ? null : gemManager.getLatestVersion(RSPEC_GEM_NAME);
    }

    private String getLatestVersion() {
        return RSpecSupport.getLatestVersion(RubyPlatform.gemManagerFor((Project)this.project));
    }

    public boolean isRSpecInstalled() {
        FileObject projectDir;
        if (this.getLatestVersion() != null) {
            return true;
        }
        return this.project != null && (projectDir = this.project.getProjectDirectory()) != null && projectDir.getFileObject(PLUGIN_SPEC_PATH) != null;
    }

    public static boolean isSpecFile(FileObject fo) {
        if (!fo.getMIMEType().equals("text/x-ruby")) {
            return false;
        }
        return fo.getName().endsWith("_spec");
    }

    private String getSpecBinary() {
        FileObject rspec;
        FileObject projectDir;
        File rspec2;
        File gemDir;
        String libGemDir;
        assert (this.isRSpecInstalled());
        GemManager gemManager = RubyPlatform.gemManagerFor((Project)this.project);
        String version = this.getLatestVersion();
        if (version != null && (libGemDir = gemManager.getGemHome()) != null && (gemDir = new File(libGemDir, "gems")).exists() && (rspec2 = new File(gemDir, "rspec-" + version + File.separator + "bin" + File.separator + "spec")).exists()) {
            return rspec2.getAbsolutePath();
        }
        if (this.project != null && (projectDir = this.project.getProjectDirectory()) != null && (rspec = projectDir.getFileObject(PLUGIN_SPEC_PATH)) != null) {
            return FileUtil.toFile((FileObject)rspec).getAbsolutePath();
        }
        return null;
    }

    public void runRSpec(File pwd, FileObject specFile, String displayName, LineConvertors.FileLocator fileLocator, boolean warn, boolean debug, String ... parameters) {
        this.runRSpec(pwd, specFile, -1, displayName, fileLocator, warn, debug, parameters);
    }

    public void runRSpec(File pwd, FileObject specFile, int lineNumber, String displayName, LineConvertors.FileLocator fileLocator, boolean warn, boolean debug, String ... parameters) {
        RubyPlatform platform;
        FileObject projectDir = null;
        if (this.project != null) {
            projectDir = this.project.getProjectDirectory();
        }
        if (pwd == null) {
            FileObject pfo = projectDir != null ? projectDir : specFile.getParent();
            pwd = FileUtil.toFile((FileObject)pfo);
        }
        if (!(platform = RubyPlatform.platformFor((Project)this.project)).isValid(warn)) {
            return;
        }
        String spec = this.getSpecBinary();
        if (spec == null) {
            return;
        }
        ArrayList<String> additionalArgs = new ArrayList<String>();
        if (projectDir != null) {
            FileObject specOpts = projectDir.getFileObject(NETBEANS_SPEC_OPTS);
            if (specOpts == null) {
                specOpts = projectDir.getFileObject(SPEC_OPTS);
            }
            if (specOpts != null) {
                additionalArgs.add("--options");
                additionalArgs.add(FileUtil.toFile((FileObject)specOpts).getAbsolutePath());
            }
        }
        if (lineNumber != -1) {
            additionalArgs.add("--line");
            additionalArgs.add(Integer.toString(lineNumber));
        }
        if (parameters != null && parameters.length > 0) {
            for (String parameter : parameters) {
                additionalArgs.add(parameter);
            }
        }
        additionalArgs.add(FileUtil.toFile((FileObject)specFile).getAbsolutePath());
        RubyExecutionDescriptor desc = null;
        String charsetName = null;
        if (this.project != null) {
            ActionProvider provider;
            PropertyEvaluator evaluator = (PropertyEvaluator)this.project.getLookup().lookup(PropertyEvaluator.class);
            if (evaluator != null) {
                charsetName = evaluator.getProperty("source.encoding");
            }
            if ((provider = (ActionProvider)this.project.getLookup().lookup(ActionProvider.class)) instanceof ScriptDescProvider) {
                ScriptDescProvider descProvider = (ScriptDescProvider)provider;
                String target = spec;
                TestNotifierLineConvertor convertor = new TestNotifierLineConvertor(true, true);
                desc = descProvider.getScriptDescriptor(pwd, null, target, displayName, this.project.getLookup(), debug, convertor);
                desc.additionalArgs(additionalArgs.toArray(new String[additionalArgs.size()]));
            }
        } else {
            desc = new RubyExecutionDescriptor(platform, displayName, pwd, spec);
            desc.additionalArgs(additionalArgs.toArray(new String[additionalArgs.size()]));
            desc.debug(debug);
            desc.allowInput();
            desc.fileLocator(fileLocator);
            desc.addStandardRecognizers();
            TestNotifierLineConvertor convertor = new TestNotifierLineConvertor(true, true);
            desc.addOutConvertor((LineConvertor)convertor);
            desc.addErrConvertor((LineConvertor)convertor);
        }
        if (desc != null) {
            ExecutionService.newService((Callable)new RubyProcessCreator(desc, charsetName), (ExecutionDescriptor)desc.toExecutionDescriptor(), (String)displayName).run();
        }
    }
}

