/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.rubyproject.bundler.BundlerSupport;
import org.netbeans.modules.ruby.rubyproject.ui.TreeRootNode;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

public abstract class RubyBaseLogicalViewProvider
implements LogicalViewProvider {
    private final RubyBaseProject project;
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper resolver;
    private List<ChangeListener> changeListeners;
    protected final BundlerSupport bundlerSupport;

    protected RubyBaseLogicalViewProvider(RubyBaseProject project, UpdateHelper updateHelper, PropertyEvaluator evaluator, ReferenceHelper resolver) {
        this.project = project;
        assert (project != null);
        this.helper = updateHelper;
        assert (updateHelper != null);
        this.evaluator = evaluator;
        assert (evaluator != null);
        this.resolver = resolver;
        this.bundlerSupport = new BundlerSupport(project);
    }

    public final RubyBaseProject getProject() {
        return this.project;
    }

    public final PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    public final ReferenceHelper getRefHelper() {
        return this.resolver;
    }

    public final UpdateHelper getUpdateHelper() {
        return this.helper;
    }

    protected abstract Node findWithPathFinder(Node var1, FileObject var2);

    public synchronized void addChangeListener(ChangeListener l) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener>();
        }
        this.changeListeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        if (this.changeListeners == null) {
            return;
        }
        this.changeListeners.remove(l);
    }

    protected Node findWithPathFinder1(Node root, FileObject target) {
        Node n;
        TreeRootNode.PathFinder pf2 = (TreeRootNode.PathFinder)root.getLookup().lookup(TreeRootNode.PathFinder.class);
        if (pf2 != null && (n = pf2.findPath(root, target)) != null) {
            return n;
        }
        return null;
    }

    public final Node findPath(Node root, Object target) {
        Project _project = (Project)root.getLookup().lookup(Project.class);
        if (_project == null) {
            return null;
        }
        if (target instanceof FileObject) {
            FileObject targetFO = (FileObject)target;
            Project owner = FileOwnerQuery.getOwner((FileObject)targetFO);
            if (!_project.equals(owner)) {
                return null;
            }
            Node[] rootChildren = root.getChildren().getNodes(true);
            for (int i = 0; i < rootChildren.length; ++i) {
                FileObject childFO;
                Node n = this.findWithPathFinder(rootChildren[i], targetFO);
                if (n != null) {
                    return n;
                }
                DataObject dObj = (DataObject)rootChildren[i].getLookup().lookup(DataObject.class);
                if (dObj == null || !targetFO.equals(childFO = dObj.getPrimaryFile())) continue;
                return rootChildren[i];
            }
        }
        return null;
    }
}

