/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.pretty;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.netbeans.modules.java.source.builder.ASTService;
import org.netbeans.modules.java.source.builder.TreeFactory;

public class ImportAnalysis2 {
    private Elements elements;
    private TreeFactory make;
    private List<ImportTree> imports;
    private Set<Element> imported;
    private Stack<Set<Element>> visibleThroughClasses;
    private Map<String, Element> simpleNames2Elements;
    private PackageElement unnamedPackage;
    private PackageElement pack;
    private ASTService model;
    private CompilationUnitTree cut;
    private Map<String, Element> usedImplicitlyImportedClassesCache;
    private Set<String> implicitlyImportedClassNames;
    private PackageElement javaLang;

    public ImportAnalysis2(Context env) {
        this.elements = JavacElements.instance(env);
        this.make = TreeFactory.instance(env);
        this.unnamedPackage = Symtab.instance((Context)env).unnamedPackage;
        this.model = ASTService.instance(env);
    }

    public void setCompilationUnit(CompilationUnitTree cut) {
        this.cut = cut;
    }

    public void setPackage(ExpressionTree packageNameTree) {
        if (packageNameTree == null) {
            this.pack = this.unnamedPackage;
            return;
        }
        String packageName = this.getFQN(packageNameTree);
        this.pack = this.elements.getPackageElement(packageName);
    }

    public void setImports(List<? extends ImportTree> importsToAdd) {
        this.imports = new ArrayList<ImportTree>();
        this.imported = new HashSet<Element>();
        this.simpleNames2Elements = new HashMap<String, Element>();
        this.visibleThroughClasses = new Stack();
        this.usedImplicitlyImportedClassesCache = null;
        for (ImportTree importTree : importsToAdd) {
            this.addImport(importTree, false);
        }
        this.implicitlyImportedClassNames = new HashSet<String>();
        this.javaLang = this.elements.getPackageElement("java.lang");
        if (this.javaLang != null) {
            for (Element element : this.javaLang.getEnclosedElements()) {
                this.implicitlyImportedClassNames.add(element.getSimpleName().toString());
            }
        }
        if (this.pack != null) {
            for (Element element : this.pack.getEnclosedElements()) {
                this.implicitlyImportedClassNames.add(element.getSimpleName().toString());
            }
        }
    }

    public List<? extends ImportTree> getImports() {
        return this.imports;
    }

    public void classEntered(ClassTree clazz) {
        HashSet<Element> visible = new HashSet<Element>();
        visible.add(this.model.getElement(clazz));
        this.addAll(clazz.getExtendsClause(), visible);
        for (Tree tree : clazz.getImplementsClause()) {
            this.addAll(tree, visible);
        }
        for (Tree tree : clazz.getMembers()) {
            Element e;
            if (tree.getKind() != Tree.Kind.CLASS || (e = this.model.getElement(tree)) == null) continue;
            visible.add(e);
        }
        this.visibleThroughClasses.push(visible);
    }

    public void classLeft() {
        this.visibleThroughClasses.pop();
    }

    private String getFQN(ImportTree imp) {
        return this.getFQN(imp.getQualifiedIdentifier());
    }

    private String getFQN(Tree expression) {
        final StringBuffer result = new StringBuffer();
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitMemberSelect(MemberSelectTree tree, Void p) {
                super.visitMemberSelect(tree, p);
                result.append('.');
                result.append(tree.getIdentifier().toString());
                return null;
            }

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void p) {
                result.append(tree.getName().toString());
                return null;
            }
        }.scan(expression, null);
        return result.toString();
    }

    private void addImport(ImportTree imp, boolean sort) {
        String fqn = this.getFQN(imp);
        if (!imp.isStatic()) {
            TypeElement resolve = this.elements.getTypeElement(fqn);
            if (resolve != null) {
                this.imported.add(resolve);
                this.simpleNames2Elements.put(resolve.getSimpleName().toString(), resolve);
            } else if (fqn.endsWith(".*")) {
                fqn = fqn.substring(0, fqn.length() - 2);
                List<Object> classes = Collections.emptyList();
                TypeElement clazz = this.elements.getTypeElement(fqn);
                if (clazz != null) {
                    classes = ElementFilter.typesIn(clazz.getEnclosedElements());
                } else {
                    PackageElement pack = this.elements.getPackageElement(fqn);
                    if (pack != null) {
                        classes = ElementFilter.typesIn(pack.getEnclosedElements());
                    }
                }
                for (TypeElement typeElement : classes) {
                    this.imported.add(typeElement);
                    this.simpleNames2Elements.put(typeElement.getSimpleName().toString(), typeElement);
                }
            }
        } else {
            int dot = fqn.lastIndexOf(46);
            if (dot != -1) {
                String className = fqn.substring(0, dot);
                String memberName = fqn.substring(dot + 1);
                boolean isStarred = "*".equals(memberName);
                TypeElement typeElement = this.elements.getTypeElement(className);
                if (typeElement != null) {
                    for (Element element : typeElement.getEnclosedElements()) {
                        if (!element.getModifiers().contains((Object)Modifier.STATIC) || !isStarred && !memberName.contains(element.getSimpleName().toString())) continue;
                        this.imported.add(element);
                        this.simpleNames2Elements.put(element.getSimpleName().toString(), element);
                    }
                }
            }
        }
        if (!sort) {
            this.imports.add(imp);
        } else {
            String currentFQN;
            int point = -1;
            int cntr = 0;
            while (cntr < this.imports.size() && (currentFQN = this.getFQN(this.imports.get(cntr))).compareTo(fqn) < 0) {
                point = cntr++;
            }
            this.imports.add(point + 1, imp);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ExpressionTree resolveImport(MemberSelectTree orig, Element element) {
        void var4_7;
        boolean clash;
        if (this.visibleThroughClasses == null) {
            return orig;
        }
        if (element.getKind() == ElementKind.PACKAGE) {
            return this.make.MemberSelect(orig.getExpression(), orig.getIdentifier());
        }
        for (Set set : this.visibleThroughClasses) {
            if (!set.contains(element)) continue;
            return this.make.Identifier(element.getSimpleName());
        }
        String simpleName = element.getSimpleName().toString();
        Element element2 = this.simpleNames2Elements.get(simpleName);
        if (element2 == null) {
            block1: for (Set set : this.visibleThroughClasses) {
                for (Element e : set) {
                    if (e == null || e.getSimpleName() == null || !simpleName.equals(e.getSimpleName().toString())) continue;
                    Element element3 = e;
                    break block1;
                }
            }
        }
        boolean bl = clash = var4_7 != null && !((Object)element).equals(var4_7);
        if (!clash && (element.getKind().isClass() || element.getKind().isInterface())) {
            Element element4 = element.getEnclosingElement();
            if (this.pack != null && this.pack.equals(element4)) {
                return this.make.Identifier(element.getSimpleName());
            }
        }
        if (this.imported.contains(element)) {
            return this.make.Identifier(element.getSimpleName());
        }
        if (this.elements.getPackageOf(element) != null && this.elements.getPackageOf(element).isUnnamed()) {
            if (orig.getExpression().getKind() == Tree.Kind.MEMBER_SELECT) {
                return this.make.MemberSelect(this.resolveImport((MemberSelectTree)orig.getExpression(), element.getEnclosingElement()), element.getSimpleName());
            }
            return orig;
        }
        if (!clash && this.implicitlyImportedClassNames.contains(simpleName)) {
            Element element5 = this.getUsedImplicitlyImportedClasses().get(simpleName);
            boolean bl2 = clash = element5 != null && !((Object)element).equals(element5);
        }
        if (clash) {
            if (element.getEnclosingElement().getKind().isClass() || element.getEnclosingElement().getKind().isInterface() && orig.getExpression().getKind() == Tree.Kind.MEMBER_SELECT) {
                return this.make.MemberSelect(this.resolveImport((MemberSelectTree)orig.getExpression(), element.getEnclosingElement()), orig.getIdentifier());
            }
            return this.make.MemberSelect(orig.getExpression(), orig.getIdentifier());
        }
        if (!element.getKind().isClass() && !element.getKind().isInterface()) {
            void var6_17;
            ExpressionTree expressionTree = orig.getExpression();
            if (expressionTree.getKind() == Tree.Kind.MEMBER_SELECT) {
                ExpressionTree expressionTree2 = this.resolveImport((MemberSelectTree)expressionTree, element.getEnclosingElement());
            }
            return this.make.MemberSelect((ExpressionTree)var6_17, orig.getIdentifier());
        }
        TypeElement typeElement = (TypeElement)element;
        Element parent = typeElement.getEnclosingElement();
        if (parent.getKind() == ElementKind.PACKAGE && "java.lang".equals(((PackageElement)parent).getQualifiedName().toString())) {
            return this.make.Identifier(element.getSimpleName());
        }
        ExpressionTree imp = this.make.QualIdentImpl(element);
        this.addImport(this.make.Import(imp, false), true);
        return this.make.Identifier(element.getSimpleName());
    }

    private void addAll(Tree t, Set<Element> visible) {
        if (t == null) {
            return;
        }
        Symbol e = null;
        if (t.getKind() == Tree.Kind.MEMBER_SELECT) {
            e = ((JCTree.JCFieldAccess)t).sym;
        } else if (t.getKind() == Tree.Kind.IDENTIFIER) {
            e = ((JCTree.JCIdent)t).sym;
        }
        if (e == null || !e.getKind().isClass() && !e.getKind().isInterface()) {
            return;
        }
        visible.addAll(this.elements.getAllMembers((TypeElement)((Object)e)));
    }

    private Map<String, Element> getUsedImplicitlyImportedClasses() {
        if (this.usedImplicitlyImportedClassesCache != null) {
            return this.usedImplicitlyImportedClassesCache;
        }
        this.usedImplicitlyImportedClassesCache = new HashMap<String, Element>();
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree node, Void p) {
                Element e = ImportAnalysis2.this.model.getElement(node);
                if (e != null && (ImportAnalysis2.this.javaLang != null && ImportAnalysis2.this.javaLang.equals(e.getEnclosingElement()) || ImportAnalysis2.this.pack != null && ImportAnalysis2.this.pack.equals(e.getEnclosingElement()))) {
                    ImportAnalysis2.this.usedImplicitlyImportedClassesCache.put(e.getSimpleName().toString(), e);
                }
                return null;
            }
        }.scan(this.cut, null);
        return this.usedImplicitlyImportedClassesCache;
    }
}

