/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.graph;

import java.lang.reflect.Array;

class CyclicArray<T> {
    private T[] data;
    private int last;
    private int size;

    public CyclicArray() {
        this(10);
    }

    public CyclicArray(int initialCapacity) {
        if (initialCapacity < 2) {
            throw new IllegalArgumentException("Invalid initial capacity " + initialCapacity);
        }
        this.data = new Object[initialCapacity];
        this.last = -1;
        this.size = 0;
    }

    public boolean add(T value) {
        if (this.last < this.data.length - 1) {
            this.data[++this.last] = value;
            if (this.size < this.data.length) {
                ++this.size;
                return false;
            }
        } else {
            this.last = 0;
            this.data[0] = value;
        }
        return true;
    }

    public T get(int index) {
        return this.data[this.trandformIndex(index)];
    }

    public void set(int index, T value) {
        this.data[this.trandformIndex((int)index)] = value;
    }

    private final int trandformIndex(int index) {
        if (index < 0 || index >= this.size) {
            throw new IllegalArgumentException("Invalid index " + index + "; size: " + this.size);
        }
        if (this.size < this.data.length) {
            return index;
        }
        int first = this.last + 1;
        if (first + index < this.data.length) {
            return first + index;
        }
        return first + index - this.data.length;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.data.length;
    }

    public void setCapacity(int newCapacity) {
        Object[] newData = new Object[newCapacity];
        int oldIndex = newCapacity < this.size ? this.size - newCapacity : 0;
        int newIndex = 0;
        while (oldIndex < this.size()) {
            newData[newIndex++] = this.get(oldIndex++);
        }
        this.data = newData;
        int n = this.last = this.size < this.data.length ? this.size - 1 : this.data.length - 1;
        if (this.size > this.data.length) {
            this.size = this.data.length;
        }
    }

    public void ensureCapacity(int capacity) {
        if (capacity > this.data.length) {
            this.setCapacity(capacity);
        }
    }

    public static final <T> boolean areEqual(CyclicArray<T> a1, CyclicArray<T> a2) {
        if (a1 == null) {
            return a2 == null;
        }
        if (a2 == null) {
            return false;
        }
        if (a1.size() != a2.size()) {
            return false;
        }
        for (int i = 0; i < a1.size(); ++i) {
            T v1 = a1.get(i);
            T v2 = a2.get(i);
            if (v1 == null) {
                if (v2 == null) continue;
                return false;
            }
            if (v2 == null) {
                return false;
            }
            if (v1.equals(v2)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("CyclicArray capacity=%d size=%d last=%d data=[", this.data.length, this.size, this.last));
        for (int i = 0; i < this.data.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.toString(this.data[i]));
        }
        sb.append(']');
        return sb.toString();
    }

    private String toString(Object v) {
        if (v == null) {
            return "null";
        }
        if (v.getClass().isArray()) {
            int length = Array.getLength(v);
            StringBuilder sb = new StringBuilder("[");
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.toString(Array.get(v, i)));
            }
            sb.append(']');
            return sb.toString();
        }
        return v.toString();
    }
}

