/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.options;

import java.io.File;
import java.util.prefs.Preferences;
import org.netbeans.modules.mobility.svgcore.snippets.gradientlook.SVGSnipetsProviderGradient;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class SvgcoreSettings {
    private static SvgcoreSettings svgcoreSettings = null;
    private static final String PROP_EDITOR_PATH = "editorPath";
    private static final String PROP_CURRENT_SNIPPET = "currentSnippet";
    private static final String DEFAULT_EDITOR_PATH = "c:\\Program Files\\Ikivo\\Ikivo Animator\\IkivoAnimator.exe";
    private static final long serialVersionUID = 85176380568174L;
    private Preferences prefs = NbPreferences.forModule(SvgcoreSettings.class);

    private SvgcoreSettings() {
        String propEditorPath = this.prefs.get(PROP_EDITOR_PATH, null);
        File defaultEditorPathFile = new File(DEFAULT_EDITOR_PATH);
        if (propEditorPath == null && defaultEditorPathFile.exists()) {
            this.setExternalEditorPath(DEFAULT_EDITOR_PATH);
        }
    }

    public static synchronized SvgcoreSettings getDefault() {
        if (svgcoreSettings == null) {
            svgcoreSettings = new SvgcoreSettings();
        }
        return svgcoreSettings;
    }

    public String getExternalEditorPath() {
        return this.prefs.get(PROP_EDITOR_PATH, null);
    }

    public final void setExternalEditorPath(String path) {
        this.prefs.put(PROP_EDITOR_PATH, path);
    }

    public final String getCurrentSnippet() {
        String currentSnippet = this.prefs.get(PROP_CURRENT_SNIPPET, null);
        if (currentSnippet == null) {
            return NbBundle.getMessage(SVGSnipetsProviderGradient.class, (String)"LBL_SNIPPET_DISPLAY_NAME");
        }
        return currentSnippet;
    }

    final void setCurrentSnippet(String currentSnippet) {
        if (currentSnippet != null) {
            this.prefs.put(PROP_CURRENT_SNIPPET, currentSnippet);
        }
    }
}

