/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.css.editor.Property;
import org.netbeans.modules.css.editor.PropertyModel;
import org.netbeans.modules.css.editor.properties.Acceptors;
import org.netbeans.modules.css.editor.properties.CssPropertyValueAcceptor;
import org.netbeans.modules.css.editor.properties.KeywordUtil;

public class CssPropertyValue {
    final PropertyModel.GroupElement groupElement;
    private final String text;
    private final List<ResolvedToken> resolved = new ArrayList<ResolvedToken>();
    private Set<PropertyModel.Element> resolvedAlternatives;
    private Set<PropertyModel.Element> visibleAlternatives = new HashSet<PropertyModel.Element>();
    private final Stack<String> stack = new Stack();
    private final String propertyDefinition;
    Stack<String> originalStack;
    final StringBuffer log = new StringBuffer();
    private static final Pattern FILTER_COMMENTS_PATTERN = Pattern.compile("/\\*.*?\\*/");

    private static String filterComments(String text) {
        Matcher m = FILTER_COMMENTS_PATTERN.matcher(text);
        StringBuilder b = new StringBuilder(text);
        while (m.find()) {
            int to;
            int from = m.start();
            if (from == (to = m.end())) continue;
            char[] spaces = new char[to - from];
            Arrays.fill(spaces, ' ');
            String replacement = new String(spaces);
            b.replace(from, to, replacement);
        }
        return b.toString();
    }

    public CssPropertyValue(Property property, String textOfTheValue) {
        this.groupElement = property.values();
        this.text = CssPropertyValue.filterComments(textOfTheValue);
        this.propertyDefinition = null;
        this.consume();
    }

    CssPropertyValue(String propertyValueDefinition, String textOfTheValue) {
        this.groupElement = PropertyModel.instance().parse(propertyValueDefinition);
        this.text = textOfTheValue;
        this.propertyDefinition = propertyValueDefinition;
        this.consume();
    }

    private void log(String msg) {
        this.log.append(msg);
    }

    String log() {
        return this.log.toString();
    }

    String inputText() {
        return this.text;
    }

    String propertyDefinition() {
        return this.propertyDefinition;
    }

    public List<String> left() {
        return this.stack;
    }

    public List<ResolvedToken> resolved() {
        return this.resolved;
    }

    public boolean success() {
        return this.stack.isEmpty();
    }

    public Set<PropertyModel.Element> alternatives() {
        if (this.resolvedAlternatives == null) {
            this.initAlternatives();
        }
        return this.resolvedAlternatives;
    }

    public Set<PropertyModel.Element> visibleAlternatives() {
        if (this.resolvedAlternatives == null) {
            this.initAlternatives();
        }
        return this.visibleAlternatives;
    }

    private void computeVisibleAlts() {
        for (PropertyModel.Element e : this.alternatives()) {
            if (e instanceof PropertyModel.ValueElement && ((PropertyModel.ValueElement)e).isUnit()) continue;
            this.visibleAlternatives.add(e);
        }
    }

    private void consume() {
        CssPropertyValue.fillStack(this.stack, this.text);
        this.originalStack = (Stack)this.stack.clone();
        this.resolve(this.groupElement, this.stack, this.resolved);
    }

    private void initAlternatives() {
        this.resolvedAlternatives = this.resolveElement(this.groupElement, new ArrayList<ResolvedToken>(this.resolved)).alternatives();
        this.eliminateDuplicatedAlternatives();
        this.computeVisibleAlts();
    }

    private void eliminateDuplicatedAlternatives() {
        this.log("\nEliminated duplicate alternatives:\n");
        HashMap<String, PropertyModel.Element> dupes = new HashMap<String, PropertyModel.Element>();
        for (PropertyModel.Element e : this.alternatives()) {
            if (dupes.put(e.toString(), e) == null) continue;
            this.log(e.path() + "\n");
        }
        this.log("-----------------\n");
        this.alternatives().retainAll(dupes.values());
    }

    private ResolveContext resolveElement(PropertyModel.Element element, List<ResolvedToken> resolved) {
        int repeat;
        ResolveContext.ResolveType resolveType = ResolveContext.ResolveType.UNEVALUATED;
        HashSet<PropertyModel.Element> alternatives = new HashSet<PropertyModel.Element>();
        block0: for (repeat = 0; repeat < element.getMaximumOccurances(); ++repeat) {
            ResolveContext rt;
            ResolveContext.ResolveType previousPassResolveType = resolveType;
            if (resolveType == ResolveContext.ResolveType.UNRESOLVED) break;
            resolveType = ResolveContext.ResolveType.UNRESOLVED;
            if (element instanceof PropertyModel.ValueElement) {
                if (!this.consume(element, resolved)) break;
                resolveType = ResolveContext.ResolveType.PARTIALLY_RESOLVED;
                continue;
            }
            if (!(element instanceof PropertyModel.GroupElement)) continue;
            PropertyModel.GroupElement ge = (PropertyModel.GroupElement)element;
            if (!ge.isList() && !ge.isSequence()) {
                for (PropertyModel.Element e : ge.elements()) {
                    rt = this.resolveElement(e, resolved);
                    if (rt.resolveType() == ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE) {
                        resolveType = ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE;
                        alternatives.clear();
                        alternatives.addAll(rt.alternatives());
                        break block0;
                    }
                    if (rt.resolved()) {
                        resolveType = ResolveContext.ResolveType.FULLY_RESOLVED;
                        alternatives.clear();
                        alternatives.addAll(rt.alternatives());
                        continue block0;
                    }
                    alternatives.addAll(rt.alternatives());
                }
                continue;
            }
            if (ge.isList()) {
                for (PropertyModel.Element e : ge.elements()) {
                    rt = this.resolveElement(e, resolved);
                    alternatives.addAll(rt.alternatives());
                    if (rt.resolveType() == ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE) {
                        resolveType = ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE;
                        alternatives.clear();
                        alternatives.addAll(rt.alternatives());
                        break block0;
                    }
                    if (!rt.resolved()) continue;
                    resolveType = ResolveContext.ResolveType.FULLY_RESOLVED;
                }
                continue;
            }
            if (!ge.isSequence()) continue;
            this.log("<S> " + ge.path() + "\n");
            PropertyModel.Element firstUnresolved = null;
            HashSet<PropertyModel.Element> localAlts = new HashSet<PropertyModel.Element>();
            for (PropertyModel.Element e : ge.elements()) {
                ResolveContext rt2 = this.resolveElement(e, resolved);
                this.log("trying " + e.path() + " (MIN=" + e.getMinimumOccurances() + "; MAX=" + e.getMaximumOccurances() + "; resolved=" + (Object)((Object)rt2.resolveType()) + "; alts=" + rt2.alternatives().size() + ")\n");
                if (rt2.resolveType() == ResolveContext.ResolveType.UNRESOLVED) {
                    localAlts.addAll(rt2.alternatives());
                    if (e.getMinimumOccurances() <= 0) continue;
                    firstUnresolved = e;
                    break;
                }
                if (rt2.resolveType() == ResolveContext.ResolveType.FULLY_RESOLVED) {
                    resolveType = ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE;
                    localAlts.clear();
                    continue;
                }
                if (rt2.resolveType() != ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE) continue;
                resolveType = ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE;
                localAlts.clear();
                localAlts.addAll(rt2.alternatives());
                firstUnresolved = e;
                this.log("break on " + e.path() + "\n");
                break;
            }
            alternatives.addAll(localAlts);
            if (firstUnresolved == null) {
                resolveType = ResolveContext.ResolveType.FULLY_RESOLVED;
            } else if (previousPassResolveType == ResolveContext.ResolveType.FULLY_RESOLVED) {
                resolveType = ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE;
            }
            this.log("sequence " + (Object)((Object)resolveType) + "\n");
            if (resolveType == ResolveContext.ResolveType.PARTIALLY_RESOLVED_SEQUENCE) break;
        }
        int remainingPossibleOccurances = element.getMaximumOccurances() - repeat;
        if (element instanceof PropertyModel.ValueElement) {
            if (resolveType == ResolveContext.ResolveType.UNRESOLVED || resolveType == ResolveContext.ResolveType.PARTIALLY_RESOLVED && remainingPossibleOccurances > 0) {
                alternatives.add(element);
            }
            if (resolveType == ResolveContext.ResolveType.PARTIALLY_RESOLVED && remainingPossibleOccurances == 0) {
                resolveType = ResolveContext.ResolveType.FULLY_RESOLVED;
            }
        }
        return ResolveContext.resolveContext(resolveType, alternatives);
    }

    private boolean consume(PropertyModel.Element e, List<ResolvedToken> resolved) {
        for (ResolvedToken rt : resolved) {
            if (!rt.element().equals(e)) continue;
            resolved.remove(rt);
            return true;
        }
        return false;
    }

    static void fillStack(Stack<String> stack, String input) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\'' || c == '\"') {
                sb.append(c);
                ++i;
                while (i < input.length() && (c = input.charAt(i)) != '\'' && c != '\"') {
                    sb.append(c);
                    ++i;
                }
                sb.append(c);
                stack.add(0, sb.toString());
                sb = new StringBuffer();
                continue;
            }
            if (sb.toString().equalsIgnoreCase("url") && c == '(') {
                stack.add(0, sb.toString());
                stack.add(0, "" + c);
                sb = new StringBuffer();
                ++i;
                while (i < input.length() && (c = input.charAt(i)) != ')') {
                    sb.append(c);
                    ++i;
                }
                stack.add(0, sb.toString());
                stack.add(0, "" + c);
                sb = new StringBuffer();
                continue;
            }
            if (c == ' ' || c == '\t' || c == '\n') {
                if (sb.length() > 0) {
                    stack.add(0, sb.toString());
                    sb = new StringBuffer();
                }
                while (i < input.length() && (c = input.charAt(i)) == ' ' && c == '\t') {
                    ++i;
                }
                continue;
            }
            if (c == ',' || c == '/' || c == '(' || c == ')') {
                if (sb.length() > 0) {
                    stack.add(0, sb.toString());
                }
                stack.add(0, "" + c);
                sb = new StringBuffer();
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            stack.add(0, sb.toString());
        }
    }

    private boolean resolve(PropertyModel.Element e, Stack<String> input, List<ResolvedToken> consumed) {
        this.log.append(e.path() + "\n");
        boolean itemResolved = false;
        if (input.isEmpty()) {
            return true;
        }
        if (e instanceof PropertyModel.GroupElement) {
            PropertyModel.GroupElement ge = (PropertyModel.GroupElement)e;
            boolean resolved = false;
            for (int i = 0; i < e.getMaximumOccurances(); ++i) {
                ArrayList<PropertyModel.Element> elementsToProcess = new ArrayList<PropertyModel.Element>(ge.elements());
                block1: do {
                    for (PropertyModel.Element member : elementsToProcess) {
                        resolved = this.resolve(member, input, consumed);
                        if (resolved) {
                            itemResolved = true;
                            if (ge.isSequence()) continue;
                            if (!ge.isList()) break block1;
                            this.log.append("sg resolved in " + member.path() + "\n");
                            elementsToProcess.remove(member);
                            continue block1;
                        }
                        if (!ge.isSequence() || member.getMinimumOccurances() <= 0) continue;
                        continue block1;
                    }
                } while (!input.isEmpty() && resolved && !elementsToProcess.isEmpty() && ge.isList());
                if (resolved && !input.isEmpty()) {
                    continue;
                }
                break;
            }
        } else if (e instanceof PropertyModel.ValueElement) {
            String token = input.peek();
            PropertyModel.ValueElement ve = (PropertyModel.ValueElement)e;
            if (ve.isUnit() && !KeywordUtil.isKeyword(token)) {
                String unitName = ve.value();
                CssPropertyValueAcceptor acceptor = Acceptors.instance().getAcceptor(unitName);
                if (acceptor != null) {
                    if (acceptor.accepts(token)) {
                        input.pop();
                        consumed.add(new ResolvedToken(token, e));
                        this.log.append("eaten UNIT '" + token + "'\n");
                        return true;
                    }
                } else {
                    Logger.global.warning("ERROR - no acceptor for unit property value " + ve.value());
                }
            } else if (token.equalsIgnoreCase(ve.value())) {
                input.pop();
                consumed.add(new ResolvedToken(token, e));
                this.log.append("eaten '" + token + "'\n");
                return true;
            }
        }
        return itemResolved;
    }

    public class ResolvedToken {
        private String token;
        private PropertyModel.Element element;

        private ResolvedToken(String token, PropertyModel.Element element) {
            this.token = token;
            this.element = element;
        }

        public String token() {
            return this.token;
        }

        public PropertyModel.Element element() {
            return this.element;
        }
    }

    static class ResolveContext {
        private ResolveType type;
        private Set<PropertyModel.Element> alternatives;

        public static ResolveContext resolveContext(ResolveType type, Set<PropertyModel.Element> alternatives) {
            return new ResolveContext(type, alternatives);
        }

        private ResolveContext(ResolveType type, Set<PropertyModel.Element> alternatives) {
            this.type = type;
            this.alternatives = alternatives;
        }

        public boolean resolved() {
            return this.type == ResolveType.PARTIALLY_RESOLVED || this.type == ResolveType.FULLY_RESOLVED;
        }

        public ResolveType resolveType() {
            return this.type;
        }

        public Set<PropertyModel.Element> alternatives() {
            return this.alternatives;
        }

        public static enum ResolveType {
            UNEVALUATED,
            UNRESOLVED,
            PARTIALLY_RESOLVED,
            FULLY_RESOLVED,
            PARTIALLY_RESOLVED_SEQUENCE;

        }
    }
}

