/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.jumpto.support;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.spi.jumpto.support.NameMatcher;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.util.Parameters;

public final class NameMatcherFactory {
    private NameMatcherFactory() {
    }

    public static NameMatcher createNameMatcher(String text, SearchType type) throws IllegalArgumentException {
        Parameters.notNull((CharSequence)"text", (Object)text);
        Parameters.notNull((CharSequence)"type", (Object)((Object)type));
        try {
            switch (type) {
                case EXACT_NAME: {
                    return new ExactNameMatcher(text);
                }
                case CASE_INSENSITIVE_EXACT_NAME: {
                    return new CaseInsensitiveExactNameMatcher(text);
                }
                case PREFIX: {
                    return new PrefixNameMatcher(text);
                }
                case REGEXP: {
                    return new RegExpNameMatcher(text, true);
                }
                case CASE_INSENSITIVE_REGEXP: {
                    return new RegExpNameMatcher(text, false);
                }
                case CASE_INSENSITIVE_PREFIX: {
                    return new CaseInsensitivePrefixNameMatcher(text);
                }
                case CAMEL_CASE: {
                    return new CamelCaseNameMatcher(text);
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)type));
        }
        catch (PatternSyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static final class CamelCaseNameMatcher
    implements NameMatcher {
        private final Pattern pattern;

        public CamelCaseNameMatcher(String name) {
            if (name.length() == 0) {
                throw new IllegalArgumentException();
            }
            StringBuilder patternString = new StringBuilder();
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                patternString.append(c);
                if (i == name.length() - 1) {
                    patternString.append("\\w*");
                    continue;
                }
                patternString.append("[\\p{Lower}\\p{Digit}]*");
            }
            this.pattern = Pattern.compile(patternString.toString());
        }

        @Override
        public final boolean accept(String name) {
            return name != null && this.pattern.matcher(name).matches();
        }
    }

    private static final class RegExpNameMatcher
    implements NameMatcher {
        private final Pattern pattern;

        public RegExpNameMatcher(String patternText, boolean caseSensitive) {
            this.pattern = Pattern.compile(patternText, caseSensitive ? 0 : 2);
        }

        @Override
        public final boolean accept(String name) {
            return name != null && this.pattern.matcher(name).matches();
        }
    }

    private static final class CaseInsensitivePrefixNameMatcher
    extends BaseNameMatcher {
        public CaseInsensitivePrefixNameMatcher(String patternText) {
            super(patternText.toLowerCase());
        }

        @Override
        public final boolean accept(String name) {
            return name != null && name.toLowerCase().startsWith(this.patternText);
        }
    }

    private static final class PrefixNameMatcher
    extends BaseNameMatcher {
        public PrefixNameMatcher(String patternText) {
            super(patternText);
        }

        @Override
        public final boolean accept(String name) {
            return name != null && name.startsWith(this.patternText);
        }
    }

    private static final class CaseInsensitiveExactNameMatcher
    extends BaseNameMatcher {
        public CaseInsensitiveExactNameMatcher(String patternText) {
            super(patternText);
        }

        @Override
        public final boolean accept(String name) {
            return this.patternText.equalsIgnoreCase(name);
        }
    }

    private static final class ExactNameMatcher
    extends BaseNameMatcher {
        public ExactNameMatcher(String patternText) {
            super(patternText);
        }

        @Override
        public final boolean accept(String name) {
            return this.patternText.equals(name);
        }
    }

    private static abstract class BaseNameMatcher
    implements NameMatcher {
        protected final String patternText;

        protected BaseNameMatcher(String patternText) {
            this.patternText = patternText;
        }
    }
}

