/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.options;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.options.EditorOptions;
import org.netbeans.modules.cnd.editor.options.PreviewPreferences;

public class PreviewPreferencesModel {
    private Map<CodeStyle.Language, Map<String, PreviewPreferences>> preferences = new ConcurrentHashMap<CodeStyle.Language, Map<String, PreviewPreferences>>();
    private Map<CodeStyle.Language, String> defaultStyles = new ConcurrentHashMap<CodeStyle.Language, String>();

    public Map<String, PreviewPreferences> getPrefences(CodeStyle.Language language) {
        return this.preferences.get((Object)language);
    }

    public synchronized void initLanguageMap(CodeStyle.Language language) {
        for (String style : EditorOptions.getAllStyles(language)) {
            this.initLanguageStylePreferences(language, style);
        }
        String def = this.defaultStyles.get((Object)language);
        if (def == null) {
            def = EditorOptions.getCurrentProfileId(language);
            this.defaultStyles.put(language, def);
        }
    }

    public Map<String, PreviewPreferences> getLanguagePreferences(CodeStyle.Language language) {
        return this.preferences.get((Object)language);
    }

    public String getLanguageDefaultStyle(CodeStyle.Language language) {
        return this.defaultStyles.get((Object)language);
    }

    public void setLanguageDefaultStyle(CodeStyle.Language language, String def) {
        this.defaultStyles.put(language, def);
    }

    private void initLanguageStylePreferences(CodeStyle.Language language, String styleId) {
        PreviewPreferences clone;
        Map<String, PreviewPreferences> prefs = this.preferences.get((Object)language);
        if (prefs == null) {
            prefs = new HashMap<String, PreviewPreferences>();
            this.preferences.put(language, prefs);
        }
        if ((clone = prefs.get(styleId)) == null) {
            clone = new PreviewPreferences(EditorOptions.getPreferences(language, styleId), language, styleId);
            prefs.put(styleId, clone);
        }
    }

    public Map<String, PreviewPreferences> clonePreferences(CodeStyle.Language language) {
        HashMap<String, PreviewPreferences> newAllPreferences = new HashMap<String, PreviewPreferences>();
        for (Map.Entry<String, PreviewPreferences> entry2 : this.getLanguagePreferences(language).entrySet()) {
            PreviewPreferences pref = entry2.getValue();
            PreviewPreferences newPref = new PreviewPreferences(pref, language, entry2.getKey());
            newAllPreferences.put(entry2.getKey(), newPref);
        }
        return newAllPreferences;
    }

    public void resetPreferences(CodeStyle.Language language, Map<String, PreviewPreferences> newPreferences) {
        this.preferences.put(language, newPreferences);
    }

    public void clear(CodeStyle.Language language) {
        this.preferences.remove((Object)language);
        this.defaultStyles.remove((Object)language);
    }

    public static enum Filter {
        TabsAndIndents,
        Alignment,
        Braces,
        BlankLines,
        Spaces,
        All;

    }
}

