/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.netbeans.lib.profiler.heap.AbstractLongMap;
import org.netbeans.lib.profiler.heap.NumberList;

class LongMap
extends AbstractLongMap {
    private NumberList referenceList;

    LongMap(int size, int idSize, int foffsetSize) throws FileNotFoundException, IOException {
        super(size, idSize, foffsetSize, foffsetSize + 4 + 1 + idSize + 4);
        this.referenceList = new NumberList(this.ID_SIZE);
    }

    @Override
    Entry createEntry(long index) {
        return new Entry(index);
    }

    @Override
    Entry createEntry(long index, long value) {
        return new Entry(index, value);
    }

    @Override
    Entry get(long key) {
        return (Entry)super.get(key);
    }

    @Override
    Entry put(long key, long value) {
        return (Entry)super.put(key, value);
    }

    void flush() {
        this.referenceList.flush();
    }

    long[] getBiggestObjectsByRetainedSize(int number) {
        TreeSet<RetainedSizeEntry> bigObjects = new TreeSet<RetainedSizeEntry>();
        long[] bigIds = new long[number];
        int min = 0;
        for (long index = 0L; index < this.fileSize; index += (long)this.ENTRY_SIZE) {
            long id = this.getID(index);
            if (id == 0L) continue;
            int retainedSize = this.createEntry(index).getRetainedSize();
            if (bigObjects.size() < number) {
                bigObjects.add(new RetainedSizeEntry(id, retainedSize));
                min = ((RetainedSizeEntry)bigObjects.last()).retainedSize;
                continue;
            }
            if (retainedSize <= min) continue;
            bigObjects.remove(bigObjects.last());
            bigObjects.add(new RetainedSizeEntry(id, retainedSize));
            min = ((RetainedSizeEntry)bigObjects.last()).retainedSize;
        }
        int i = 0;
        Iterator it = bigObjects.iterator();
        while (it.hasNext()) {
            bigIds[i++] = ((RetainedSizeEntry)it.next()).instanceId;
        }
        return bigIds;
    }

    private static class RetainedSizeEntry
    implements Comparable {
        private final long instanceId;
        private final int retainedSize;

        private RetainedSizeEntry(long id, int size) {
            this.instanceId = id;
            this.retainedSize = size;
        }

        public int compareTo(Object o) {
            RetainedSizeEntry other = (RetainedSizeEntry)o;
            int diff = other.retainedSize - this.retainedSize;
            if (diff == 0) {
                long idDiff = other.instanceId - this.instanceId;
                if (idDiff < 0L) {
                    return -1;
                }
                if (idDiff > 0L) {
                    return 1;
                }
                return 0;
            }
            return diff;
        }

        public boolean equals(Object obj) {
            RetainedSizeEntry other = (RetainedSizeEntry)obj;
            return this.instanceId == other.instanceId;
        }
    }

    class Entry
    extends AbstractLongMap.Entry {
        private static final byte NUMBER_LIST = 1;
        private static final byte GC_ROOT = 2;
        private static final byte TREE_OBJ = 4;
        private long offset;

        private Entry(long off) {
            this.offset = off;
        }

        private Entry(long off, long value) {
            this.offset = off;
            LongMap.this.putFoffset(this.offset + (long)LongMap.this.KEY_SIZE, value);
        }

        void setIndex(int index) {
            LongMap.this.dumpBuffer.putInt(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE, index);
        }

        int getIndex() {
            return LongMap.this.dumpBuffer.getInt(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE);
        }

        void setTreeObj() {
            byte flags = (byte)(this.getFlags() | 4);
            this.setFlags(flags);
        }

        boolean isTreeObj() {
            return (this.getFlags() & 4) != 0;
        }

        boolean hasOnlyOneReference() {
            return (this.getFlags() & 1) == 0;
        }

        void setNearestGCRootPointer(long instanceId) {
            byte flags = (byte)(this.getFlags() | 2);
            this.setFlags(flags);
            if ((flags & 1) != 0) {
                try {
                    LongMap.this.referenceList.putFirst(this.getReferencesPointer(), instanceId);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }

        long getNearestGCRootPointer() {
            try {
                byte flag = this.getFlags();
                if ((flag & 2) != 0) {
                    long ref = this.getReferencesPointer();
                    if ((flag & 1) != 0) {
                        return LongMap.this.referenceList.getFirstNumber(ref);
                    }
                    return ref;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return 0L;
        }

        void addReference(long instanceId) {
            try {
                byte flags = this.getFlags();
                long ref = this.getReferencesPointer();
                if ((flags & 1) == 0) {
                    if (ref == 0L) {
                        this.setReferencesPointer(instanceId);
                    } else if (ref != instanceId) {
                        this.setFlags((byte)(flags | 1));
                        long list = LongMap.this.referenceList.addFirstNumber(ref, instanceId);
                        this.setReferencesPointer(list);
                    }
                } else {
                    long newRef = LongMap.this.referenceList.addNumber(ref, instanceId);
                    if (newRef != ref) {
                        this.setReferencesPointer(newRef);
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        List getReferences() {
            byte flags = this.getFlags();
            long ref = this.getReferencesPointer();
            if ((flags & 1) == 0) {
                if (ref == 0L) {
                    return Collections.EMPTY_LIST;
                }
                return Collections.singletonList(new Long(ref));
            }
            try {
                return LongMap.this.referenceList.getNumbers(ref);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return Collections.EMPTY_LIST;
            }
        }

        long getOffset() {
            return LongMap.this.getFoffset(this.offset + (long)LongMap.this.KEY_SIZE);
        }

        void setRetainedSize(int size) {
            LongMap.this.dumpBuffer.putInt(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE + 4L + 1L + (long)LongMap.this.ID_SIZE, size);
        }

        int getRetainedSize() {
            return LongMap.this.dumpBuffer.getInt(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE + 4L + 1L + (long)LongMap.this.ID_SIZE);
        }

        private void setReferencesPointer(long instanceId) {
            LongMap.this.putID(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE + 4L + 1L, instanceId);
        }

        private long getReferencesPointer() {
            return LongMap.this.getID(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE + 4L + 1L);
        }

        private void setFlags(byte flags) {
            LongMap.this.dumpBuffer.putByte(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE + 4L, flags);
        }

        private byte getFlags() {
            return LongMap.this.dumpBuffer.getByte(this.offset + (long)LongMap.this.KEY_SIZE + (long)LongMap.this.FOFFSET_SIZE + 4L);
        }
    }
}

