/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.selectors;

import java.awt.Image;
import java.util.Collections;
import java.util.List;
import javax.swing.UIManager;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.checkout.ModuleListInformation;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.ModuleSelector;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.WaitNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

final class AliasesNode
extends AbstractNode {
    public static AliasesNode create(Client.Factory client, CVSRoot root) {
        AliasesNode node = new AliasesNode((Children)new AliasesChildren(client, root));
        node.setDisplayName(NbBundle.getMessage(AliasesNode.class, (String)"BK2005"));
        return node;
    }

    private AliasesNode(Children children) {
        super(children);
        this.setIconBaseWithExtension("org/netbeans/modules/versioning/system/cvss/ui/selectors/defaultFolder.gif");
    }

    public Image getIcon(int type) {
        Image img = null;
        if (type == 1) {
            img = (Image)UIManager.get("Nb.Explorer.Folder.icon");
        }
        if (img == null) {
            img = super.getIcon(type);
        }
        return img;
    }

    public Image getOpenedIcon(int type) {
        Image img = null;
        if (type == 1) {
            img = (Image)UIManager.get("Nb.Explorer.Folder.openedIcon");
        }
        if (img == null) {
            img = super.getIcon(type);
        }
        return img;
    }

    static class AliasNode
    extends AbstractNode {
        public static AliasNode create(ModuleListInformation alias) {
            String name = alias.getModuleName();
            Lookup lookup = Lookups.singleton((Object)name);
            AliasNode node = new AliasNode(Children.LEAF, lookup);
            node.setName(name);
            String paths = alias.getPaths();
            node.setShortDescription(paths);
            return node;
        }

        private AliasNode(Children children, Lookup lookup) {
            super(children, lookup);
            this.setIconBaseWithExtension("org/netbeans/modules/versioning/system/cvss/ui/selectors/defaultFolder.gif");
        }

        public Image getIcon(int type) {
            Image img = null;
            if (type == 1) {
                img = (Image)UIManager.get("Nb.Explorer.Folder.icon");
            }
            if (img == null) {
                img = super.getIcon(type);
            }
            return this.badge(img);
        }

        public Image getOpenedIcon(int type) {
            Image img = null;
            if (type == 1) {
                img = (Image)UIManager.get("Nb.Explorer.Folder.openedIcon");
            }
            if (img == null) {
                img = super.getIcon(type);
            }
            return this.badge(img);
        }

        private Image badge(Image image) {
            Image badge = ImageUtilities.loadImage((String)"org/netbeans/modules/versioning/system/cvss/ui/selectors/link.png", (boolean)true);
            return ImageUtilities.mergeImages((Image)image, (Image)badge, (int)0, (int)8);
        }
    }

    static class AliasesChildren
    extends Children.Keys
    implements Runnable {
        private final Client.Factory clientFactory;
        private final CVSRoot root;
        private RequestProcessor.Task task;

        public AliasesChildren(Client.Factory client, CVSRoot root) {
            this.clientFactory = client;
            this.root = root;
        }

        protected void addNotify() {
            super.addNotify();
            WaitNode waitNode = new WaitNode(NbBundle.getMessage(AliasesNode.class, (String)"BK2006"));
            this.setKeys(Collections.singleton(waitNode));
            this.task = CvsVersioningSystem.getInstance().getParallelRequestProcessor().post((Runnable)this);
        }

        protected void removeNotify() {
            this.task.cancel();
            this.setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof Node) {
                return new Node[]{(Node)key};
            }
            AliasNode alias = AliasNode.create((ModuleListInformation)key);
            return new Node[]{alias};
        }

        @Override
        public void run() {
            try {
                List<ModuleListInformation> aliases = ModuleSelector.listAliases(this.clientFactory.createClient(), this.root);
                this.setKeys(aliases);
            }
            catch (CommandException e) {
                this.setKeys(Collections.singleton(this.errorNode((Exception)((Object)e))));
            }
            catch (AuthenticationException e) {
                this.setKeys(Collections.singleton(this.errorNode((Exception)((Object)e))));
            }
        }

        private Node errorNode(Exception ex) {
            AbstractNode errorNode = new AbstractNode(Children.LEAF);
            errorNode.setDisplayName(NbBundle.getMessage(AliasesNode.class, (String)"BK2007"));
            errorNode.setShortDescription(ex.getLocalizedMessage());
            return errorNode;
        }
    }
}

