/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.ui.ModuleNode;
import org.netbeans.modules.j2ee.earproject.ui.customizer.EarProjectProperties;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class LogicalViewChildren
extends Children.Keys<ClassPathSupport.Item>
implements AntProjectListener {
    private final AntProjectHelper model;
    private ClassPathSupport cs;
    private final UpdateHelper updateHelper;
    private EarProject project;

    public LogicalViewChildren(AntProjectHelper antProjectHelper, EarProject earProject, UpdateHelper updateHelper, ClassPathSupport classPathSupport) {
        if (null == antProjectHelper) {
            throw new IllegalArgumentException("model cannot be null");
        }
        this.model = antProjectHelper;
        this.project = earProject;
        this.updateHelper = updateHelper;
        this.cs = classPathSupport;
    }

    protected void addNotify() {
        super.addNotify();
        this.model.addAntProjectListener((AntProjectListener)this);
        this.updateKeys();
    }

    private void updateKeys() {
        List<ClassPathSupport.Item> list = EarProjectProperties.getJarContentAdditional(this.project);
        ArrayList<ClassPathSupport.Item> arrayList = new ArrayList<ClassPathSupport.Item>();
        for (ClassPathSupport.Item item : list) {
            Project project;
            J2eeModuleProvider j2eeModuleProvider;
            if (item.getType() != 2 || item.getArtifact() == null || null == (j2eeModuleProvider = (J2eeModuleProvider)(project = item.getArtifact().getProject()).getLookup().lookup(J2eeModuleProvider.class))) continue;
            arrayList.add(item);
        }
        this.setKeys(arrayList);
    }

    protected void removeNotify() {
        this.model.removeAntProjectListener((AntProjectListener)this);
        this.setKeys(Collections.emptySet());
        super.removeNotify();
    }

    protected Node[] createNodes(ClassPathSupport.Item item) {
        return new Node[]{new ModuleNode(item, this.model.getProjectDirectory(), this.project, this.updateHelper, this.cs)};
    }

    public void modelChanged(Object object) {
        this.updateKeys();
    }

    public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogicalViewChildren.this.updateKeys();
            }
        });
    }

    public void propertiesChanged(AntProjectEvent antProjectEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogicalViewChildren.this.updateKeys();
            }
        });
    }
}

