/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorContent;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorModel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class NavigatorPanelUI
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private NavigatorContent content = new NavigatorContent();
    private BeanTreeView navigatorPane;
    private ExplorerManager explorerManager = new ExplorerManager();
    private final InstanceContent selectedNodes = new InstanceContent();
    private final Lookup lookup = new AbstractLookup((AbstractLookup.Content)this.selectedNodes);
    private boolean isBusy = false;

    public NavigatorPanelUI() {
        this.initComponents();
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.navigatorPane = new BeanTreeView();
        this.navigatorPane.setRootVisible(false);
        this.navigatorPane.setDropTarget(false);
        this.navigatorPane.setDragSource(false);
        this.add((Component)this.navigatorPane, "Center");
        this.explorerManager.setRootContext(this.content.getRoot());
        this.expandAll();
    }

    private void expandAll() {
        NavigatorModel model = this.content.getModel();
        if (model != null && model.getFilter().isExpandAll()) {
            this.navigatorPane.expandAll();
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    void setBusyState(boolean busy) {
        Cursor cursor = this.isBusy ? Cursor.getPredefinedCursor(3) : Cursor.getDefaultCursor();
        this.navigatorPane.setCursor(cursor);
    }

    void newContentReady() {
        this.explorerManager.setRootContext(this.content.getRoot());
        if (SwingUtilities.isEventDispatchThread()) {
            this.expandAll();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NavigatorPanelUI.this.expandAll();
                }
            });
        }
    }

    NavigatorContent getContent() {
        return this.content;
    }

    void selectNode(Node node) {
        try {
            this.explorerManager.setSelectedNodes(new Node[]{node});
        }
        catch (IllegalArgumentException ex) {
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    @Override
    public boolean requestFocusInWindow() {
        boolean result = super.requestFocusInWindow();
        this.navigatorPane.requestFocusInWindow();
        return result;
    }

    final Lookup getLookup() {
        return this.lookup;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            for (Node n : (Node[])evt.getOldValue()) {
                this.selectedNodes.remove((Object)n);
            }
            for (Node n : (Node[])evt.getNewValue()) {
                this.selectedNodes.add((Object)n);
            }
        }
    }
}

