/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.overridden.ComputeOverriding;
import org.netbeans.modules.java.editor.overridden.ElementDescription;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ClassStructure {
    public static ErrorDescription finalClass(HintContext hintContext) {
        ClassTree classTree = (ClassTree)hintContext.getPath().getLeaf();
        if (classTree.getModifiers().getFlags().contains((Object)Modifier.FINAL)) {
            return ErrorDescriptionFactory.forName(hintContext, classTree, NbBundle.getMessage(ClassStructure.class, (String)"MSG_FinalClass", (Object)classTree.getSimpleName()), FixFactory.removeModifiersFix(hintContext.getInfo(), TreePath.getPath(hintContext.getPath(), (Tree)classTree.getModifiers()), EnumSet.of(Modifier.FINAL), NbBundle.getMessage(ClassStructure.class, (String)"FIX_RemoveFinalFromClass", (Object)classTree.getSimpleName())), FixFactory.createSuppressWarningsFix(hintContext.getInfo(), hintContext.getPath(), "FinalClass"));
        }
        return null;
    }

    public static ErrorDescription finalMethod(HintContext hintContext) {
        MethodTree methodTree = (MethodTree)hintContext.getPath().getLeaf();
        if (methodTree.getModifiers().getFlags().contains((Object)Modifier.FINAL)) {
            return ErrorDescriptionFactory.forName(hintContext, methodTree, NbBundle.getMessage(ClassStructure.class, (String)"MSG_FinalMethod", (Object)methodTree.getName()), FixFactory.removeModifiersFix(hintContext.getInfo(), TreePath.getPath(hintContext.getPath(), (Tree)methodTree.getModifiers()), EnumSet.of(Modifier.FINAL), NbBundle.getMessage(ClassStructure.class, (String)"FIX_RemoveFinalFromMethod", (Object)methodTree.getName())), FixFactory.createSuppressWarningsFix(hintContext.getInfo(), hintContext.getPath(), "FinalMethod"));
        }
        return null;
    }

    public static ErrorDescription finalPrivateMethod(HintContext hintContext) {
        MethodTree methodTree = (MethodTree)hintContext.getPath().getLeaf();
        if (methodTree.getModifiers().getFlags().containsAll(EnumSet.of(Modifier.FINAL, Modifier.PRIVATE))) {
            return ErrorDescriptionFactory.forName(hintContext, methodTree, NbBundle.getMessage(ClassStructure.class, (String)"MSG_FinalPrivateMethod", (Object)methodTree.getName()), FixFactory.removeModifiersFix(hintContext.getInfo(), TreePath.getPath(hintContext.getPath(), (Tree)methodTree.getModifiers()), EnumSet.of(Modifier.FINAL), NbBundle.getMessage(ClassStructure.class, (String)"FIX_RemoveFinalFromMethod", (Object)methodTree.getName())), FixFactory.createSuppressWarningsFix(hintContext.getInfo(), hintContext.getPath(), "FinalPrivateMethod"));
        }
        return null;
    }

    public static ErrorDescription finalStaticMethod(HintContext hintContext) {
        MethodTree methodTree = (MethodTree)hintContext.getPath().getLeaf();
        if (methodTree.getModifiers().getFlags().containsAll(EnumSet.of(Modifier.FINAL, Modifier.STATIC))) {
            return ErrorDescriptionFactory.forName(hintContext, methodTree, NbBundle.getMessage(ClassStructure.class, (String)"MSG_FinalStaticMethod", (Object)methodTree.getName()), FixFactory.removeModifiersFix(hintContext.getInfo(), TreePath.getPath(hintContext.getPath(), (Tree)methodTree.getModifiers()), EnumSet.of(Modifier.FINAL), NbBundle.getMessage(ClassStructure.class, (String)"FIX_RemoveFinalFromMethod", (Object)methodTree.getName())), FixFactory.createSuppressWarningsFix(hintContext.getInfo(), hintContext.getPath(), "FinalStaticMethod"));
        }
        return null;
    }

    public static ErrorDescription finalMethodInFinalClass(HintContext hintContext) {
        MethodTree methodTree = (MethodTree)hintContext.getPath().getLeaf();
        Tree tree = hintContext.getPath().getParentPath().getLeaf();
        if (tree.getKind() == Tree.Kind.CLASS && methodTree.getModifiers().getFlags().contains((Object)Modifier.FINAL) && ((ClassTree)tree).getModifiers().getFlags().contains((Object)Modifier.FINAL)) {
            return ErrorDescriptionFactory.forName(hintContext, methodTree, NbBundle.getMessage(ClassStructure.class, (String)"MSG_FinalMethodInFinalClass", (Object)methodTree.getName()), FixFactory.removeModifiersFix(hintContext.getInfo(), TreePath.getPath(hintContext.getPath(), (Tree)methodTree.getModifiers()), EnumSet.of(Modifier.FINAL), NbBundle.getMessage(ClassStructure.class, (String)"FIX_RemoveFinalFromMethod", (Object)methodTree.getName())), FixFactory.createSuppressWarningsFix(hintContext.getInfo(), hintContext.getPath(), "FinalMethodInFinalClass"));
        }
        return null;
    }

    public static ErrorDescription noopMethodInAbstractClass(HintContext hintContext) {
        BlockTree blockTree;
        MethodTree methodTree = (MethodTree)hintContext.getPath().getLeaf();
        Tree tree = hintContext.getPath().getParentPath().getLeaf();
        if (tree.getKind() == Tree.Kind.CLASS && ((ClassTree)tree).getModifiers().getFlags().contains((Object)Modifier.ABSTRACT) && (blockTree = methodTree.getBody()) != null && blockTree.getStatements().isEmpty()) {
            return ErrorDescriptionFactory.forName(hintContext, methodTree, NbBundle.getMessage(ClassStructure.class, (String)"MSG_NoopMethodInAbstractClass", (Object)methodTree.getName()), FixFactory.createSuppressWarningsFix(hintContext.getInfo(), hintContext.getPath(), "NoopMethodInAbstractClass"));
        }
        return null;
    }

    public static ErrorDescription publicConstructorInNonPublicClass(HintContext hintContext) {
        MethodTree methodTree = (MethodTree)hintContext.getPath().getLeaf();
        Tree tree = hintContext.getPath().getParentPath().getLeaf();
        if (tree.getKind() == Tree.Kind.CLASS && methodTree.getReturnType() == null && "<init>".contentEquals(methodTree.getName()) && methodTree.getModifiers().getFlags().contains((Object)Modifier.PUBLIC) && !((ClassTree)tree).getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) {
            return ErrorDescriptionFactory.forName(hintContext, methodTree, NbBundle.getMessage(ClassStructure.class, (String)"MSG_PublicConstructorInNonPublicClass", (Object)methodTree.getName()), FixFactory.removeModifiersFix(hintContext.getInfo(), TreePath.getPath(hintContext.getPath(), (Tree)methodTree.getModifiers()), EnumSet.of(Modifier.PUBLIC), NbBundle.getMessage(ClassStructure.class, (String)"FIX_RemovePublicFromConstructor")), FixFactory.createSuppressWarningsFix(hintContext.getInfo(), hintContext.getPath(), "PublicConstructorInNonPublicClass"));
        }
        return null;
    }

    public static ErrorDescription protectedMemberInFinalClass(HintContext hintContext) {
        Tree tree = hintContext.getPath().getLeaf();
        Tree tree2 = hintContext.getPath().getParentPath().getLeaf();
        if (tree2.getKind() == Tree.Kind.CLASS) {
            if (tree.getKind() == Tree.Kind.METHOD) {
                MethodTree methodTree = (MethodTree)tree;
                if (methodTree.getModifiers().getFlags().contains((Object)Modifier.PROTECTED) && ((ClassTree)tree2).getModifiers().getFlags().contains((Object)Modifier.FINAL)) {
                    Element element = hintContext.getInfo().getTrees().getElement(hintContext.getPath());
                    if (element == null || element.getKind() != ElementKind.METHOD) {
                        return null;
                    }
                    LinkedList linkedList = new LinkedList();
                    ComputeOverriding.detectOverrides((CompilationInfo)hintContext.getInfo(), (TypeElement)((TypeElement)element.getEnclosingElement()), (ExecutableElement)((ExecutableElement)element), linkedList);
                    for (ElementDescription elementDescription : linkedList) {
                        Element element2 = elementDescription.getHandle().resolve(hintContext.getInfo());
                        if (element2 == null || !element2.getModifiers().contains((Object)Modifier.PROTECTED) && !element2.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                        return null;
                    }
                    return ErrorDescriptionFactory.forName(hintContext, methodTree, NbBundle.getMessage(ClassStructure.class, (String)"MSG_ProtectedMethodInFinalClass", (Object)methodTree.getName()), FixFactory.removeModifiersFix(hintContext.getInfo(), TreePath.getPath(hintContext.getPath(), (Tree)methodTree.getModifiers()), EnumSet.of(Modifier.PROTECTED), NbBundle.getMessage(ClassStructure.class, (String)"FIX_RemoveProtectedFromMethod", (Object)methodTree.getName())), FixFactory.createSuppressWarningsFix(hintContext.getInfo(), hintContext.getPath(), "ProtectedMemberInFinalClass"));
                }
            } else {
                VariableTree variableTree = (VariableTree)tree;
                if (variableTree.getModifiers().getFlags().contains((Object)Modifier.PROTECTED) && ((ClassTree)tree2).getModifiers().getFlags().contains((Object)Modifier.FINAL)) {
                    return ErrorDescriptionFactory.forName(hintContext, variableTree, NbBundle.getMessage(ClassStructure.class, (String)"MSG_ProtectedFieldInFinalClass", (Object)variableTree.getName()), FixFactory.removeModifiersFix(hintContext.getInfo(), TreePath.getPath(hintContext.getPath(), (Tree)variableTree.getModifiers()), EnumSet.of(Modifier.PROTECTED), NbBundle.getMessage(ClassStructure.class, (String)"FIX_RemoveProtectedFromField", (Object)variableTree.getName())), FixFactory.createSuppressWarningsFix(hintContext.getInfo(), hintContext.getPath(), "ProtectedMemberInFinalClass"));
                }
            }
        }
        return null;
    }

    public static ErrorDescription markerInterface(HintContext hintContext) {
        ClassTree classTree = (ClassTree)hintContext.getPath().getLeaf();
        if (hintContext.getInfo().getTreeUtilities().isInterface(classTree) && classTree.getMembers().isEmpty() && classTree.getImplementsClause().size() < 2) {
            return ErrorDescriptionFactory.forName(hintContext, classTree, NbBundle.getMessage(ClassStructure.class, (String)"MSG_MarkerInterface", (Object)classTree.getSimpleName()), FixFactory.createSuppressWarningsFix(hintContext.getInfo(), hintContext.getPath(), "MarkerInterface"));
        }
        return null;
    }

    public static ErrorDescription classMayBeInterface(HintContext hintContext) {
        ClassTree classTree = (ClassTree)hintContext.getPath().getLeaf();
        TreeUtilities treeUtilities = hintContext.getInfo().getTreeUtilities();
        if (treeUtilities.isClass(classTree) && ClassStructure.testClassMayBeInterface(hintContext.getInfo().getTrees(), treeUtilities, hintContext.getPath())) {
            return ErrorDescriptionFactory.forName(hintContext, classTree, NbBundle.getMessage(ClassStructure.class, (String)"MSG_ClassMayBeInterface", (Object)classTree.getSimpleName()), new ConvertClassToInterfaceFixImpl(TreePathHandle.create((TreePath)hintContext.getPath(), (CompilationInfo)hintContext.getInfo()), NbBundle.getMessage(ClassStructure.class, (String)"FIX_ConvertClassToInterface", (Object)classTree.getSimpleName())), FixFactory.createSuppressWarningsFix(hintContext.getInfo(), hintContext.getPath(), "ClassMayBeInterface"));
        }
        return null;
    }

    public static ErrorDescription multipleTopLevelClassesInFile(HintContext hintContext) {
        List<? extends Tree> list;
        ClassTree classTree = (ClassTree)hintContext.getPath().getLeaf();
        Tree tree = hintContext.getPath().getParentPath().getLeaf();
        if (tree.getKind() == Tree.Kind.COMPILATION_UNIT && (list = ((CompilationUnitTree)tree).getTypeDecls()).size() > 1 && list.get(0) != classTree) {
            return ErrorDescriptionFactory.forName(hintContext, classTree, NbBundle.getMessage(ClassStructure.class, (String)"MSG_MultipleTopLevelClassesInFile"), FixFactory.createSuppressWarningsFix(hintContext.getInfo(), hintContext.getPath(), "MultipleTopLevelClassesInFile"));
        }
        return null;
    }

    private static boolean testClassMayBeInterface(Trees trees, TreeUtilities treeUtilities, TreePath treePath) {
        TypeMirror typeMirror;
        ClassTree classTree = (ClassTree)treePath.getLeaf();
        if (!treeUtilities.isClass(classTree)) {
            return true;
        }
        Element element = trees.getElement(treePath);
        TypeMirror typeMirror2 = typeMirror = element.getKind().isClass() ? ((TypeElement)element).getSuperclass() : null;
        if (typeMirror == null || typeMirror.getKind() != TypeKind.DECLARED || !"java.lang.Object".contentEquals(((TypeElement)((DeclaredType)typeMirror).asElement()).getQualifiedName())) {
            return false;
        }
        block5: for (Tree tree : classTree.getMembers()) {
            TreePath treePath2 = TreePath.getPath(treePath, tree);
            if (treeUtilities.isSynthetic(treePath2)) continue;
            switch (tree.getKind()) {
                case VARIABLE: {
                    if (((VariableTree)tree).getModifiers().getFlags().containsAll(EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL))) continue block5;
                    return false;
                }
                case METHOD: {
                    if (((MethodTree)tree).getModifiers().getFlags().containsAll(EnumSet.of(Modifier.PUBLIC, Modifier.ABSTRACT))) continue block5;
                    return false;
                }
                case CLASS: {
                    if (ClassStructure.testClassMayBeInterface(trees, treeUtilities, treePath2)) continue block5;
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    private static final class ConvertClassToInterfaceFixImpl
    implements Fix {
        private final TreePathHandle clsHandle;
        private final String text;

        public ConvertClassToInterfaceFixImpl(TreePathHandle treePathHandle, String string) {
            this.clsHandle = treePathHandle;
            this.text = string;
        }

        public String getText() {
            return this.text;
        }

        public ChangeInfo implement() throws Exception {
            JavaSource.forFileObject((FileObject)this.clsHandle.getFileObject()).runModificationTask((Task)new Task<WorkingCopy>(){

                public void run(WorkingCopy workingCopy) throws Exception {
                    workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                    TreePath treePath = ConvertClassToInterfaceFixImpl.this.clsHandle.resolve((CompilationInfo)workingCopy);
                    if (treePath == null) {
                        return;
                    }
                    ClassTree classTree = (ClassTree)treePath.getLeaf();
                    TreeMaker treeMaker = workingCopy.getTreeMaker();
                    ModifiersTree modifiersTree = classTree.getModifiers();
                    if (modifiersTree.getFlags().contains((Object)Modifier.ABSTRACT)) {
                        EnumSet<Modifier> enumSet = EnumSet.copyOf(modifiersTree.getFlags());
                        enumSet.remove((Object)Modifier.ABSTRACT);
                        modifiersTree = treeMaker.Modifiers(enumSet, modifiersTree.getAnnotations());
                    }
                    workingCopy.rewrite(treePath.getLeaf(), (Tree)treeMaker.Interface(modifiersTree, (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getImplementsClause(), classTree.getMembers()));
                }
            }).commit();
            return null;
        }
    }
}

