/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.encapsulation;

import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class ParamEncapsulation {
    private static final String COLLECTION = "java.util.Collection";
    private static final String MAP = "java.util.Map";
    private static final String DATE = "java.util.Date";
    private static final String CALENDAR = "java.util.Calendar";
    private static final String A_OBJ = "java.lang.Object[]";
    private static final String A_BOOL = "boolean[]";
    private static final String A_BYTE = "byte[]";
    private static final String A_CHAR = "char[]";
    private static final String A_SHORT = "short[]";
    private static final String A_INT = "int[]";
    private static final String A_LONG = "long[]";
    private static final String A_FLOAT = "float[]";
    private static final String A_DOUBLE = "double[]";

    public static ErrorDescription collection(HintContext hintContext) {
        assert (hintContext != null);
        return ParamEncapsulation.create(hintContext, NbBundle.getMessage(ParamEncapsulation.class, (String)"TXT_AssignmentToCollection"), "AssignmentToCollectionOrArrayFieldFromParameter");
    }

    public static ErrorDescription array(HintContext hintContext) {
        assert (hintContext != null);
        return ParamEncapsulation.create(hintContext, NbBundle.getMessage(ParamEncapsulation.class, (String)"TXT_AssignmentToArray"), "AssignmentToCollectionOrArrayFieldFromParameter");
    }

    public static ErrorDescription date(HintContext hintContext) {
        assert (hintContext != null);
        return ParamEncapsulation.create(hintContext, NbBundle.getMessage(ParamEncapsulation.class, (String)"TXT_AssignmentToDate"), "AssignmentToDateFieldFromParameter");
    }

    private static ErrorDescription create(HintContext hintContext, String string, String string2) {
        assert (hintContext != null);
        TreePath treePath = hintContext.getVariables().get("$var");
        assert (treePath != null);
        Trees trees = hintContext.getInfo().getTrees();
        Element element = trees.getElement(treePath);
        if (element == null || element.getKind() != ElementKind.FIELD) {
            return null;
        }
        Element element2 = element.getEnclosingElement();
        if (element2 == null || !element2.getKind().isClass()) {
            return null;
        }
        TreePath treePath2 = hintContext.getVariables().get("$expr");
        Element element3 = trees.getElement(treePath2);
        if (element3 == null || element3.getKind() != ElementKind.PARAMETER) {
            return null;
        }
        Element element4 = element3.getEnclosingElement();
        if (element4 == null || element4.getKind() != ElementKind.METHOD || !((ExecutableElement)element4).getParameters().contains(element3) || element2 != element4.getEnclosingElement()) {
            return null;
        }
        return ErrorDescriptionFactory.forName(hintContext, treePath, string, FixFactory.createSuppressWarningsFix(hintContext.getInfo(), treePath, string2));
    }
}

