/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspcompiler;

import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.netbeans.modules.web.jspcompiler.SmapReader;

public class SmapResolver {
    private static final String SMAP_HEADER = "SMAP";
    private static final String DEFAULT_STRATUM = "JSP";
    private static final String STRATUM_SECTION = "*S JSP";
    private static final String LINE_SECTION = "*L";
    private static final String FILE_SECTION = "*F";
    private static final String END_SECTION = "*E";
    private static final String FID_DELIM = "#";
    private SmapReader reader = null;
    private boolean resolved = false;
    private String defaultStratum = null;
    private String outputFileName = null;
    private Hashtable fsection = new Hashtable(3);
    private Map jsp2java = new TreeMap();
    private Map java2jsp = new TreeMap();

    public SmapResolver(SmapReader smapReader) {
        this.resolved = this.resolve(smapReader.readSmap());
        this.reader = smapReader;
    }

    public String toString() {
        return this.reader.toString();
    }

    private boolean resolve(String string) {
        String string2 = "";
        if (string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", false);
        boolean bl = true;
        int n = 0;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (bl) {
                if (!SMAP_HEADER.equals(string4)) {
                    return false;
                }
                bl = false;
                string2 = SMAP_HEADER;
                continue;
            }
            if (STRATUM_SECTION.equals(string4)) {
                string2 = STRATUM_SECTION;
                continue;
            }
            if (FILE_SECTION.equals(string4)) {
                string2 = FILE_SECTION;
                n = 0;
                continue;
            }
            if (LINE_SECTION.equals(string4)) {
                string2 = LINE_SECTION;
                n = 0;
                string3 = "0";
                continue;
            }
            if (END_SECTION.equals(string4)) {
                string2 = END_SECTION;
                break;
            }
            if (SMAP_HEADER.equals(string2)) {
                if (n == 0) {
                    this.outputFileName = string4;
                }
                if (n == 1) {
                    this.defaultStratum = string4;
                }
            }
            if (FILE_SECTION.equals(string2)) {
                if (string4.startsWith("+")) {
                    ++n;
                    String string5 = string4;
                    string4 = stringTokenizer.nextToken();
                    this.storeFile(string5, string4);
                } else {
                    this.storeFile(string4, null);
                }
            }
            if (LINE_SECTION.equals(string2)) {
                int n2 = string4.indexOf(FID_DELIM);
                if (n2 > -1 && (string3 = string4.substring(n2 + 1, string4.indexOf(58))) != null && string3.indexOf(44) > -1) {
                    string3 = string3.substring(0, string3.indexOf(44));
                }
                this.storeLine(string4, string3);
            }
            ++n;
        }
        this.resolved = this.sanityCheck();
        return this.resolved;
    }

    private void storeFile(String string, String string2) {
        String string3 = "";
        String string4 = "";
        int n = 0;
        if (string != null && string.startsWith("+")) {
            string = string.substring(2);
            n = string.indexOf(" ");
            string3 = string.substring(0, n);
            string4 = string2;
        } else {
            n = string.indexOf(" ");
            string3 = string.substring(0, n);
            string4 = string.substring(n + 1);
        }
        this.fsection.put(string3, string4);
    }

    private void storeLine(String string, String string2) {
        int n;
        int n2;
        int n3 = string.indexOf(":");
        String string3 = string.substring(0, n3);
        String string4 = string.substring(n3 + 1);
        int n4 = string3.indexOf(FID_DELIM);
        int n5 = string3.indexOf(44);
        int n6 = 0;
        int n7 = 0;
        if (n5 != -1) {
            n7 = Integer.parseInt(string3.substring(n5 + 1));
            n6 = n4 == -1 ? Integer.parseInt(string3.substring(0, n5)) : Integer.parseInt(string3.substring(0, n4));
        } else {
            n6 = n4 == -1 ? Integer.parseInt(string3) : Integer.parseInt(string3.substring(0, n4));
            n7 = 1;
        }
        n5 = string4.indexOf(44);
        if (n5 != -1) {
            n2 = Integer.parseInt(string4.substring(n5 + 1));
            n = Integer.parseInt(string4.substring(0, n5));
        } else {
            n2 = 1;
            n = Integer.parseInt(string4);
        }
        for (int i = 0; i < n7; ++i) {
            int n8 = n6 + i;
            int n9 = n + i * n2;
            string3 = Integer.toString(n8).concat(FID_DELIM).concat(string2);
            string4 = Integer.toString(n9);
            if (!this.jsp2java.containsKey(string3)) {
                this.jsp2java.put(string3, string4);
            }
            string3 = Integer.toString(n8).concat(FID_DELIM).concat(string2);
            string4 = Integer.toString(n9);
            if (this.java2jsp.containsKey(string4)) continue;
            this.java2jsp.put(string4, string3);
        }
    }

    private boolean sanityCheck() {
        if (!DEFAULT_STRATUM.equals(this.defaultStratum)) {
            return false;
        }
        if (!this.outputFileName.endsWith(".java")) {
            return false;
        }
        if (this.fsection.isEmpty()) {
            return false;
        }
        if (this.jsp2java.isEmpty()) {
            return false;
        }
        return !this.java2jsp.isEmpty();
    }

    private String getFileNameByIndex(String string) {
        return (String)this.fsection.get(string);
    }

    private String getIndexByFileName(String string) {
        Set set = this.fsection.entrySet();
        for (Map.Entry entry : set) {
            String string2 = (String)entry.getValue();
            if (!string2.equalsIgnoreCase(string)) continue;
            return entry.getKey().toString();
        }
        return null;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public Map getFileNames() {
        Hashtable hashtable = new Hashtable(this.fsection.size());
        Collection collection = this.fsection.values();
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            hashtable.put(new Integer(n++), iterator.next());
        }
        return hashtable;
    }

    public String getPrimaryJspFileName() {
        TreeMap treeMap = new TreeMap(this.fsection);
        Object k = treeMap.firstKey();
        String string = (String)this.fsection.get(k);
        return string;
    }

    public boolean hasIncludedFiles() {
        return this.fsection.size() > 1;
    }

    public String getJavaLineType(int n, int n2) {
        return null;
    }

    public boolean isEmpty() {
        return this.jsp2java.isEmpty();
    }

    public String getJspFileName(int n, int n2) throws IOException {
        String string = Integer.toString(n);
        String string2 = (String)this.java2jsp.get(string);
        if (string2 == null) {
            return null;
        }
        String string3 = string2.substring(string2.indexOf(FID_DELIM) + 1);
        return this.getFileNameByIndex(string3);
    }

    public int mangle(String string, int n, int n2) {
        String string2 = this.getIndexByFileName(string);
        if (string2 == null) {
            return -1;
        }
        String string3 = "".concat(Integer.toString(n)).concat(FID_DELIM).concat(string2);
        String string4 = (String)this.jsp2java.get(string3);
        if (string4 == null) {
            return -1;
        }
        return Integer.parseInt(string4);
    }

    public int unmangle(int n, int n2) {
        String string = Integer.toString(n);
        String string2 = (String)this.java2jsp.get(string);
        if (string2 == null) {
            return -1;
        }
        int n3 = Integer.parseInt(string2.substring(0, string2.indexOf(FID_DELIM)));
        return n3;
    }
}

