/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.common;

import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.common.Profiler;

public final class SessionSettings {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.lib.profiler.common.Bundle");
    private static final String INCORRECT_PORT_MSG = bundle.getString("SessionSettings_IncorrectPortMsg");
    private static final String INCORRECT_ARCH_MSG = bundle.getString("SessionSettings_IncorrectArchMsg");
    public static final String PROP_CLASS_NAME = "profiler.session.class.name";
    public static final String PROP_CLASS_PATH = "profiler.session.class.path";
    public static final String PROP_ARGS = "profiler.session.args";
    public static final String PROP_JVM_ARGS = "profiler.session.jvm.args";
    public static final String PROP_WORKING_DIR = "profiler.session.working.dir";
    public static final String PROP_JAVA_EXECUTABLE = "profiler.session.java.executable";
    public static final String PROP_JAVA_VERSION = "profiler.session.java.version";
    public static final String PROP_ARCHITECTURE = "profiler.session.java.architecture";
    public static final String PROP_PORT_NO = "profiler.session.port.no";
    private String javaExecutable = "";
    private String javaVersionString = "";
    private String jvmArgs = "";
    private String mainArgs = "";
    private String mainClass = "";
    private String mainClassPath = "";
    private String workingDir = System.getProperty("user.dir");
    private int architecture = 32;
    private int portNo = 5140;

    public void setJVMArgs(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.jvmArgs = value;
    }

    public String getJVMArgs() {
        return this.jvmArgs;
    }

    public void setJavaExecutable(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.javaExecutable = value;
    }

    public String getJavaExecutable() {
        return this.javaExecutable;
    }

    public void setJavaVersionString(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.javaVersionString = value;
    }

    public String getJavaVersionString() {
        return this.javaVersionString;
    }

    public void setMainArgs(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.mainArgs = value;
    }

    public String getMainArgs() {
        return this.mainArgs;
    }

    public void setMainClass(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.mainClass = value;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClassPath(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.mainClassPath = value;
    }

    public String getMainClassPath() {
        return this.mainClassPath;
    }

    public void setPortNo(int value) {
        this.portNo = value;
    }

    public int getPortNo() {
        return this.portNo;
    }

    public void setSystemArchitecture(int value) {
        this.architecture = value;
    }

    public int getSystemArchitecture() {
        return this.architecture;
    }

    public void setWorkingDir(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.workingDir = value;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void applySettings(ProfilerEngineSettings settings) {
        settings.setMainClass(this.mainClass);
        settings.setMainClassPath(this.mainClassPath);
        settings.setMainArgs(this.mainArgs);
        settings.setJVMArgs(this.jvmArgs);
        settings.setWorkingDir(this.workingDir);
        settings.setTargetJVMExeFile(this.javaExecutable);
        settings.setTargetJDKVersionString(this.javaVersionString);
        settings.setSystemArchitecture(this.architecture);
        settings.setPortNo(this.portNo);
    }

    public String debug() {
        StringBuffer sb = new StringBuffer();
        sb.append("mainClass: " + this.mainClass);
        sb.append('\n');
        sb.append("mainClassPath: " + this.mainClassPath);
        sb.append('\n');
        sb.append("mainArgs: " + this.mainArgs);
        sb.append('\n');
        sb.append("jvmArgs =" + this.jvmArgs);
        sb.append('\n');
        sb.append("workingDir =" + this.workingDir);
        sb.append('\n');
        sb.append("javaExecutable =" + this.javaExecutable);
        sb.append('\n');
        sb.append("javaVersionString =" + this.javaVersionString);
        sb.append('\n');
        sb.append("architecture =" + this.architecture);
        sb.append('\n');
        sb.append("portNo =" + this.portNo);
        sb.append('\n');
        return sb.toString();
    }

    public void load(Map props) {
        this.setMainClass(SessionSettings.getProperty(props, PROP_CLASS_NAME, ""));
        this.setMainClassPath(SessionSettings.getProperty(props, PROP_CLASS_PATH, ""));
        this.setMainArgs(SessionSettings.getProperty(props, PROP_ARGS, ""));
        this.setJVMArgs(SessionSettings.getProperty(props, PROP_JVM_ARGS, ""));
        this.setWorkingDir(SessionSettings.getProperty(props, PROP_WORKING_DIR, System.getProperty("user.home")));
        this.setJavaExecutable(SessionSettings.getProperty(props, PROP_JAVA_EXECUTABLE, ""));
        this.setJavaVersionString(SessionSettings.getProperty(props, PROP_JAVA_VERSION, ""));
        String arch = SessionSettings.getProperty(props, PROP_ARCHITECTURE, String.valueOf(32));
        try {
            this.setSystemArchitecture(Integer.parseInt(arch));
        }
        catch (NumberFormatException e) {
            Profiler.getDefault().displayWarning(INCORRECT_ARCH_MSG);
            this.architecture = 32;
        }
        String port = SessionSettings.getProperty(props, PROP_PORT_NO, "5140");
        try {
            this.setPortNo(Integer.parseInt(port));
        }
        catch (NumberFormatException e) {
            Profiler.getDefault().displayWarning(INCORRECT_PORT_MSG);
            this.portNo = 5140;
        }
    }

    public void store(Map props) {
        props.put(PROP_CLASS_NAME, this.mainClass);
        props.put(PROP_CLASS_PATH, this.mainClassPath);
        props.put(PROP_ARGS, this.mainArgs);
        props.put(PROP_JVM_ARGS, this.jvmArgs);
        props.put(PROP_WORKING_DIR, this.workingDir);
        props.put(PROP_JAVA_EXECUTABLE, this.javaExecutable);
        props.put(PROP_JAVA_VERSION, this.javaVersionString);
        props.put(PROP_ARCHITECTURE, Integer.toString(this.architecture));
        props.put(PROP_PORT_NO, Integer.toString(this.portNo));
    }

    private static String getProperty(Map props, String key, String defaultValue) {
        String ret = (String)props.get(key);
        if (ret == null) {
            ret = defaultValue;
        }
        return ret;
    }
}

