/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.converter.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.vmd.midp.converter.wizard.Converter;
import org.openide.DialogDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ConvertPanel
extends JPanel
implements ActionListener,
Runnable,
DocumentListener {
    private DialogDescriptor descriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(ConvertPanel.class, (String)"TITLE_ConvertPanel"));
    private JButton startButton = new JButton(NbBundle.getMessage(ConvertPanel.class, (String)"DISP_Start"));
    private JButton finishButton = new JButton(NbBundle.getMessage(ConvertPanel.class, (String)"DISP_Close"));
    private FileObject inputPrimaryFile;
    private FileObject inputSecondaryFile;
    private FileObject outputDirectory;
    private JLabel finishIcon;
    private JLabel finishMessage;
    private JTextField inputFileName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel message;
    private JTextField outputFileName;
    private JProgressBar progress;

    public ConvertPanel() {
        this.initComponents();
        ImageIcon imageIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/vmd/midp/resources/warning.gif", (boolean)false);
        this.finishIcon.setIcon(imageIcon);
        this.message.setIcon(imageIcon);
        this.startButton.setDefaultCapable(true);
        this.startButton.addActionListener(this);
        this.finishButton.setDefaultCapable(true);
        this.descriptor.setClosingOptions(new Object[]{this.finishButton, DialogDescriptor.CANCEL_OPTION});
    }

    public DialogDescriptor getDialogDescriptor() {
        return this.descriptor;
    }

    public void switchToShown(FileObject fileObject, FileObject fileObject2, FileObject fileObject3) {
        this.inputPrimaryFile = fileObject;
        this.inputSecondaryFile = fileObject2;
        this.outputDirectory = fileObject3;
        this.inputFileName.setText(fileObject.getName());
        this.progress.setIndeterminate(false);
        this.progress.setValue(100);
        this.finishIcon.setVisible(false);
        this.finishMessage.setText(NbBundle.getMessage(ConvertPanel.class, (String)"MSG_ShownMessage"));
        this.startButton.setEnabled(true);
        this.descriptor.setOptions(new Object[]{this.startButton, DialogDescriptor.CANCEL_OPTION});
        this.outputFileName.getDocument().removeDocumentListener(this);
        this.outputFileName.getDocument().addDocumentListener(this);
        this.outputFileName.setText("Converted" + fileObject.getName());
        this.outputFileName.setEditable(true);
        this.outputFileName.selectAll();
        this.outputFileName.requestFocus();
    }

    public void switchToStarted() {
        this.outputFileName.getDocument().removeDocumentListener(this);
        this.outputFileName.setEditable(false);
        this.progress.setIndeterminate(true);
        this.finishMessage.setText(NbBundle.getMessage(ConvertPanel.class, (String)"MSG_StartMessage"));
        this.startButton.setEnabled(false);
        this.descriptor.setOptions(new Object[0]);
    }

    public void switchToFinished() {
        this.progress.setIndeterminate(false);
        this.progress.setValue(100);
        this.finishIcon.setVisible(true);
        this.finishMessage.setText(NbBundle.getMessage(ConvertPanel.class, (String)"MSG_FinishMessage"));
        this.descriptor.setOptions(new Object[]{this.finishButton});
    }

    public void switchToErrors(ArrayList<String> arrayList) {
        this.progress.setIndeterminate(false);
        this.progress.setValue(100);
        this.finishIcon.setVisible(true);
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : arrayList) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        this.finishMessage.setText(stringBuffer.toString());
        this.descriptor.setOptions(new Object[]{this.finishButton});
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.checkErrors();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.checkErrors();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.checkErrors();
    }

    private void checkErrors() {
        boolean bl = this.outputDirectory.getFileObject(this.outputFileName.getText(), "java") != null || this.outputDirectory.getFileObject(this.outputFileName.getText(), "vmd") != null;
        this.message.setVisible(bl);
        this.startButton.setEnabled(!bl);
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.inputFileName = new JTextField();
        this.jLabel1 = new JLabel();
        this.outputFileName = new JTextField();
        JSeparator jSeparator = new JSeparator();
        this.progress = new JProgressBar();
        this.finishMessage = new JLabel();
        this.finishIcon = new JLabel();
        this.message = new JLabel();
        this.setPreferredSize(new Dimension(500, 400));
        this.jLabel2.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/vmd/midp/converter/wizard/Bundle").getString("ConvertPanel.jLabel1.mnemonic").charAt(0));
        this.jLabel2.setLabelFor(this.inputFileName);
        this.jLabel2.setText(NbBundle.getMessage(ConvertPanel.class, (String)"ConvertPanel.jLabel2.text"));
        this.inputFileName.setEditable(false);
        this.inputFileName.setText(NbBundle.getMessage(ConvertPanel.class, (String)"ConvertPanel.inputFileName.text"));
        this.jLabel1.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/vmd/midp/converter/wizard/Bundle").getString("ConvertPanel.jLabel2.mnemonic").charAt(0));
        this.jLabel1.setLabelFor(this.outputFileName);
        this.jLabel1.setText(NbBundle.getMessage(ConvertPanel.class, (String)"ConvertPanel.jLabel1.text"));
        this.outputFileName.setText(NbBundle.getMessage(ConvertPanel.class, (String)"ConvertPanel.outputFileName.text"));
        this.finishMessage.setVerticalAlignment(1);
        this.finishIcon.setText(NbBundle.getMessage(ConvertPanel.class, (String)"ConvertPanel.finishIcon.text"));
        this.finishIcon.setPreferredSize(new Dimension(16, 16));
        this.message.setText(NbBundle.getMessage(ConvertPanel.class, (String)"ConvertPanel.message.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.finishIcon, -2, -1, -2).addPreferredGap(0).add((Component)this.finishMessage, -1, 460, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.jLabel2, -1, -1, Short.MAX_VALUE).add((Component)this.jLabel1, -1, 127, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.outputFileName, -1, 349, Short.MAX_VALUE).add((Component)this.inputFileName, -1, 349, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((Component)jSeparator, -1, 480, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.progress, -1, 480, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.message, -1, 480, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.inputFileName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.outputFileName, -2, -1, -2)).addPreferredGap(0).add((Component)jSeparator, -2, 10, -2).addPreferredGap(0).add((Component)this.progress, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.finishIcon, -2, -1, -2).add((Component)this.finishMessage, -1, 265, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.message).addContainerGap()));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConvertPanel.class, (String)"ConvertPanel.jLabel2.AccessibleContext.accessibleDescription"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConvertPanel.class, (String)"ConvertPanel.jLabel1.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ConvertPanel.class, (String)"ACC_NAME_ConvertPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ConvertPanel.class, (String)"ACC_DESC_ConvertPanel"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.switchToStarted();
        RequestProcessor.getDefault().post((Runnable)this);
    }

    @Override
    public void run() {
        final ArrayList<String> arrayList = new ArrayList<String>();
        try {
            ArrayList<String> arrayList2 = Converter.convert(this.inputPrimaryFile, this.inputSecondaryFile, this.outputFileName.getText());
            if (!arrayList2.isEmpty()) {
                arrayList.addAll(arrayList2);
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (arrayList.isEmpty()) {
                    ConvertPanel.this.switchToFinished();
                } else {
                    ConvertPanel.this.switchToErrors(arrayList);
                }
            }
        });
    }
}

