/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.netbeans.modules.tomcat5.config.gen.Engine;
import org.netbeans.modules.tomcat5.config.gen.Host;
import org.netbeans.modules.tomcat5.config.gen.Server;
import org.netbeans.modules.tomcat5.config.gen.Service;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.XMLDataObject;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TomcatInstallUtil {
    private static final String BUNDLED_DEFAULT_URI_ENCODING = "utf-8";
    private static final Boolean BUNDLED_DEFAULT_AUTO_DEPLOY = Boolean.FALSE;
    private static final String ATTR_URI_ENCODING = "URIEncoding";
    private static final String ATTR_PORT = "port";
    private static final String ATTR_PROTOCOL = "protocol";
    private static final String ATTR_AUTO_DEPLOY = "autoDeploy";
    private static final String ATTR_SCHEME = "scheme";
    private static final String ATTR_SECURE = "secure";
    private static final String PROP_CONNECTOR = "Connector";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String TRUE = "true";

    private TomcatInstallUtil() {
    }

    public static String getShutdownPort(Server server) {
        String string = server.getAttributeValue(ATTR_PORT);
        return string != null ? string : String.valueOf(8005);
    }

    public static String getPort(Server server) {
        Service service = server.getService(0);
        int n = -1;
        for (int i = 0; i < service.sizeConnector(); ++i) {
            String string;
            String string2;
            String string3 = service.getAttributeValue(PROP_CONNECTOR, i, ATTR_PROTOCOL);
            if (!TomcatInstallUtil.isHttpConnector(string3, string2 = service.getAttributeValue(PROP_CONNECTOR, i, ATTR_SCHEME), string = service.getAttributeValue(PROP_CONNECTOR, i, ATTR_SECURE))) continue;
            n = i;
            break;
        }
        if (n == -1 && service.sizeConnector() > 0) {
            n = 0;
        }
        String string = service.getAttributeValue(PROP_CONNECTOR, n, ATTR_PORT);
        return string;
    }

    public static String getHost(Server server) {
        String string = null;
        Service service = server.getService(0);
        if (service != null) {
            string = service.getAttributeValue("Engine", 0, "defaultHost");
        }
        return string;
    }

    public static File getBundledHome() {
        FileObject fileObject = FileUtil.getConfigFile((String)"J2EE/BundledTomcat/Setting");
        if (fileObject != null) {
            InstalledFileLocator installedFileLocator = InstalledFileLocator.getDefault();
            return installedFileLocator.locate(fileObject.getAttribute("bundled_home").toString(), null, false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDocumentText(org.w3c.dom.Document document) {
        OutputFormat outputFormat = new OutputFormat();
        outputFormat.setPreserveSpace(true);
        StringWriter stringWriter = new StringWriter();
        Element element = document.getDocumentElement();
        if (element == null) {
            return null;
        }
        try {
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, outputFormat);
            xMLSerializer.serialize(element);
            stringWriter.write(10);
            String string = stringWriter.toString();
            return string;
        }
        catch (IOException iOException) {
            System.out.println("ex=" + iOException);
            String string = element.toString();
            return string;
        }
        finally {
            try {
                stringWriter.close();
            }
            catch (IOException iOException) {
                System.out.println("ex=" + iOException);
            }
        }
    }

    public static void updateDocument(Document document, String string, String string2) throws BadLocationException {
        int n = document.getLength();
        String string3 = document.getText(0, n);
        int n2 = 0;
        if (string2 != null) {
            n2 = string3.indexOf(string2);
            if (n2 > 0) {
                string3 = document.getText(n2, n - n2);
            } else {
                n2 = 0;
            }
            int n3 = string.indexOf(string2);
            if (n3 > 0) {
                string = string.substring(n3);
            }
        }
        if (string3.equals(string)) {
            return;
        }
        document.remove(n2, n - n2);
        document.insertString(n2, string, null);
    }

    private static boolean isHttpConnector(String string, String string2, String string3) {
        return !(string != null && string.length() != 0 && !string.toLowerCase().startsWith(HTTP) || string2 != null && string2.toLowerCase().equals(HTTPS) || string3 != null && string3.toLowerCase().equals(TRUE));
    }

    public static boolean setServerPort(int n, File file) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            try {
                XMLDataObject xMLDataObject = (XMLDataObject)DataObject.find((FileObject)fileObject);
                org.w3c.dom.Document document = xMLDataObject.getDocument();
                Element element = document.getDocumentElement();
                NodeList nodeList = element.getElementsByTagName("Service");
                int n2 = nodeList.getLength();
                if (n2 > 0) {
                    Element element2 = (Element)nodeList.item(0);
                    NodeList nodeList2 = element2.getElementsByTagName(PROP_CONNECTOR);
                    for (int i = 0; i < nodeList2.getLength(); ++i) {
                        String string;
                        String string2;
                        Element element3 = (Element)nodeList2.item(i);
                        String string3 = element3.getAttribute(ATTR_PROTOCOL);
                        if (!TomcatInstallUtil.isHttpConnector(string3, string2 = element3.getAttribute(ATTR_SCHEME), string = element3.getAttribute(ATTR_SECURE))) continue;
                        element3.setAttribute(ATTR_PORT, String.valueOf(n));
                        TomcatInstallUtil.updateDocument((DataObject)xMLDataObject, document);
                        return true;
                    }
                }
            }
            catch (SAXException sAXException) {
                Exceptions.printStackTrace((Throwable)sAXException);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return false;
    }

    private static void setServerAttributeValue(Server server, String string, String string2) {
        server.setAttributeValue(string, string2);
    }

    private static void setHttpConnectorAttributeValue(Server server, String string, String string2) {
        Service[] serviceArray = server.getService();
        if (serviceArray != null && serviceArray.length > 0) {
            Service service = serviceArray[0];
            int n = service.sizeConnector();
            for (int i = 0; i < n; ++i) {
                String string3;
                String string4;
                String string5 = service.getAttributeValue(PROP_CONNECTOR, i, ATTR_PROTOCOL);
                if (!TomcatInstallUtil.isHttpConnector(string5, string4 = service.getAttributeValue(PROP_CONNECTOR, i, ATTR_SCHEME), string3 = service.getAttributeValue(PROP_CONNECTOR, i, ATTR_SECURE))) continue;
                service.setAttributeValue(PROP_CONNECTOR, i, string, string2);
                return;
            }
        }
    }

    private static void setHostAttributeValue(Server server, String string, String string2) {
        Service[] serviceArray = server.getService();
        if (serviceArray != null) {
            for (int i = 0; i < serviceArray.length; ++i) {
                Host[] hostArray;
                Engine engine = serviceArray[i].getEngine();
                if (engine == null || (hostArray = engine.getHost()) == null || hostArray.length <= 0) continue;
                hostArray[0].setAttributeValue(string, string2);
                return;
            }
        }
    }

    public static void patchBundledServerXml(File file) {
        try {
            Server server = Server.createGraph(file);
            TomcatInstallUtil.setServerAttributeValue(server, ATTR_PORT, String.valueOf(8025));
            TomcatInstallUtil.setHttpConnectorAttributeValue(server, ATTR_PORT, String.valueOf(8084));
            TomcatInstallUtil.setHttpConnectorAttributeValue(server, ATTR_URI_ENCODING, BUNDLED_DEFAULT_URI_ENCODING);
            TomcatInstallUtil.setHostAttributeValue(server, ATTR_AUTO_DEPLOY, BUNDLED_DEFAULT_AUTO_DEPLOY.toString());
            server.write(file);
        }
        catch (IOException iOException) {
            Logger.getLogger(TomcatInstallUtil.class.getName()).log(Level.INFO, null, iOException);
        }
        catch (RuntimeException runtimeException) {
            Logger.getLogger(TomcatInstallUtil.class.getName()).log(Level.INFO, null, runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void patchCatalinaProperties(File file) throws IOException {
        Object object;
        EditableProperties editableProperties = new EditableProperties(false);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            editableProperties.load((InputStream)bufferedInputStream);
            object = "common.loader";
            String string = editableProperties.getProperty((String)object);
            if (string != null) {
                String string2;
                if ((string = string.trim()).contains(string2 = "${catalina.base}/nblib/*.jar")) {
                    return;
                }
                StringBuilder stringBuilder = new StringBuilder(string);
                if (!string.endsWith(",")) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(string2);
                editableProperties.setProperty((String)object, stringBuilder.toString());
            }
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
        object = new BufferedOutputStream(new FileOutputStream(file));
        try {
            editableProperties.store((OutputStream)object);
        }
        finally {
            ((FilterOutputStream)object).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createNBLibDirectory(File file) throws IOException {
        new File(file, "nblib").mkdir();
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(file, "nblib/README")));
        try {
            for (String string : NbBundle.getMessage(TomcatInstallUtil.class, (String)"MSG_NBLibReadmeContent").split("\n")) {
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
        }
        finally {
            bufferedWriter.close();
        }
    }

    public static boolean setShutdownPort(int n, File file) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            try {
                XMLDataObject xMLDataObject = (XMLDataObject)DataObject.find((FileObject)fileObject);
                org.w3c.dom.Document document = xMLDataObject.getDocument();
                Element element = document.getDocumentElement();
                element.setAttribute(ATTR_PORT, String.valueOf(n));
                TomcatInstallUtil.updateDocument((DataObject)xMLDataObject, document);
                return true;
            }
            catch (SAXException sAXException) {
                Exceptions.printStackTrace((Throwable)sAXException);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return false;
    }

    public static void updateDocument(DataObject dataObject, org.w3c.dom.Document document) throws BadLocationException, IOException {
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            styledDocument = editorCookie.openDocument();
        }
        TomcatInstallUtil.updateDocument(styledDocument, TomcatInstallUtil.getDocumentText(document), "<Server");
        SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
        if (saveCookie != null) {
            saveCookie.save();
        }
    }
}

