/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.loaders.CreateFromTemplateAttributesProvider;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

class TemplateAttributesProviderImpl
implements CreateFromTemplateAttributesProvider {
    private final AntProjectHelper helper;
    private final FileEncodingQueryImplementation encodingQuery;

    public TemplateAttributesProviderImpl(AntProjectHelper helper, FileEncodingQueryImplementation encodingQuery) {
        this.helper = helper;
        this.encodingQuery = encodingQuery;
    }

    public Map<String, ?> attributesFor(DataObject template, DataFolder target, String name) {
        Charset charset;
        String encoding;
        HashMap<String, String> values = new HashMap<String, String>();
        EditableProperties props = this.helper.getProperties("nbproject/project.properties");
        String license = props.getProperty("project.license");
        if (license != null) {
            values.put("license", license);
        }
        String string = encoding = (charset = this.encodingQuery.getEncoding(target.getPrimaryFile())) != null ? charset.name() : null;
        if (encoding != null) {
            values.put("encoding", encoding);
        }
        try {
            Project prj = ProjectManager.getDefault().findProject(this.helper.getProjectDirectory());
            ProjectInformation info = (ProjectInformation)prj.getLookup().lookup(ProjectInformation.class);
            if (info != null) {
                String pdname;
                String pname = info.getName();
                if (pname != null) {
                    values.put("name", pname);
                }
                if ((pdname = info.getDisplayName()) != null) {
                    values.put("displayName", pdname);
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(TemplateAttributesProviderImpl.class.getName()).log(Level.FINE, "", ex);
        }
        if (values.size() == 0) {
            return null;
        }
        return Collections.singletonMap("project", values);
    }
}

