/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.ui.components;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dlight.api.datafilter.DataFilterManager;
import org.netbeans.modules.dlight.core.ui.components.DLightIndicatorTopComponentRegsitry;
import org.netbeans.modules.dlight.extras.api.support.IndicatorsContainer;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.spi.indicator.IndicatorComponentEmptyContentProvider;
import org.openide.explorer.ExplorerManager;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class DLightIndicatorsTopComponent
extends TopComponent
implements ExplorerManager.Provider {
    private static DLightIndicatorsTopComponent instance;
    private DLightSession session;
    static final String ICON_PATH = "org/netbeans/modules/dlight/core/ui/resources/indicators_small.png";
    private static final String PREFERRED_ID = "DLightIndicatorsTopComponent";
    private static final AtomicInteger index;
    private final CardLayout cardLayout = new CardLayout();
    private JPanel cardsLayoutPanel;
    private JPanel panel1;
    private JPanel panel2;
    private Vector<JComponent> indicatorPanels = null;
    private boolean showFirstPanel = true;
    private boolean dock;
    private final ExplorerManager manager = new ExplorerManager();
    private JComponent lastFocusedComponent = null;
    private final FocusTraversalPolicy focusPolicy = new FocusTraversalPolicyImpl();

    private DLightIndicatorsTopComponent(boolean dock) {
        this.initComponents();
        this.dock = dock;
        this.setSession(null);
        this.setName(DLightIndicatorsTopComponent.getMessage("CTL_DLightIndicatorsTopComponent", new Object[0]));
        this.setToolTipText(DLightIndicatorsTopComponent.getMessage("CTL_DLightIndicatorsTopComponent", new Object[0]));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        if (dock && (WindowManager.getDefault().findMode((TopComponent)this) == null || WindowManager.getDefault().findMode((TopComponent)this).getName().equals("navigator")) && WindowManager.getDefault().findMode("navigator") != null) {
            WindowManager.getDefault().findMode("navigator").dockInto((TopComponent)this);
        }
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(this.focusPolicy);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private Action getPopupAction() {
        return null;
    }

    private DLightIndicatorsTopComponent() {
        this(false);
    }

    void initComponents() {
        this.cardsLayoutPanel = new JPanel(this.cardLayout);
        this.panel1 = new JPanel();
        this.panel2 = new JPanel();
        this.cardsLayoutPanel.add((Component)this.panel1, "#1");
        this.cardsLayoutPanel.add((Component)this.panel2, "#2");
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add(this.cardsLayoutPanel);
    }

    void installActions() {
        KeyStroke returnKey = KeyStroke.getKeyStroke(27, 0, true);
        this.getInputMap(2).put(returnKey, "return");
        this.getActionMap().put("return", new ESCHandler());
    }

    void setActive() {
        this.cardLayout.show(this.cardsLayoutPanel, this.showFirstPanel ? "#1" : "#2");
        this.showFirstPanel = !this.showFirstPanel;
    }

    JPanel getNextPanel() {
        return this.showFirstPanel ? this.panel1 : this.panel2;
    }

    private JPanel getCurrentPanel() {
        return this.showFirstPanel ? this.panel2 : this.panel1;
    }

    public void setSession(DLightSession session) {
        if (this.session != null && this.session != session) {
            DLightManager.getDefault().closeSessionOnExit(this.session);
        }
        this.session = session;
        List indicators = new ArrayList();
        if (session != null) {
            this.setDisplayName(DLightIndicatorsTopComponent.getMessage("CTL_DLightIndicatorsTopComponent.withSession", session.getDisplayName()));
            this.setToolTipText(DLightIndicatorsTopComponent.getMessage("CTL_DLightIndicatorsTopComponent.withSession", session.getDisplayName()));
            indicators = session.getIndicators();
        } else {
            this.setDisplayName(DLightIndicatorsTopComponent.getMessage("CTL_DLightIndicatorsTopComponent", new Object[0]));
            this.setToolTipText(DLightIndicatorsTopComponent.getMessage("CTL_DLightIndicatorsTopComponent", new Object[0]));
            IndicatorComponentEmptyContentProvider emptyContent = (IndicatorComponentEmptyContentProvider)Lookup.getDefault().lookup(IndicatorComponentEmptyContentProvider.class);
            if (emptyContent != null) {
                indicators = emptyContent.getEmptyContent();
            }
        }
        if (indicators != null) {
            Collections.sort(indicators, new Comparator<Indicator<?>>(){

                @Override
                public int compare(Indicator<?> o1, Indicator<?> o2) {
                    if (o1.getPosition() < o2.getPosition()) {
                        return -1;
                    }
                    if (o2.getPosition() < o1.getPosition()) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        this.setContent(session, indicators);
    }

    private void setContent(DLightSession session, List<Indicator<?>> indicators) {
        JPanel panel = this.getNextPanel();
        panel.removeAll();
        panel.setLayout(new BorderLayout());
        if (indicators != null) {
            panel.add((Component)new IndicatorsContainer((DataFilterManager)session, indicators), "Center");
            this.indicatorPanels = new Vector(indicators.size());
            this.indicatorPanels.setSize(indicators.size());
            for (int i = 0; i < indicators.size(); ++i) {
                this.indicatorPanels.set(i, indicators.get(i).getComponent());
            }
        } else {
            this.indicatorPanels = null;
            JLabel emptyLabel = new JLabel("");
            emptyLabel.setAlignmentX(0.5f);
            panel.add(emptyLabel);
        }
        this.setActive();
        this.repaint();
    }

    public static synchronized DLightIndicatorsTopComponent getDefault() {
        if (instance == null) {
            instance = new DLightIndicatorsTopComponent();
        }
        return instance;
    }

    public static synchronized DLightIndicatorsTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(DLightIndicatorsTopComponent.class.getName()).warning("Cannot find DLightIndicatorsTopComponent component. It will not be located properly in the window system.");
            return DLightIndicatorsTopComponent.getDefault();
        }
        if (win instanceof DLightIndicatorsTopComponent) {
            return (DLightIndicatorsTopComponent)win;
        }
        Logger.getLogger(DLightIndicatorsTopComponent.class.getName()).warning("There seem to be multiple components with the 'DLightIndicatorsTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return DLightIndicatorsTopComponent.getDefault();
    }

    public static synchronized DLightIndicatorsTopComponent newInstance() {
        return new DLightIndicatorsTopComponent(true);
    }

    public static synchronized TopComponent activateInstance() {
        DLightIndicatorTopComponentRegsitry registry = DLightIndicatorTopComponentRegsitry.getRegistry();
        if (registry.getOpened() == null || registry.getOpened().size() == 0) {
            return DLightIndicatorsTopComponent.findInstance();
        }
        DLightIndicatorsTopComponent activatedTopComponent = registry.getActivated();
        if (activatedTopComponent == null) {
            activatedTopComponent = registry.getOpened().iterator().next();
        }
        activatedTopComponent.requestActive();
        return activatedTopComponent;
    }

    public int getPersistenceType() {
        if (!this.dock) {
            return 0;
        }
        return 2;
    }

    public void componentOpened() {
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        this.lastFocusedComponent = null;
        if (this.indicatorPanels == null || this.indicatorPanels.size() == 0) {
            return;
        }
        for (JComponent c : this.indicatorPanels) {
            if (!c.hasFocus()) continue;
            this.lastFocusedComponent = c;
            break;
        }
        if (this.lastFocusedComponent == null) {
            this.lastFocusedComponent = this.indicatorPanels.get(0);
        }
    }

    protected void componentActivated() {
        super.componentActivated();
        if (this.lastFocusedComponent != null) {
            this.lastFocusedComponent.requestFocus();
        } else {
            this.focusPolicy.getFirstComponent((Container)((Object)this)).requestFocus();
        }
    }

    public void componentClosed() {
        if (this.session != null) {
            DLightManager.getDefault().closeSessionOnExit(this.session);
        }
        super.componentClosed();
    }

    DLightSession getSession() {
        return this.session;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        if (!this.dock) {
            return PREFERRED_ID;
        }
        return PREFERRED_ID + index.incrementAndGet();
    }

    private static String getMessage(String name, Object ... params) {
        return NbBundle.getMessage(DLightIndicatorsTopComponent.class, (String)name, (Object[])params);
    }

    static {
        index = new AtomicInteger();
        DLightIndicatorTopComponentRegsitry.getRegistry();
    }

    private class ESCHandler
    extends AbstractAction {
        private ESCHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Component focusOwner = FocusManager.getCurrentManager().getFocusOwner();
            if (DLightIndicatorTopComponentRegsitry.getRegistry().getActivated() == null || focusOwner == null || !SwingUtilities.isDescendingFrom(focusOwner, (Component)((Object)DLightIndicatorsTopComponent.this))) {
                return;
            }
            TopComponent prevFocusedTc = DLightIndicatorTopComponentRegsitry.getRegistry().getActivatedNonIndicators();
            if (prevFocusedTc != null) {
                prevFocusedTc.requestActive();
            }
        }
    }

    private final class FocusTraversalPolicyImpl
    extends FocusTraversalPolicy {
        private FocusTraversalPolicyImpl() {
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            if (aComponent == DLightIndicatorsTopComponent.this.getCurrentPanel()) {
                return DLightIndicatorsTopComponent.this.getCurrentPanel();
            }
            int indexOf = DLightIndicatorsTopComponent.this.indicatorPanels.indexOf(aComponent);
            if (indexOf == -1) {
                return DLightIndicatorsTopComponent.this.getCurrentPanel();
            }
            if (indexOf == DLightIndicatorsTopComponent.this.indicatorPanels.size() - 1) {
                return (Component)DLightIndicatorsTopComponent.this.indicatorPanels.get(0);
            }
            return (Component)DLightIndicatorsTopComponent.this.indicatorPanels.get(indexOf + 1);
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            if (aComponent == DLightIndicatorsTopComponent.this.getCurrentPanel()) {
                return DLightIndicatorsTopComponent.this.getCurrentPanel();
            }
            int indexOf = DLightIndicatorsTopComponent.this.indicatorPanels.indexOf(aComponent);
            if (indexOf == -1) {
                return DLightIndicatorsTopComponent.this.getCurrentPanel();
            }
            if (indexOf == 0) {
                return (Component)DLightIndicatorsTopComponent.this.indicatorPanels.get(DLightIndicatorsTopComponent.this.indicatorPanels.size() - 1);
            }
            return (Component)DLightIndicatorsTopComponent.this.indicatorPanels.get(indexOf - 1);
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            if (DLightIndicatorsTopComponent.this.indicatorPanels == null || DLightIndicatorsTopComponent.this.indicatorPanels.size() == 0) {
                return DLightIndicatorsTopComponent.this.getCurrentPanel();
            }
            return (Component)DLightIndicatorsTopComponent.this.indicatorPanels.get(0);
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            if (DLightIndicatorsTopComponent.this.indicatorPanels == null || DLightIndicatorsTopComponent.this.indicatorPanels.size() == 0) {
                return DLightIndicatorsTopComponent.this.getCurrentPanel();
            }
            return (Component)DLightIndicatorsTopComponent.this.indicatorPanels.get(DLightIndicatorsTopComponent.this.indicatorPanels.size() - 1);
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            if (DLightIndicatorsTopComponent.this.indicatorPanels == null || DLightIndicatorsTopComponent.this.indicatorPanels.size() == 0) {
                return DLightIndicatorsTopComponent.this.getCurrentPanel();
            }
            return (Component)DLightIndicatorsTopComponent.this.indicatorPanels.get(0);
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return DLightIndicatorsTopComponent.getDefault();
        }
    }
}

