/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker.bindings.ruby;

import javax.swing.text.BadLocationException;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.netbeans.modules.ruby.rhtml.lexer.api.RhtmlTokenId;
import org.netbeans.modules.spellchecker.bindings.ruby.RubyTokenList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RhtmlTokenList
extends RubyTokenList {
    private boolean hidden = false;

    public RhtmlTokenList(BaseDocument doc) {
        super(doc);
    }

    @Override
    public void setStartOffset(int offset) {
        super.setStartOffset(offset);
        FileObject fileObject = FileUtil.getConfigFile((String)"Spellcheckers/RHTML");
        Boolean b = (Boolean)fileObject.getAttribute("Hidden");
        this.hidden = Boolean.TRUE.equals(b);
    }

    @Override
    protected int[] findNextSpellSpan(TokenSequence<? extends TokenId> ts, int offset) throws BadLocationException {
        if (ts == null || this.hidden) {
            return new int[]{-1, -1};
        }
        int diff = ts.move(offset);
        while (ts.moveNext()) {
            int[] span;
            TokenSequence t;
            TokenId id = ts.token().id();
            if (id == RhtmlTokenId.HTML) {
                t = ts.embedded(HTMLTokenId.language());
                if (t == null) continue;
                t.move(offset);
                while (t.moveNext()) {
                    TokenId tid = t.token().id();
                    if (tid != HTMLTokenId.TEXT) continue;
                    return new int[]{t.offset(), t.offset() + t.token().length()};
                }
                continue;
            }
            if (id != RhtmlTokenId.RUBY && id != RhtmlTokenId.RUBY_EXPR || (t = ts.embedded(RubyTokenId.language())) == null || (span = super.findNextSpellSpan((TokenSequence<? extends TokenId>)t, Math.max(offset, ts.offset())))[0] == -1) continue;
            return span;
        }
        return new int[]{-1, -1};
    }
}

