/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.templates;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class GrailsTargetChooserPanelGUI
extends JPanel
implements ActionListener,
DocumentListener {
    private static final String NEW_CLASS_PREFIX = NbBundle.getMessage(GrailsTargetChooserPanelGUI.class, (String)"LBL_GrailsTargetChooserPanelGUI_NewArtifactPrefix");
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    private Project project;
    private String expectedExtension;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private SourceGroup group;
    private JPanel bottomPanelContainer;
    private JLabel documentNameLabel;
    private JTextField documentNameTextField;
    private JLabel fileLabel;
    private JTextField fileTextField;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JComboBox packageComboBox;
    private JLabel packageLabel;
    private JTextField projectTextField;
    private JSeparator targetSeparator;
    private RequestProcessor.Task updatePackagesTask = null;
    private static final ComboBoxModel WAIT_MODEL = new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(GrailsTargetChooserPanelGUI.class, (String)"LBL_GrailsTargetChooserPanelGUI_PackageName_PleaseWait")});

    public GrailsTargetChooserPanelGUI(Project p, SourceGroup group, Component bottomPanel) {
        Component packageEditor;
        this.project = p;
        this.group = group;
        this.initComponents();
        this.packageComboBox.getEditor().addActionListener(this);
        this.documentNameTextField.getDocument().addDocumentListener(this);
        if (bottomPanel != null) {
            this.bottomPanelContainer.add(bottomPanel, "Center");
        }
        if ((packageEditor = this.packageComboBox.getEditor().getEditorComponent()) instanceof JTextField) {
            ((JTextField)packageEditor).getDocument().addDocumentListener(this);
        } else {
            this.packageComboBox.addActionListener(this);
        }
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.setPreferredSize(PREF_DIM);
        this.setName(NbBundle.getBundle(GrailsTargetChooserPanelGUI.class).getString("LBL_GrailsTargetChooserPanelGUI_Name"));
    }

    @Override
    public void addNotify() {
        Dimension panel2Size = this.jPanel2.getPreferredSize();
        Dimension bottomPanelSize = this.bottomPanelContainer.getPreferredSize();
        Dimension splitterSize = this.targetSeparator.getPreferredSize();
        int vmax = panel2Size.height + bottomPanelSize.height + splitterSize.height + 12;
        if (vmax > GrailsTargetChooserPanelGUI.PREF_DIM.height) {
            this.setPreferredSize(new Dimension(GrailsTargetChooserPanelGUI.PREF_DIM.width, vmax));
        }
        super.addNotify();
    }

    public void initValues(FileObject template, FileObject preselectedFolder, String suffix) {
        assert (this.project != null) : "Project must be specified.";
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        assert (template != null);
        String displayName = null;
        try {
            DataObject templateDo = DataObject.find((FileObject)template);
            displayName = templateDo.getNodeDelegate().getDisplayName();
        }
        catch (DataObjectNotFoundException ex) {
            displayName = template.getName();
        }
        this.putClientProperty("NewFileWizard_Title", displayName);
        SourceGroup preselectedGroup = this.group;
        Object preselectedPackage = this.getPreselectedPackage(preselectedGroup, preselectedFolder, this.packageComboBox.getModel());
        if (preselectedPackage != null) {
            this.packageComboBox.getEditor().setItem(preselectedPackage);
        }
        if (template != null && this.documentNameTextField.getText().trim().length() == 0) {
            String baseName;
            String activeName = baseName = NEW_CLASS_PREFIX + template.getName();
            if (preselectedFolder != null) {
                FileObject _tmp;
                int index = 0;
                while ((_tmp = preselectedFolder.getFileObject(activeName, template.getExt())) != null) {
                    activeName = baseName + ++index;
                }
            }
            this.documentNameTextField.setText(activeName);
            this.documentNameTextField.selectAll();
        }
        this.updatePackages();
        if (suffix != null) {
            this.expectedExtension = suffix;
        } else {
            String ext = template == null ? "" : template.getExt();
            this.expectedExtension = ext.length() == 0 ? "" : "." + ext;
        }
        this.updateText();
    }

    public FileObject getRootFolder() {
        return this.group.getRootFolder();
    }

    public String getPackageFileName() {
        String packageName = this.packageComboBox.getEditor().getItem().toString();
        return packageName.replace('.', '/');
    }

    String getPackageName() {
        return this.packageComboBox.getEditor().getItem().toString();
    }

    public String getTargetName() {
        String text = this.documentNameTextField.getText().trim();
        if (text.length() == 0) {
            return null;
        }
        return text;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(e);
        }
    }

    private void initComponents() {
        this.targetSeparator = new JSeparator();
        this.bottomPanelContainer = new JPanel();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.documentNameLabel = new JLabel();
        this.documentNameTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.projectTextField = new JTextField();
        this.packageLabel = new JLabel();
        this.packageComboBox = new JComboBox();
        this.fileLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.bottomPanelContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanelContainer, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.documentNameLabel.setLabelFor(this.documentNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.documentNameLabel, (String)NbBundle.getMessage(GrailsTargetChooserPanelGUI.class, (String)"LBL_GrailsTargetChooserPanelGUI_ClassName_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.documentNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.documentNameTextField, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/groovy/grailsproject/templates/Bundle");
        this.documentNameTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_documentNameTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 24, 0);
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel5.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(GrailsTargetChooserPanelGUI.class, (String)"LBL_GrailsTargetChooserPanelGUI_jLabel5"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel2.add((Component)this.jLabel5, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_projectTextField"));
        this.packageLabel.setLabelFor(this.packageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.packageLabel, (String)NbBundle.getMessage(GrailsTargetChooserPanelGUI.class, (String)"LBL_GrailsTargetChooserPanelGUI_jLabel2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.jPanel2.add((Component)this.packageLabel, gridBagConstraints);
        this.packageComboBox.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.jPanel2.add((Component)this.packageComboBox, gridBagConstraints);
        this.packageComboBox.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_packageComboBox"));
        this.fileLabel.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.fileLabel, (String)NbBundle.getMessage(GrailsTargetChooserPanelGUI.class, (String)"LBL_GrailsTargetChooserPanelGUI_CreatedFile_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 12, 0);
        this.jPanel2.add((Component)this.fileLabel, gridBagConstraints);
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 12, 0);
        this.jPanel2.add((Component)this.fileTextField, gridBagConstraints);
        this.fileTextField.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_fileTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_JavaTargetChooserPanelGUI"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.packageComboBox == e.getSource()) {
            this.updateText();
            this.fireChange();
        } else if (this.packageComboBox.getEditor() == e.getSource()) {
            this.updateText();
            this.fireChange();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateText();
        this.fireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    private void updatePackages() {
        WAIT_MODEL.setSelectedItem(this.packageComboBox.getEditor().getItem());
        this.packageComboBox.setModel(WAIT_MODEL);
        if (this.updatePackagesTask != null) {
            this.updatePackagesTask.cancel();
        }
        this.updatePackagesTask = new RequestProcessor("ComboUpdatePackages").post(new Runnable(){
            private ComboBoxModel model;

            @Override
            public void run() {
                if (!SwingUtilities.isEventDispatchThread()) {
                    this.model = PackageView.createListView((SourceGroup)GrailsTargetChooserPanelGUI.this.group);
                    SwingUtilities.invokeLater(this);
                } else {
                    this.model.setSelectedItem(GrailsTargetChooserPanelGUI.this.packageComboBox.getEditor().getItem());
                    GrailsTargetChooserPanelGUI.this.packageComboBox.setModel(this.model);
                }
            }
        });
    }

    private void updateText() {
        SourceGroup g = this.group;
        FileObject rootFolder = g.getRootFolder();
        String packageName = this.getPackageFileName();
        String documentName = this.documentNameTextField.getText().trim();
        if (documentName.length() > 0) {
            documentName = documentName + this.expectedExtension;
        }
        String createdFileName = FileUtil.getFileDisplayName((FileObject)rootFolder) + (packageName.startsWith("/") || packageName.startsWith(File.separator) ? "" : "/") + packageName + (packageName.endsWith("/") || packageName.endsWith(File.separator) || packageName.length() == 0 ? "" : "/") + documentName;
        this.fileTextField.setText(createdFileName.replace('/', File.separatorChar));
    }

    private Object getPreselectedPackage(SourceGroup group, FileObject folder, ListModel model) {
        if (folder == null) {
            return null;
        }
        FileObject root = group.getRootFolder();
        String relPath = FileUtil.getRelativePath((FileObject)root, (FileObject)folder);
        if (relPath == null) {
            return null;
        }
        String name = relPath.replace('/', '.');
        return name;
    }

    private static final class GroupListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            SourceGroup g = (SourceGroup)value;
            super.getListCellRendererComponent((JList<?>)list, g.getDisplayName(), index, isSelected, cellHasFocus);
            this.setIcon(g.getIcon(false));
            return this;
        }
    }
}

