/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.i18n.FactoryRegistry;
import org.netbeans.modules.i18n.HardCodedString;
import org.netbeans.modules.i18n.I18nString;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.ResourceHolder;
import org.netbeans.modules.i18n.SelectorUtils;
import org.netbeans.modules.i18n.wizard.I18nWizardDescriptor;
import org.netbeans.modules.i18n.wizard.ProgressWizardPanel;
import org.netbeans.modules.i18n.wizard.SourceData;
import org.netbeans.modules.i18n.wizard.Util;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class ResourceWizardPanel
extends JPanel {
    private final Map<DataObject, SourceData> sourceMap = Util.createWizardSourceMap();
    private final ResourceTableModel tableModel = new ResourceTableModel();
    private final Panel descPanel;
    private final boolean testMode;
    private JButton addAllButton;
    private JButton addButton;
    private JTextArea descTextArea;
    private JScrollPane jScrollPane1;
    private JLabel lblSelectedResources;
    private JTable resourcesTable;

    private ResourceWizardPanel(Panel descPanel, boolean testMode) {
        this.descPanel = descPanel;
        this.testMode = testMode;
        this.initComponents();
        this.initTable();
        this.initAccesibility();
    }

    public Map<DataObject, SourceData> getSourceMap() {
        return this.sourceMap;
    }

    public void setSourceMap(Map<DataObject, SourceData> sourceMap) {
        this.sourceMap.clear();
        this.sourceMap.putAll(sourceMap);
        this.tableModel.fireTableDataChanged();
        this.descPanel.fireStateChanged();
    }

    private String getPanelDescription() {
        if (!this.testMode) {
            return Util.getString("MSG_ResourcePanel_desc");
        }
        return Util.getString("MSG_ResourcePanel_test_desc");
    }

    private void initTable() {
        this.resourcesTable.setDefaultRenderer(DataObject.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                DataObject dataObject = (DataObject)value;
                if (dataObject != null) {
                    String name = "N/A";
                    if (column == 0) {
                        ClassPath cp = ClassPath.getClassPath((FileObject)dataObject.getPrimaryFile(), (String)"classpath/source");
                        name = cp.getResourceName(dataObject.getPrimaryFile(), '.', false);
                    } else {
                        DataObject dob = (DataObject)ResourceWizardPanel.this.tableModel.getValueAt(row, 0);
                        name = Util.getResourceName(dob.getPrimaryFile(), dataObject.getPrimaryFile(), '.', false);
                    }
                    label.setText(name);
                    label.setIcon(new ImageIcon(dataObject.getNodeDelegate().getIcon(1)));
                } else {
                    label.setText("");
                    label.setIcon(null);
                }
                return label;
            }
        });
        Component cellSample = new DefaultTableCellRenderer().getTableCellRendererComponent(this.resourcesTable, "N/A", false, false, 0, 0);
        int cellHeight = cellSample.getPreferredSize().height;
        int rowHeight = cellHeight + this.resourcesTable.getRowMargin();
        this.resourcesTable.setRowHeight(Math.max(16, rowHeight));
        this.resourcesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ResourceWizardPanel.this.addButton.setEnabled(!ResourceWizardPanel.this.resourcesTable.getSelectionModel().isSelectionEmpty());
            }
        });
        this.addButton.setEnabled(!this.resourcesTable.getSelectionModel().isSelectionEmpty());
    }

    private void initAccesibility() {
        this.addButton.getAccessibleContext().setAccessibleDescription(Util.getString("ACS_CTL_SelectResource"));
        this.addAllButton.getAccessibleContext().setAccessibleDescription(Util.getString("ACS_CTL_SelectResourceAll"));
        this.resourcesTable.getAccessibleContext().setAccessibleDescription(Util.getString("ACSD_resourcesTable"));
        this.resourcesTable.getAccessibleContext().setAccessibleName(Util.getString("ACSN_resourcesTable"));
    }

    private void initComponents() {
        this.resourcesTable = new JTable();
        this.resourcesTable.setModel(this.tableModel);
        this.addAllButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.addAllButton, (String)Util.getString("CTL_SelectResourceAll"));
        this.addAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResourceWizardPanel.this.addAllButtonActionPerformed(evt);
            }
        });
        this.addButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)Util.getString("CTL_SelectResource"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResourceWizardPanel.this.addButtonActionPerformed(evt);
            }
        });
        Util.layoutSelectResourcePanel(this, this.getPanelDescription(), Util.getString("LBL_SelectedResources"), this.resourcesTable, this.addAllButton, this.addButton);
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        DataObject resource = this.selectResource();
        if (resource == null) {
            return;
        }
        int[] selectedRows = this.resourcesTable.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            DataObject dataObject = (DataObject)this.resourcesTable.getValueAt(selectedRows[i], 0);
            this.sourceMap.put(dataObject, new SourceData(resource));
            this.tableModel.fireTableCellUpdated(selectedRows[i], 1);
        }
        this.descPanel.fireStateChanged();
    }

    private void addAllButtonActionPerformed(ActionEvent evt) {
        DataObject resource = this.selectResource();
        if (resource == null) {
            return;
        }
        for (int i = 0; i < this.resourcesTable.getRowCount(); ++i) {
            DataObject dataObject = (DataObject)this.resourcesTable.getValueAt(i, 0);
            this.sourceMap.put(dataObject, new SourceData(resource));
            this.tableModel.fireTableCellUpdated(i, 1);
        }
        this.descPanel.fireStateChanged();
    }

    private DataObject selectResource() {
        FileObject fo = null;
        Object source = null;
        for (DataObject dobj : this.sourceMap.keySet()) {
            fo = dobj.getPrimaryFile();
            source = dobj;
        }
        I18nSupport support = null;
        try {
            support = FactoryRegistry.getFactory(source.getClass()).create((DataObject)source);
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        ResourceHolder rh = support != null ? support.getResourceHolder() : null;
        DataObject template = null;
        try {
            template = rh != null ? rh.getTemplate(rh.getResourceClasses()[0]) : null;
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return SelectorUtils.selectOrCreateBundle(fo, template, null);
    }

    public static class Panel
    extends I18nWizardDescriptor.Panel
    implements WizardDescriptor.AsynchronousValidatingPanel<I18nWizardDescriptor.Settings> {
        private static final String CARD_GUI = "gui";
        private static final String CARD_PROGRESS = "progress";
        private transient ResourceWizardPanel resourcePanel;
        private final boolean testWizard;
        private volatile ProgressWizardPanel progressPanel;

        public Panel() {
            this(false);
        }

        public Panel(boolean testWizard) {
            this.testWizard = testWizard;
        }

        @Override
        protected Component createComponent() {
            JPanel panel = new JPanel(new CardLayout());
            panel.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ResourceWizardPanel.class).getString("ACS_ResourceWizardPanel"));
            panel.putClientProperty("WizardPanel_contentSelectedIndex", 1);
            String msgKey = this.testWizard ? "TXT_SelectTestResource" : "TXT_SelectResource";
            panel.setName(NbBundle.getMessage(ResourceWizardPanel.class, (String)msgKey));
            panel.setPreferredSize(I18nWizardDescriptor.PREFERRED_DIMENSION);
            panel.add((Component)this.getUI(), CARD_GUI);
            return panel;
        }

        @Override
        public boolean isValid() {
            return !this.getUI().getSourceMap().containsValue(null);
        }

        @Override
        public void readSettings(I18nWizardDescriptor.Settings settings) {
            super.readSettings(settings);
            this.getUI().setSourceMap(this.getMap());
            Container container = (Container)this.getComponent();
            ((CardLayout)container.getLayout()).show(container, CARD_GUI);
        }

        @Override
        public void storeSettings(I18nWizardDescriptor.Settings settings) {
            super.storeSettings(settings);
            this.getMap().clear();
            this.getMap().putAll(this.getUI().getSourceMap());
        }

        public void prepareValidation() {
            assert (EventQueue.isDispatchThread());
            if (this.progressPanel == null) {
                this.progressPanel = new ProgressWizardPanel(false);
            }
            this.showProgressPanel(this.progressPanel);
            this.progressPanel.setMainText(NbBundle.getMessage(ResourceWizardPanel.class, (String)"TXT_Loading"));
            this.progressPanel.setMainProgress(0);
        }

        public void validate() throws WizardValidationException {
            assert (!EventQueue.isDispatchThread());
            Map<DataObject, SourceData> sourceMap = this.getUI().getSourceMap();
            Iterator<Map.Entry<DataObject, SourceData>> sourceIterator = sourceMap.entrySet().iterator();
            String prefixLoading = NbBundle.getMessage(ResourceWizardPanel.class, (String)"TXT_Loading") + ' ';
            String prefixSearchingIn = NbBundle.getMessage(ResourceWizardPanel.class, (String)"TXT_SearchingIn") + ' ';
            int i = 0;
            while (sourceIterator.hasNext()) {
                block8: {
                    Map.Entry<DataObject, SourceData> entry = sourceIterator.next();
                    DataObject source = entry.getKey();
                    FileObject fileObj = source.getPrimaryFile();
                    String fileName = ClassPath.getClassPath((FileObject)fileObj, (String)"classpath/source").getResourceName(fileObj, '.', false);
                    this.progressPanel.setMainText(prefixLoading + fileName);
                    SourceData sourceData = entry.getValue();
                    I18nSupport support = sourceData.getSupport();
                    if (support == null) {
                        try {
                            support = FactoryRegistry.getFactory(source.getClass()).create(source);
                        }
                        catch (IOException ioe) {
                            ErrorManager.getDefault().notify(1, (Throwable)ioe);
                            sourceIterator.remove();
                            break block8;
                        }
                        sourceData = new SourceData(sourceData.getResource(), support);
                        entry.setValue(sourceData);
                    }
                    this.progressPanel.setMainText(prefixSearchingIn + fileName);
                    HardCodedString[] foundStrings = this.testWizard ? support.getFinder().findAllI18nStrings() : support.getFinder().findAllHardCodedStrings();
                    if (foundStrings == null) {
                        sourceData.setStringMap(Collections.<HardCodedString, I18nString>emptyMap());
                    } else {
                        HashMap<HardCodedString, I18nString> map = new HashMap<HardCodedString, I18nString>(foundStrings.length);
                        for (HardCodedString hcString : foundStrings) {
                            if (this.testWizard && support.getResourceHolder().getValueForKey(hcString.getText()) != null) continue;
                            map.put(hcString, support.getDefaultI18nString(hcString));
                        }
                        this.progressPanel.setMainProgress((int)((float)(i + 1) / (float)sourceMap.size() * 100.0f));
                        sourceData.setStringMap(map);
                    }
                }
                ++i;
            }
        }

        private void showProgressPanel(ProgressWizardPanel progressPanel) {
            Container container = (Container)this.getComponent();
            container.add((Component)progressPanel, CARD_PROGRESS);
            ((CardLayout)container.getLayout()).show(container, CARD_PROGRESS);
        }

        public HelpCtx getHelp() {
            return new HelpCtx(this.testWizard ? "internation.testing" : "internation.wizard");
        }

        private synchronized ResourceWizardPanel getUI() {
            if (this.resourcePanel == null) {
                this.resourcePanel = new ResourceWizardPanel(this, this.testWizard);
            }
            return this.resourcePanel;
        }
    }

    private class ResourceTableModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return ResourceWizardPanel.this.sourceMap.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return ResourceWizardPanel.this.sourceMap.keySet().toArray()[rowIndex];
            }
            SourceData[] values = new SourceData[]{};
            SourceData value = ResourceWizardPanel.this.sourceMap.values().toArray(values)[rowIndex];
            return value == null ? null : value.getResource();
        }

        public Class getColumnClass(int columnIndex) {
            return DataObject.class;
        }

        @Override
        public String getColumnName(int column) {
            String msgKey = column == 0 ? "CTL_Source" : "CTL_Resource";
            return NbBundle.getMessage(ResourceWizardPanel.class, (String)msgKey);
        }
    }
}

