/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import java.beans.PropertyChangeEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.NbPreferences;

public class JPDABreakpoint
extends Breakpoint {
    static final ClassPath EMPTY_CLASSPATH = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
    public static final String PROP_SUSPEND = "suspend";
    public static final String PROP_HIDDEN = "hidden";
    public static final String PROP_PRINT_TEXT = "printText";
    public static final int SUSPEND_ALL = 2;
    public static final int SUSPEND_EVENT_THREAD = 1;
    public static final int SUSPEND_NONE = 0;
    private boolean enabled = true;
    private boolean hidden = false;
    private int suspend;
    private String printText;
    private Collection<JPDABreakpointListener> breakpointListeners = new HashSet<JPDABreakpointListener>();
    private JPDADebugger session;
    private List<DebuggerEngine> engines = new ArrayList<DebuggerEngine>();

    JPDABreakpoint() {
        Preferences preferences = NbPreferences.forModule(((Object)((Object)this)).getClass()).node("debugging");
        int n = preferences.getInt("default.suspend.action", -1);
        if (n == -1) {
            Properties properties = Properties.getDefault().getProperties("debugger.options.JPDA");
            n = properties.getInt("BreakpointSuspend", 1);
        }
        switch (n) {
            case 0: {
                this.suspend = 0;
                break;
            }
            case 1: {
                this.suspend = 1;
                break;
            }
            case 2: {
                this.suspend = 2;
            }
        }
    }

    public int getSuspend() {
        return this.suspend;
    }

    public void setSuspend(int n) {
        if (n == this.suspend) {
            return;
        }
        int n2 = this.suspend;
        this.suspend = n;
        this.firePropertyChange(PROP_SUSPEND, n2, n);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean bl) {
        if (bl == this.hidden) {
            return;
        }
        boolean bl2 = this.hidden;
        this.hidden = bl;
        this.firePropertyChange(PROP_HIDDEN, bl2, bl);
    }

    public String getPrintText() {
        return this.printText;
    }

    public void setPrintText(String string) {
        if (string.equals(this.printText)) {
            return;
        }
        String string2 = this.printText;
        this.printText = string;
        this.firePropertyChange(PROP_PRINT_TEXT, string2, string);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        this.firePropertyChange("enabled", Boolean.TRUE, Boolean.FALSE);
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        this.firePropertyChange("enabled", Boolean.FALSE, Boolean.TRUE);
    }

    synchronized void setSession(JPDADebugger jPDADebugger) {
        this.session = jPDADebugger;
    }

    synchronized JPDADebugger getSession() {
        return this.session;
    }

    public synchronized void addJPDABreakpointListener(JPDABreakpointListener jPDABreakpointListener) {
        this.breakpointListeners.add(jPDABreakpointListener);
    }

    public synchronized void removeJPDABreakpointListener(JPDABreakpointListener jPDABreakpointListener) {
        this.breakpointListeners.remove(jPDABreakpointListener);
    }

    void fireJPDABreakpointChange(JPDABreakpointEvent jPDABreakpointEvent) {
        Iterator<JPDABreakpointListener> iterator = new HashSet<JPDABreakpointListener>(this.breakpointListeners).iterator();
        while (iterator.hasNext()) {
            iterator.next().breakpointReached(jPDABreakpointEvent);
        }
    }

    void enginePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (DebuggerEngine.class.getName().equals(propertyChangeEvent.getPropertyName())) {
            DebuggerEngine debuggerEngine = (DebuggerEngine)propertyChangeEvent.getOldValue();
            DebuggerEngine debuggerEngine2 = (DebuggerEngine)propertyChangeEvent.getNewValue();
            if (debuggerEngine != null) {
                this.engines.remove(debuggerEngine);
            }
            if (debuggerEngine2 != null) {
                this.engines.add(debuggerEngine2);
            }
            this.firePropertyChange("groupProperties", null, null);
        }
    }

    DebuggerEngine[] getEngines() {
        if (this.engines.size() == 0) {
            return null;
        }
        return this.engines.toArray(new DebuggerEngine[0]);
    }

    static void fillFilesForClass(String string, List<FileObject> list) {
        int n = string.lastIndexOf(46);
        int n2 = string.indexOf(36);
        if (n2 > 0) {
            string = string.substring(0, n2);
        }
        String string2 = string;
        if (n > 0) {
            string2 = string.substring(n + 1);
        }
        Collection collection = QuerySupport.findRoots((Project)null, Collections.singleton("classpath/source"), Collections.emptySet(), Collections.emptySet());
        for (FileObject fileObject : collection) {
            URL uRL;
            try {
                uRL = fileObject.getURL();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                continue;
            }
            ClassPath classPath = ClassPathSupport.createClassPath((URL[])new URL[]{uRL});
            ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)EMPTY_CLASSPATH, (ClassPath)EMPTY_CLASSPATH, (ClassPath)classPath);
            Set set = classpathInfo.getClassIndex().getDeclaredTypes(string2, ClassIndex.NameKind.SIMPLE_NAME, EnumSet.of(ClassIndex.SearchScope.SOURCE));
            for (ElementHandle elementHandle : set) {
                if (!string.equals(elementHandle.getQualifiedName())) continue;
                FileObject fileObject2 = SourceUtils.getFile((ElementHandle)elementHandle, (ClasspathInfo)classpathInfo);
                list.add(fileObject2);
            }
        }
    }
}

