/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import org.netbeans.modules.cnd.debugger.gdb.Variable;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;

public class ValuePresenter {
    private static Presenter[] presenters = new Presenter[]{new StdStringPresenter()};

    private ValuePresenter() {
    }

    public static String getValue(Variable var) {
        return ValuePresenter.getValue(var.getType(), var.getValue());
    }

    public static String getValue(String value) {
        return ValuePresenter.getValue(null, value);
    }

    public static String getValue(String type, String value) {
        for (Presenter vp : presenters) {
            if (!vp.accepts(type, value)) continue;
            return vp.present(type, value);
        }
        return value;
    }

    private static class StdStringPresenter
    implements Presenter {
        private static final String VALUE_PREFIX = "_M_p";
        private static final String TYPE_NAME = "string";
        private static final String TYPE_NAME2 = "string &";

        private StdStringPresenter() {
        }

        @Override
        public boolean accepts(String type, String value) {
            if (type == null) {
                return StdStringPresenter.checkValue(value);
            }
            return (TYPE_NAME.equals(type) || TYPE_NAME2.equals(type)) && value != null && value.contains(VALUE_PREFIX);
        }

        private static boolean checkValue(String value) {
            if (value == null || value.length() < 10) {
                return false;
            }
            int start = value.indexOf(123);
            if (start == -1) {
                return false;
            }
            int end = value.lastIndexOf(125);
            if (end == -1 || end < start + 1) {
                return false;
            }
            if ((value = value.substring(start + 1, end)).indexOf("static npos") == -1) {
                return false;
            }
            return value.indexOf(VALUE_PREFIX) != -1;
        }

        @Override
        public String present(String type, String value) {
            int pos = value.indexOf(VALUE_PREFIX);
            assert (pos > 0);
            if ((pos = value.indexOf(34, pos)) > 0) {
                if (value.charAt(pos - 1) == '\\') {
                    return this.present(type, value.replace("\\\"", "\""));
                }
                int end = GdbUtils.findEndOfString(value, pos + 1);
                if (end != -1) {
                    return value.substring(pos, end + 1);
                }
            }
            return value;
        }
    }

    private static interface Presenter {
        public boolean accepts(String var1, String var2);

        public String present(String var1, String var2);
    }
}

