/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.checker;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.checker.ElBeanContextChecker;
import org.netbeans.modules.web.core.syntax.checker.ElContextChecker;
import org.netbeans.modules.web.core.syntax.checker.ElStartContextChecker;
import org.netbeans.modules.web.core.syntax.completion.JspELExpression;
import org.netbeans.modules.web.core.syntax.completion.api.ELExpression;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class JspElChecker {
    protected static Rule.ErrorRule DEFAULT_ERROR_RULE = new Rule(HintSeverity.ERROR, true);
    protected static final int DEFAULT_ERROR_HINT_PRIORITY = 50;
    private static final Map<Integer, ElContextChecker> CHECKERS = new HashMap<Integer, ElContextChecker>();

    public ELExpression parseExpression(Document doc, int offset) throws BadLocationException {
        JspELExpression expression = new JspELExpression(JspSyntaxSupport.get(doc), offset);
        expression.parse();
        return expression;
    }

    public void check(List<Hint> hints, Document document, FileObject fileObject, Map<Class<? extends ELExpression>, ELExpression> expressions) {
        JspELExpression expression = (JspELExpression)expressions.get(JspELExpression.class);
        int parseType = expression.getParseType();
        if (parseType == 5) {
            String beanName = expression.getBeanName();
            Hint hint = new Hint((org.netbeans.modules.csl.api.Rule)DEFAULT_ERROR_RULE, NbBundle.getMessage(JspElChecker.class, (String)"MSG_UNKNOWN_BEAN_CONTEXT", (Object)beanName), fileObject, new OffsetRange(expression.getStartOffset(), expression.getStartOffset() + beanName.length()), Collections.emptyList(), 50);
            hints.add(hint);
            return;
        }
    }

    static {
        CHECKERS.put(1, new ElStartContextChecker());
        CHECKERS.put(2, new ElBeanContextChecker());
        CHECKERS.put(3, CHECKERS.get(2));
    }

    protected static final class Rule
    implements Rule.ErrorRule {
        private HintSeverity severity;
        private boolean showInTasklist;

        private Rule(HintSeverity severity, boolean showInTaskList) {
            this.severity = severity;
            this.showInTasklist = showInTaskList;
        }

        public Set<?> getCodes() {
            return Collections.emptySet();
        }

        public boolean appliesTo(RuleContext context) {
            return true;
        }

        public String getDisplayName() {
            return "jsp";
        }

        public boolean showInTasklist() {
            return this.showInTasklist;
        }

        public HintSeverity getDefaultSeverity() {
            return this.severity;
        }
    }
}

