/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.Language;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.LanguagesManager;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.database.DatabaseContext;
import org.netbeans.api.languages.database.DatabaseDefinition;
import org.netbeans.modules.languages.Utils;
import org.netbeans.modules.languages.features.DatabaseManager;
import org.netbeans.modules.languages.features.FileNotParsedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class Index {
    private static Map<FileObject, ProjectCache> projectToCache = new WeakHashMap<FileObject, ProjectCache>();
    private static List<FileObject> roots;
    private static File cacheFolder;

    public static Map<FileObject, List<DatabaseDefinition>> getGlobalItems(FileObject fo, boolean parse) throws FileNotParsedException {
        HashMap<FileObject, List<DatabaseDefinition>> result = new HashMap<FileObject, List<DatabaseDefinition>>();
        FileObject projectDir = Utils.getProjectRoot(fo);
        if (projectDir == null) {
            return result;
        }
        Index.getProjectCache(projectDir, parse).add(result, null);
        return result;
    }

    public static Map<FileObject, List<DatabaseDefinition>> getGlobalItem(FileObject fo, String name, boolean parse) throws FileNotParsedException {
        HashMap<FileObject, List<DatabaseDefinition>> result = new HashMap<FileObject, List<DatabaseDefinition>>();
        FileObject projectDir = Utils.getProjectRoot(fo);
        if (projectDir == null) {
            return result;
        }
        Index.getProjectCache(projectDir, parse).add(result, name);
        return result;
    }

    private static ProjectCache getProjectCache(FileObject projectDir, boolean parse) throws FileNotParsedException {
        ProjectCache cache = projectToCache.get(projectDir);
        if (cache == null) {
            cache = Index.readProjectCache(projectDir);
        }
        if (cache == null) {
            if (!parse) {
                throw new FileNotParsedException();
            }
            cache = new ProjectCache(projectDir);
            projectToCache.put(projectDir, cache);
        }
        return cache;
    }

    private static ProjectCache readProjectCache(FileObject projectDir) {
        try {
            File f = Index.getProjectCacheFile(projectDir);
            if (f == null) {
                return null;
            }
            return ProjectCache.load(projectDir, f);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getProjectCacheFile(FileObject projectDir) {
        File file;
        File cacheFolder = Index.getCacheFolder();
        if (roots != null) {
            int i = roots.indexOf(projectDir);
            if (i < 0) {
                return null;
            }
            return new File(cacheFolder, "s" + (i + 1));
        }
        roots = new ArrayList<FileObject>();
        File segments = new File(cacheFolder, "segments");
        if (!segments.exists()) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new FileReader(segments));
        try {
            File result = null;
            int i = 1;
            String path = reader.readLine();
            while (path != null) {
                File file2 = new File(path);
                FileObject fo = FileUtil.toFileObject((File)(file2 = FileUtil.normalizeFile((File)file2)));
                if (fo == null) {
                    System.out.println(Index.class.getName() + " File not found: " + file2);
                } else {
                    roots.add(fo);
                    if (fo.equals(projectDir)) {
                        result = new File(cacheFolder, "s" + i);
                    }
                }
                path = reader.readLine();
                ++i;
            }
            file = result;
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return null;
            }
        }
        reader.close();
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() throws IOException {
        File dir = Index.getCacheFolder();
        File segments = new File(dir, "segments");
        BufferedWriter writer = new BufferedWriter(new FileWriter(segments));
        try {
            int i = 1;
            for (FileObject fo : projectToCache.keySet()) {
                ProjectCache cache = projectToCache.get(fo);
                File s = new File(dir, "s" + i);
                cache.save(s);
                writer.write(fo.getPath());
                writer.newLine();
            }
        }
        finally {
            writer.close();
        }
    }

    private static synchronized File getCacheFolder() {
        if (cacheFolder == null) {
            String userDir = System.getProperty("netbeans.user");
            assert (userDir != null);
            String cacheDir = userDir + File.separatorChar + "var" + File.separatorChar + "cache" + File.separatorChar + "sindex" + File.separatorChar + "1.0";
            cacheFolder = FileUtil.normalizeFile((File)new File(cacheDir));
            if (!cacheFolder.exists()) {
                boolean created = cacheFolder.mkdirs();
                assert (created) : "Cannot create cache folder";
            } else assert (cacheFolder.isDirectory() && cacheFolder.canRead() && cacheFolder.canWrite());
        }
        return cacheFolder;
    }

    private static class FileCache {
        private FileObject fileObject;
        private List<DatabaseDefinition> definitions;

        FileCache(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        private FileCache(FileObject fileObject, List<DatabaseDefinition> definitions) {
            this.fileObject = fileObject;
            this.definitions = definitions;
        }

        private DatabaseContext getRoot(FileObject fo) throws LanguageDefinitionNotFoundException, IOException, ParseException {
            Language l = LanguagesManager.get().getLanguage(fo.getMIMEType());
            ASTNode root = l.parse(fo.getInputStream());
            return DatabaseManager.parse(root, null, null);
        }

        private synchronized void add(Map<FileObject, List<DatabaseDefinition>> result, String name) {
            List<DatabaseDefinition> l;
            if (this.definitions == null) {
                this.definitions = new ArrayList<DatabaseDefinition>();
                try {
                    DatabaseContext r = this.getRoot(this.fileObject);
                    this.definitions = r.getDefinitions();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ParseException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (name == null) {
                if (!this.definitions.isEmpty()) {
                    l = result.get(this.fileObject);
                    if (l == null) {
                        l = new ArrayList<DatabaseDefinition>();
                        result.put(this.fileObject, l);
                    }
                    l.addAll(this.definitions);
                }
            } else {
                l = result.get(this.fileObject);
                for (DatabaseDefinition definition : this.definitions) {
                    if (!definition.getName().equals(name)) continue;
                    if (l == null) {
                        l = new ArrayList<DatabaseDefinition>();
                        result.put(this.fileObject, l);
                    }
                    l.add(definition);
                }
            }
        }

        static FileCache load(FileObject fo, DataInputStream is) throws IOException {
            ArrayList<DatabaseDefinition> definitions = new ArrayList<DatabaseDefinition>();
            for (int i = is.readInt(); i > 0; --i) {
                definitions.add(DatabaseDefinition.load(is));
            }
            return new FileCache(fo, definitions);
        }

        private synchronized void save(DataOutputStream os) throws IOException {
            os.writeInt(this.definitions.size());
            Iterator<DatabaseDefinition> it = this.definitions.iterator();
            while (it.hasNext()) {
                it.next().save(os);
            }
        }
    }

    private static class ProjectCache {
        private FileObject root;
        private Map<FileObject, FileCache> cache;

        ProjectCache(FileObject root) {
            this.root = root;
        }

        ProjectCache(FileObject root, Map<FileObject, FileCache> cache) {
            this.root = root;
            this.cache = cache;
        }

        private synchronized void add(Map<FileObject, List<DatabaseDefinition>> result, String name) {
            if (this.cache == null) {
                this.cache = new HashMap<FileObject, FileCache>();
                this.init(this.root);
            }
            for (FileCache fileCache : this.cache.values()) {
                fileCache.add(result, name);
            }
        }

        private synchronized void init(FileObject root) {
            for (FileObject fo : root.getChildren()) {
                if (fo.isFolder()) {
                    this.init(fo);
                    continue;
                }
                if (!"js".equals(fo.getExt())) continue;
                FileCache fc = new FileCache(fo);
                this.cache.put(fo, fc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static ProjectCache load(FileObject root, File f) throws IOException {
            DataInputStream is = new DataInputStream(new FileInputStream(f));
            try {
                HashMap<FileObject, FileCache> cache = new HashMap<FileObject, FileCache>();
                for (int i = is.readInt(); i > 0; --i) {
                    String path = is.readUTF();
                    File file = new File(path);
                    file = FileUtil.normalizeFile((File)file);
                    FileObject fo = FileUtil.toFileObject((File)file);
                    FileCache fc = FileCache.load(fo, is);
                    cache.put(fo, fc);
                }
                ProjectCache projectCache = new ProjectCache(root, cache);
                return projectCache;
            }
            finally {
                is.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void save(File f) throws IOException {
            DataOutputStream os = new DataOutputStream(new FileOutputStream(f));
            try {
                os.writeInt(this.cache.size());
                for (FileObject fileObject : this.cache.keySet()) {
                    os.writeUTF(fileObject.getPath());
                    FileCache fc = this.cache.get(fileObject);
                    fc.save(os);
                }
            }
            finally {
                os.close();
            }
        }
    }
}

