/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.ppoints.TriggeredGlobalProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ui.SnapshotCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.TriggerCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.ppoints.ui.ValidityListener;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class TriggeredTakeSnapshotCustomizer
extends ValidityAwarePanel
implements DocumentListener,
ValidityListener,
HelpCtx.Provider {
    private static final String NAME_LABEL_TEXT = NbBundle.getMessage(TriggeredTakeSnapshotCustomizer.class, (String)"TriggeredTakeSnapshotCustomizer_NameLabelText");
    private static final String SETTINGS_LABEL_TEXT = NbBundle.getMessage(TriggeredTakeSnapshotCustomizer.class, (String)"TriggeredTakeSnapshotCustomizer_SettingsLabelText");
    private static final String TRIGGER_LABEL_TEXT = NbBundle.getMessage(TriggeredTakeSnapshotCustomizer.class, (String)"TriggeredTakeSnapshotCustomizer_TriggerLabelText");
    private static final String HELP_CTX_KEY = "TriggeredTakeSnapshotCustomizer.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("TriggeredTakeSnapshotCustomizer.HelpCtx");
    private static int defaultTextComponentHeight = -1;
    private JComboBox triggerWhenCombo;
    private JLabel captionLabel;
    private JLabel nameLabel;
    private JLabel settingsHeaderLabel;
    private JLabel triggerExceedsLabel;
    private JLabel triggerGenerationsLabel;
    private JLabel triggerHeaderLabel;
    private JLabel triggerWhenLabel;
    private JPanel captionPanel;
    private JRadioButton triggerAlwaysRadio;
    private JRadioButton triggerOnceRadio;
    private JSeparator settingsHeaderSeparator;
    private JSeparator triggerHeaderSeparator;
    private JTextField nameTextField;
    private SnapshotCustomizer snapshotCustomizer;
    private TriggerCustomizer triggerCustomizer;

    public TriggeredTakeSnapshotCustomizer(String caption, Icon icon) {
        this.initComponents(caption, icon);
        this.normalizeCaptionAreaWidth();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    @Override
    public Component getInitialFocusTarget() {
        return this.nameTextField;
    }

    public void setPPFile(String fileName) {
        this.snapshotCustomizer.setPPFile(fileName);
    }

    public String getPPFile() {
        return this.snapshotCustomizer.getPPFile();
    }

    public void setPPName(String name) {
        this.nameTextField.setText(name);
    }

    public String getPPName() {
        return this.nameTextField.getText();
    }

    public void setPPResetResults(boolean resetResults) {
        this.snapshotCustomizer.setPPResetResults(resetResults);
    }

    public boolean getPPResetResults() {
        return this.snapshotCustomizer.getPPResetResults();
    }

    public void setPPTarget(boolean target) {
        this.snapshotCustomizer.setPPTarget(target);
    }

    public boolean getPPTarget() {
        return this.snapshotCustomizer.getPPTarget();
    }

    public void setPPType(boolean type) {
        this.snapshotCustomizer.setPPType(type);
    }

    public boolean getPPType() {
        return this.snapshotCustomizer.getPPType();
    }

    public int getPreferredCaptionAreaWidth() {
        return -1;
    }

    public void setTriggerCondition(TriggeredGlobalProfilingPoint.TriggerCondition condition) {
        this.triggerCustomizer.setTriggerCondition(condition);
    }

    public TriggeredGlobalProfilingPoint.TriggerCondition getTriggerCondition() {
        return this.triggerCustomizer.getTriggerCondition();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    public void initComponents(String caption, Icon icon) {
        this.setLayout(new GridBagLayout());
        this.captionPanel = new JPanel(new BorderLayout(0, 0));
        this.captionPanel.setOpaque(true);
        this.captionPanel.setBackground(UIUtils.getProfilerResultsBackground());
        this.captionLabel = new JLabel(caption, icon, 10);
        this.captionLabel.setFont(this.captionLabel.getFont().deriveFont(1));
        this.captionLabel.setOpaque(false);
        this.captionLabel.setBorder(BorderFactory.createEmptyBorder(6, 8, 6, 6));
        this.captionPanel.add((Component)this.captionLabel, "West");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 16, 0);
        this.add((Component)this.captionPanel, constraints);
        this.nameLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NAME_LABEL_TEXT);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 8, 10, 5);
        this.add((Component)this.nameLabel, constraints);
        this.nameTextField = new JTextField(""){

            @Override
            public Dimension getPreferredSize() {
                return TriggeredTakeSnapshotCustomizer.this.getParent() instanceof JViewport ? this.getMinimumSize() : new Dimension(400, super.getPreferredSize().height);
            }

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, super.getPreferredSize().height);
            }
        };
        this.nameLabel.setLabelFor(this.nameTextField);
        this.nameTextField.getDocument().addDocumentListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 10, 13);
        this.add((Component)this.nameTextField, constraints);
        JPanel settingsHeaderContainer = new JPanel(new GridBagLayout());
        this.settingsHeaderLabel = new JLabel(SETTINGS_LABEL_TEXT);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        settingsHeaderContainer.add((Component)this.settingsHeaderLabel, constraints);
        this.settingsHeaderSeparator = new JSeparator(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        settingsHeaderContainer.add((Component)this.settingsHeaderSeparator, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 8, 5, 8);
        this.add((Component)settingsHeaderContainer, constraints);
        this.snapshotCustomizer = new SnapshotCustomizer();
        this.snapshotCustomizer.addValidityListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 20, 12, 13);
        this.add((Component)this.snapshotCustomizer, constraints);
        JPanel triggerHeaderContainer = new JPanel(new GridBagLayout());
        this.triggerHeaderLabel = new JLabel(TRIGGER_LABEL_TEXT);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        triggerHeaderContainer.add((Component)this.triggerHeaderLabel, constraints);
        this.triggerHeaderSeparator = new JSeparator(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        triggerHeaderContainer.add((Component)this.triggerHeaderSeparator, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 8, 5, 8);
        this.add((Component)triggerHeaderContainer, constraints);
        this.triggerCustomizer = new TriggerCustomizer();
        this.triggerCustomizer.addValidityListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 20, 5, 13);
        this.add((Component)this.triggerCustomizer, constraints);
        JPanel fillerPanel = new JPanel(new FlowLayout(3, 0, 0));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 7;
        constraints.weighty = 1.0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)fillerPanel, constraints);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    public static void main(String[] args) {
    }

    public void normalizeCaptionAreaWidth() {
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    @Override
    public void validityChanged(boolean isValid) {
        this.updateValidity();
    }

    private boolean isNameEmpty() {
        return this.nameTextField.getText().trim().length() == 0;
    }

    private boolean areTriggerSettingsValid() {
        return true;
    }

    private void updateValidity() {
        boolean isValid;
        boolean bl = isValid = !this.isNameEmpty() && this.snapshotCustomizer.areSettingsValid() && this.areTriggerSettingsValid();
        if (isValid != this.areSettingsValid()) {
            this.fireValidityChanged(isValid);
        }
    }
}

