/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.netbeans.lib.uihandler.Decorable;
import org.netbeans.lib.uihandler.LogRecords;
import org.netbeans.modules.uihandler.VisualData;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

final class UINode
extends AbstractNode
implements VisualData,
Decorable {
    private static final SimpleFormatter FORMATTER = new SimpleFormatter();
    private LogRecord log;
    private String htmlKey;

    private UINode(LogRecord r, Children ch) {
        super(ch, Lookups.fixed((Object[])new Object[]{r}));
        this.log = r;
        LogRecords.decorate((LogRecord)r, (Decorable)this);
        Sheet.Set s = Sheet.createPropertiesSet();
        s.put(UINode.createPropertyDate(this));
        s.put(UINode.createPropertyLogger(this));
        s.put(UINode.createPropertyMessage(this));
        this.getSheet().put(s);
        if (r.getParameters() != null && r.getParameters().length > 0) {
            Sheet.Set paramSheet = new Sheet.Set();
            paramSheet.setName("parameters");
            paramSheet.setDisplayName(NbBundle.getMessage(UINode.class, (String)"MSG_DisplayNameParameters"));
            for (int i = 0; i < r.getParameters().length; ++i) {
                paramSheet.put(this.createProperty(i, UINode.getParam(r, i, Object.class)));
            }
            this.getSheet().put(paramSheet);
        }
    }

    @Override
    public long getMillis() {
        return this.log.getMillis();
    }

    @Override
    public String getLoggerName() {
        return this.log.getLoggerName();
    }

    @Override
    public String getMessage() {
        return FORMATTER.format(this.log);
    }

    public String getHtmlDisplayName() {
        if (this.htmlKey == null) {
            return null;
        }
        return NbBundle.getMessage(UINode.class, (String)this.htmlKey, (Object)this.getDisplayName());
    }

    static String getParam(LogRecord r, int index) {
        Object[] arr = r.getParameters();
        if (arr == null || arr.length <= index || !(arr[index] instanceof String)) {
            return "";
        }
        return (String)arr[index];
    }

    static Node create(LogRecord r) {
        Children.Keys ch = r.getThrown() != null ? new StackTraceChildren(r.getThrown()) : ("UI_ENABLED_MODULES".equals(r.getMessage()) || "UI_DISABLED_MODULES".equals(r.getMessage()) ? new ModulesChildren(r.getParameters()) : Children.LEAF);
        return new UINode(r, (Children)ch);
    }

    static Node.Property createPropertyDate(VisualData source) {
        class NP
        extends PropertySupport.ReadOnly<Date> {
            final /* synthetic */ VisualData val$source;

            public NP(VisualData visualData) {
                this.val$source = visualData;
                super("date", Date.class, NbBundle.getMessage(UINode.class, (String)"MSG_DateDisplayName"), NbBundle.getMessage(UINode.class, (String)"MSG_DateShortDescription"));
            }

            public Date getValue() throws IllegalAccessException, InvocationTargetException {
                return this.val$source == null ? null : new Date(this.val$source.getMillis());
            }

            public int hashCode() {
                return ((Object)((Object)this)).getClass().hashCode();
            }

            public boolean equals(Object o) {
                return o != null && o.getClass().equals(((Object)((Object)this)).getClass());
            }
        }
        return new NP(source);
    }

    static Node.Property createPropertyLogger(VisualData source) {
        class NP
        extends PropertySupport.ReadOnly<String> {
            final /* synthetic */ VisualData val$source;

            public NP(VisualData visualData) {
                this.val$source = visualData;
                super("logger", String.class, NbBundle.getMessage(UINode.class, (String)"MSG_LoggerDisplayName"), NbBundle.getMessage(UINode.class, (String)"MSG_LoggerShortDescription"));
            }

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                if (this.val$source == null) {
                    return null;
                }
                String full = this.val$source.getLoggerName();
                if (full == null) {
                    return null;
                }
                if (full.startsWith("org.netbeans.ui")) {
                    if (full.equals("org.netbeans.ui")) {
                        return "UI General";
                    }
                    return full.substring("org.netbeans.ui.".length());
                }
                return full;
            }

            public int hashCode() {
                return ((Object)((Object)this)).getClass().hashCode();
            }

            public boolean equals(Object o) {
                return o != null && o.getClass().equals(((Object)((Object)this)).getClass());
            }
        }
        return new NP(source);
    }

    static Node.Property createPropertyMessage(VisualData source) {
        class NP
        extends PropertySupport.ReadOnly<String> {
            final /* synthetic */ VisualData val$source;

            public NP(VisualData visualData) {
                this.val$source = visualData;
                super("message", String.class, NbBundle.getMessage(UINode.class, (String)"MSG_MessageDisplayName"), NbBundle.getMessage(UINode.class, (String)"MSG_MessageShortDescription"));
            }

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                return this.val$source == null ? null : this.val$source.getMessage();
            }

            public int hashCode() {
                return ((Object)((Object)this)).getClass().hashCode();
            }

            public boolean equals(Object o) {
                return o != null && o.getClass().equals(((Object)((Object)this)).getClass());
            }
        }
        return new NP(source);
    }

    private Node.Property<?> createProperty(final int index, final Object object) {
        class NP
        extends PropertySupport.ReadOnly<String> {
            public NP() {
                super("param #" + n, String.class, NbBundle.getMessage(UINode.class, (String)"MSG_ParameterDisplayName", (Object)n, (Object)object2), NbBundle.getMessage(UINode.class, (String)"MSG_ParameterShortDescription", (Object)n, (Object)object2));
            }

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                return object == null ? null : object.toString();
            }

            private int getIndex() {
                return index;
            }

            public int hashCode() {
                return ((Object)((Object)this)).getClass().hashCode();
            }

            public boolean equals(Object o) {
                if (o == null || !o.getClass().equals(((Object)((Object)this)).getClass())) {
                    return false;
                }
                NP np = (NP)((Object)o);
                return this.getIndex() == np.getIndex();
            }
        }
        return new NP();
    }

    private static String afterLastDot(String s) {
        int index = s.lastIndexOf(46);
        if (index == -1) {
            return s;
        }
        return s.substring(index + 1);
    }

    private static <T> T getParam(LogRecord r, int index, Class<T> type) {
        if (r == null || r.getParameters() == null || r.getParameters().length <= index) {
            return null;
        }
        Object o = r.getParameters()[index];
        return type.isInstance(o) ? (T)type.cast(o) : null;
    }

    private static final class ModulesChildren
    extends Children.Keys<Object> {
        private Object[] modules;

        public ModulesChildren(Object[] m) {
            this.modules = m;
        }

        protected void addNotify() {
            this.setKeys(this.modules);
        }

        protected Node[] createNodes(Object key) {
            AbstractNode an = new AbstractNode(Children.LEAF);
            an.setName((String)key);
            an.setIconBaseWithExtension("org/netbeans/lib/uihandler/module.gif");
            return new Node[]{an};
        }
    }

    private static final class StackTraceChildren
    extends Children.Keys<StackTraceElement> {
        private Throwable throwable;

        public StackTraceChildren(Throwable t) {
            this.throwable = t;
        }

        protected void addNotify() {
            this.setKeys(this.throwable.getStackTrace());
        }

        protected Node[] createNodes(StackTraceElement key) {
            AbstractNode an = new AbstractNode(Children.LEAF);
            an.setName(key.getClassName() + "." + key.getMethodName());
            an.setDisplayName(NbBundle.getMessage(UINode.class, (String)"MSG_StackTraceElement", (Object[])new Object[]{key.getFileName(), key.getClassName(), key.getMethodName(), key.getLineNumber(), UINode.afterLastDot(key.getClassName())}));
            an.setIconBaseWithExtension("org/netbeans/modules/uihandler/stackframe.gif");
            return new Node[]{an};
        }
    }
}

