/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.gsf.api.DataLoadersBridge;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfret.source.SourceAccessor;
import org.netbeans.modules.gsfret.source.usages.RepositoryUpdater;
import org.netbeans.napi.gsfret.source.Source;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class ActivatedDocumentListener
implements PropertyChangeListener {
    private static ActivatedDocumentListener INSTANCE;
    private FileObject lastValidFile;
    public static boolean IGNORE_COMPILE_REQUESTS;

    public static void register() {
        INSTANCE = new ActivatedDocumentListener();
    }

    private ActivatedDocumentListener() {
        EditorRegistry.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        Source activeJS;
        JTextComponent activeComponent = EditorRegistry.lastFocusedComponent();
        if (activeComponent == null) {
            return;
        }
        Document active = activeComponent.getDocument();
        if (active == null) {
            return;
        }
        FileObject activeFile = DataLoadersBridge.getDefault().getFileObject(active);
        if (activeFile == null) {
            return;
        }
        if (this.lastValidFile == activeFile) {
            return;
        }
        if (this.lastValidFile != null && RepositoryUpdater.isRelevantSource(this.lastValidFile)) {
            FileObject owner;
            ClassPath cp;
            if (!IGNORE_COMPILE_REQUESTS && (cp = ClassPath.getClassPath((FileObject)this.lastValidFile, (String)"classpath/source")) != null && (owner = cp.findOwnerRoot(this.lastValidFile)) != null) {
                try {
                    if ("file".equals(this.lastValidFile.getURL().getProtocol())) {
                        RepositoryUpdater.getDefault().scheduleCompilation(this.lastValidFile, owner);
                    }
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
            this.lastValidFile = null;
        }
        if ((activeJS = Source.forFileObject(activeFile)) == null) {
            return;
        }
        this.lastValidFile = activeFile;
        SourceAccessor.getINSTANCE().revalidate(activeJS);
    }

    static {
        IGNORE_COMPILE_REQUESTS = false;
    }
}

