/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyEventType;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.DataLoadersBridge;
import org.netbeans.modules.gsf.api.EditHistory;
import org.netbeans.modules.gsf.api.EmbeddingModel;
import org.netbeans.modules.gsf.api.IncrementalEmbeddingModel;
import org.netbeans.modules.gsf.api.IncrementalParser;
import org.netbeans.modules.gsf.api.ParseEvent;
import org.netbeans.modules.gsf.api.ParseListener;
import org.netbeans.modules.gsf.api.Parser;
import org.netbeans.modules.gsf.api.ParserFile;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.SourceFileReader;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.gsf.spi.DefaultParserFile;
import org.netbeans.modules.gsf.spi.GsfUtilities;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfret.source.SourceAccessor;
import org.netbeans.modules.gsfret.source.usages.ClassIndexImpl;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.netbeans.modules.gsfret.source.util.LowMemoryEvent;
import org.netbeans.modules.gsfret.source.util.LowMemoryListener;
import org.netbeans.modules.gsfret.source.util.LowMemoryNotifier;
import org.netbeans.napi.gsfret.source.ClasspathInfo;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.napi.gsfret.source.ModificationResult;
import org.netbeans.napi.gsfret.source.ParserTaskImpl;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.StringSourceFileReader;
import org.netbeans.napi.gsfret.source.WorkingCopy;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class Source {
    private static final int INVALID = 1;
    private static final int CHANGE_EXPECTED = 2;
    private static final int RESCHEDULE_FINISHED_TASKS = 4;
    private static final int UPDATE_INDEX = 8;
    private static final boolean reportSlowTasks = Boolean.getBoolean("org.netbeans.napi.gsfret.source.Source.reportSlowTasks");
    private static final int SLOW_TASK_LIMIT = 250;
    private static final int SLOW_CANCEL_LIMIT = 50;
    static int REPARSE_DELAY = 500;
    private static Map<Phase, String> phase2Key = new HashMap<Phase, String>();
    private static Map<Phase, String> phase2Message = new HashMap<Phase, String>();
    private static final PriorityBlockingQueue<Request> requests;
    private static final Map<Source, Collection<Request>> finishedRequests;
    private static final Map<Source, Collection<Request>> waitingRequests;
    private static final Collection<CancellableTask> toRemove;
    private static final SingleThreadFactory factory;
    private static final CurrentRequestReference currentRequest;
    private static final EditorRegistryListener editorRegistryListener;
    private static final ReentrantLock javacLock;
    private final Collection<FileObject> files;
    private final FileObject rootFo;
    private final FileChangeListener fileChangeListener;
    private DocListener listener;
    private PropertyChangeListener dataObjectListener;
    private final ClasspathInfo classpathInfo;
    private CompilationInfo currentInfo;
    private Map<String, ParserResult> recentParseResult = new HashMap<String, ParserResult>();
    private Map<EmbeddingModel, Collection<? extends TranslatedSource>> recentEmbeddingTranslations = new IdentityHashMap<EmbeddingModel, Collection<? extends TranslatedSource>>();
    private EditHistory editHistory = new EditHistory();
    private Stack<CompilationInfo> infoStack = new Stack();
    private int flags = 0;
    private Object filterListener;
    private boolean possiblyIncremental;
    private static Map<FileObject, Reference<Source>> file2JavaSource;
    private final RequestProcessor.Task resetTask = RequestProcessor.getDefault().create(new Runnable(){

        @Override
        public void run() {
            Source.this.resetStateImpl();
        }
    });
    private static final int MAX_DUMPS = 255;

    public static Source create(ClasspathInfo cpInfo, Collection<? extends FileObject> files) throws IllegalArgumentException {
        if (files == null || cpInfo == null) {
            throw new IllegalArgumentException();
        }
        try {
            return new Source(cpInfo, files);
        }
        catch (DataObjectNotFoundException donf) {
            Logger.getLogger("global").warning("Ignoring non existent file: " + FileUtil.getFileDisplayName((FileObject)donf.getFileObject()));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public static Source create(ClasspathInfo cpInfo, FileObject ... files) throws IllegalArgumentException {
        if (files == null || cpInfo == null) {
            throw new IllegalArgumentException();
        }
        return Source.create(cpInfo, Arrays.asList(files));
    }

    public static void clearSourceCache() {
        file2JavaSource.clear();
    }

    public static Source forFileObject(FileObject fileObject) throws IllegalArgumentException {
        Source js;
        if (fileObject == null) {
            throw new IllegalArgumentException("fileObject == null");
        }
        if (!fileObject.isValid() || fileObject.isFolder()) {
            return null;
        }
        if (!LanguageRegistry.getInstance().isSupported(fileObject.getMIMEType())) {
            return null;
        }
        Reference<Source> ref = file2JavaSource.get(fileObject);
        Source source = js = ref != null ? ref.get() : null;
        if (js == null) {
            js = Source.create(ClasspathInfo.create(fileObject), fileObject);
            file2JavaSource.put(fileObject, new WeakReference<Source>(js));
        }
        return js;
    }

    public static Source forDocument(Document doc) throws IllegalArgumentException {
        FileObject fo;
        Source js;
        if (doc == null) {
            throw new IllegalArgumentException("doc == null");
        }
        Reference ref = (Reference)doc.getProperty(Source.class);
        Source source = js = ref != null ? (Source)ref.get() : null;
        if (js == null && (fo = DataLoadersBridge.getDefault().getFileObject(doc)) != null) {
            js = Source.forFileObject(fo);
        }
        return js;
    }

    private Source(ClasspathInfo cpInfo, Collection<? extends FileObject> files) throws IOException {
        this.files = Collections.unmodifiableList(new ArrayList<FileObject>(files));
        this.fileChangeListener = new FileChangeListenerImpl();
        boolean multipleSources = this.files.size() > 1;
        boolean filterAssigned = false;
        Iterator<FileObject> it = this.files.iterator();
        while (it.hasNext()) {
            FileObject file = it.next();
            try {
                if (multipleSources) continue;
                this.possiblyIncremental = LanguageRegistry.getInstance().isIncremental(file.getMIMEType());
                file.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.fileChangeListener, (Object)file));
                this.assignDocumentListener(file);
                this.dataObjectListener = DataLoadersBridge.getDefault().getDataObjectListener(file, (FileChangeListener)new FileChangeAdapter(){

                    public void fileChanged(FileEvent fe) {
                        try {
                            Source.this.assignDocumentListener(fe.getFile());
                            Source.this.resetState(true, true);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(Source.class.getName()).log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                });
            }
            catch (DataObjectNotFoundException donf) {
                if (multipleSources) {
                    Logger.getLogger("global").warning("Ignoring non existent file: " + FileUtil.getFileDisplayName((FileObject)file));
                    it.remove();
                    continue;
                }
                throw donf;
            }
        }
        this.classpathInfo = cpInfo;
        this.rootFo = files.size() == 1 ? this.classpathInfo.getClassPath(ClasspathInfo.PathKind.SOURCE).findOwnerRoot(files.iterator().next()) : null;
        this.classpathInfo.addChangeListener(WeakListeners.change((ChangeListener)this.listener, (Object)this.classpathInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runUserActionTask(CancellableTask<CompilationController> task, boolean shared) throws IOException {
        block49: {
            Request request;
            if (task == null) {
                throw new IllegalArgumentException("Task cannot be null");
            }
            boolean assertionsEnabled = false;
            if (!$assertionsDisabled) {
                assertionsEnabled = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (assertionsEnabled && !javacLock.isHeldByCurrentThread() && Source.holdsDocumentWriteLock(this.files)) {
                String msg = "Source.runCompileControlTask called under Document write lock.";
                Logger.getLogger(Source.class.getName()).log(Level.INFO, msg, new IllegalStateException(msg));
            }
            if (this.files.size() <= 1) {
                request = currentRequest.getTaskToCancel();
                try {
                    if (request != null) {
                        request.task.cancel();
                    }
                    javacLock.lock();
                    try {
                        CompilationInfo currentInfo = null;
                        Source source = this;
                        synchronized (source) {
                            if (this.currentInfo != null && (this.flags & 1) == 0) {
                                currentInfo = this.currentInfo;
                            }
                            if (!shared) {
                                this.flags |= 1;
                            }
                        }
                        if (currentInfo == null) {
                            currentInfo = Source.createCurrentInfo(this, this.files.isEmpty() ? null : this.files.iterator().next(), this.filterListener, null);
                            if (shared) {
                                source = this;
                                synchronized (source) {
                                    if (this.currentInfo == null || (this.flags & 1) != 0) {
                                        this.currentInfo = currentInfo;
                                        this.flags &= 0xFFFFFFFE;
                                    } else {
                                        currentInfo = this.currentInfo;
                                    }
                                }
                            }
                        }
                        assert (currentInfo != null);
                        if (shared) {
                            if (!this.infoStack.isEmpty()) {
                                currentInfo = this.infoStack.peek();
                            }
                        } else {
                            this.infoStack.push(currentInfo);
                        }
                        try {
                            task.run((Object)new CompilationController(currentInfo));
                            break block49;
                        }
                        finally {
                            if (!shared) {
                                this.infoStack.pop();
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        IOException ioe = new IOException();
                        ioe.initCause(e);
                        throw ioe;
                    }
                    finally {
                        javacLock.unlock();
                    }
                }
                finally {
                    currentRequest.cancelCompleted(request);
                }
            }
            request = currentRequest.getTaskToCancel();
            try {
                if (request != null) {
                    request.task.cancel();
                }
                javacLock.lock();
                try {
                    ParserTaskImpl jt = null;
                    FileObject activeFile = null;
                    Iterator<FileObject> files = this.files.iterator();
                    while (files.hasNext() || activeFile != null) {
                        boolean restarted;
                        if (activeFile == null) {
                            activeFile = files.next();
                            restarted = false;
                        } else {
                            restarted = true;
                        }
                        CompilationInfo ci = Source.createCurrentInfo(this, activeFile, this.filterListener, jt);
                        task.run((Object)new CompilationController(ci));
                        if (!ci.needsRestart) {
                            jt = ci.getParserTask();
                            activeFile = null;
                            continue;
                        }
                        jt = null;
                        ci = null;
                        System.gc();
                        if (!restarted) continue;
                        throw new InsufficientMemoryException(activeFile);
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    IOException ioe = new IOException();
                    ioe.initCause(e);
                    throw ioe;
                }
                finally {
                    javacLock.unlock();
                }
            }
            finally {
                currentRequest.cancelCompleted(request);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public ModificationResult runModificationTask(CancellableTask<WorkingCopy> task) throws IOException {
        ModificationResult result;
        block40: {
            Request request;
            if (task == null) {
                throw new IllegalArgumentException("Task cannot be null");
            }
            assert (javacLock.isHeldByCurrentThread() || !Source.holdsDocumentWriteLock(this.files)) : "Source.runCompileControlTask called under Document write lock.";
            result = new ModificationResult(this);
            if (this.files.size() <= 1) {
                request = currentRequest.getTaskToCancel();
                try {
                    if (request != null) {
                        request.task.cancel();
                    }
                    javacLock.lock();
                    try {
                        CompilationInfo currentInfo = null;
                        Source source = this;
                        // MONITORENTER : source
                        if (this.currentInfo != null && (this.flags & 1) == 0) {
                            currentInfo = this.currentInfo;
                        }
                        // MONITOREXIT : source
                        if (currentInfo == null) {
                            currentInfo = Source.createCurrentInfo(this, this.files.isEmpty() ? null : this.files.iterator().next(), this.filterListener, null);
                            source = this;
                            // MONITORENTER : source
                            if (this.currentInfo == null || (this.flags & 1) != 0) {
                                this.currentInfo = currentInfo;
                                this.flags &= 0xFFFFFFFE;
                            } else {
                                currentInfo = this.currentInfo;
                            }
                            // MONITOREXIT : source
                        }
                        assert (currentInfo != null);
                        WorkingCopy copy = new WorkingCopy(currentInfo);
                        task.run((Object)copy);
                        List<ModificationResult.Difference> diffs = copy.getChanges();
                        if (diffs != null && diffs.size() > 0) {
                            result.diffs.put(currentInfo.getFileObject(), diffs);
                        }
                        break block40;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        IOException ioe = new IOException();
                        ioe.initCause(e);
                        throw ioe;
                    }
                    finally {
                        javacLock.unlock();
                    }
                }
                finally {
                    currentRequest.cancelCompleted(request);
                }
            }
            request = currentRequest.getTaskToCancel();
            try {
                if (request != null) {
                    request.task.cancel();
                }
                javacLock.lock();
                try {
                    ParserTaskImpl jt = null;
                    FileObject activeFile = null;
                    Iterator<FileObject> files = this.files.iterator();
                    while (files.hasNext() || activeFile != null) {
                        boolean restarted;
                        if (activeFile == null) {
                            activeFile = files.next();
                            restarted = false;
                        } else {
                            restarted = true;
                        }
                        CompilationInfo ci = Source.createCurrentInfo(this, activeFile, this.filterListener, jt);
                        WorkingCopy copy = new WorkingCopy(ci);
                        task.run((Object)copy);
                        if (!ci.needsRestart) {
                            jt = ci.getParserTask();
                            List<ModificationResult.Difference> diffs = copy.getChanges();
                            if (diffs != null && diffs.size() > 0) {
                                result.diffs.put(ci.getFileObject(), diffs);
                            }
                            activeFile = null;
                            continue;
                        }
                        jt = null;
                        ci = null;
                        System.gc();
                        if (!restarted) continue;
                        throw new InsufficientMemoryException(activeFile);
                    }
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    IOException ioe = new IOException();
                    ioe.initCause(e);
                    throw ioe;
                }
                finally {
                    javacLock.unlock();
                }
            }
            finally {
                currentRequest.cancelCompleted(request);
            }
        }
        Source source = this;
        // MONITORENTER : source
        this.flags |= 1;
        // MONITOREXIT : source
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPhaseCompletionTask(CancellableTask<CompilationInfo> task, Phase phase, Priority priority) throws IOException {
        CompilationInfo currentInfo;
        if (task == null) {
            throw new IllegalArgumentException("Task cannot be null");
        }
        if (phase == null || phase == Phase.MODIFIED) {
            throw new IllegalArgumentException(String.format("The %s is not a legal value of phase", new Object[]{phase}));
        }
        if (priority == null) {
            throw new IllegalArgumentException("The priority cannot be null");
        }
        Source source = this;
        synchronized (source) {
            currentInfo = this.currentInfo;
        }
        if (currentInfo == null) {
            currentInfo = Source.createCurrentInfo(this, this.files.isEmpty() ? null : this.files.iterator().next(), this.filterListener, null);
        }
        source = this;
        synchronized (source) {
            if (this.currentInfo == null) {
                this.currentInfo = currentInfo;
            }
        }
        Source.handleAddRequest(new Request(task, this, phase, priority, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePhaseCompletionTask(CancellableTask<CompilationInfo> task) {
        Class<Source> clazz = Source.class;
        synchronized (Source.class) {
            toRemove.add(task);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rescheduleTask(CancellableTask<CompilationInfo> task) {
        Class<Source> clazz = Source.class;
        synchronized (Source.class) {
            block8: {
                Request request = currentRequest.getTaskToCancel(task);
                if (request == null) {
                    Iterator<Collection<Request>> it = finishedRequests.values().iterator();
                    while (it.hasNext()) {
                        Collection<Request> cr = it.next();
                        Iterator<Request> it2 = cr.iterator();
                        while (it2.hasNext()) {
                            Request fr = it2.next();
                            if (task != fr.task) continue;
                            it2.remove();
                            requests.add(fr);
                            if (cr.size() == 0) {
                                it.remove();
                            }
                            break block8;
                        }
                    }
                } else {
                    currentRequest.cancelCompleted(request);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void revalidate() {
        this.resetState(true, false);
    }

    public ClasspathInfo getClasspathInfo() {
        return this.classpathInfo;
    }

    public Collection<FileObject> getFileObjects() {
        return this.files;
    }

    ParserTaskImpl createParserTask(CompilationInfo compilationInfo) {
        Language language = compilationInfo.getLanguage();
        assert (language != null);
        ParserTaskImpl javacTask = Source.createParserTask(language, compilationInfo, this.getClasspathInfo(), false);
        return javacTask;
    }

    private static ParserTaskImpl createParserTask(Language language, CompilationInfo currentInfo, ClasspathInfo cpInfo, boolean backgroundCompilation) {
        ParserTaskImpl jti = new ParserTaskImpl(language);
        return jti;
    }

    /*
     * WARNING - void declaration
     */
    static Phase moveToPhase(Phase phase, CompilationInfo currentInfo, boolean cancellable) throws IOException {
        Phase currentPhase = currentInfo.getPhase();
        boolean isMultiFiles = currentInfo.getSource().files.size() > 1;
        LowMemoryNotifier lm = null;
        LMListener lmListener = null;
        if (isMultiFiles) {
            lm = LowMemoryNotifier.getDefault();
            assert (lm != null);
            lmListener = new LMListener();
            lm.addLowMemoryListener(lmListener);
        }
        try {
            if (lmListener != null && lmListener.lowMemory.getAndSet(false)) {
                currentInfo.needsRestart = true;
                Phase phase2 = currentPhase;
                return phase2;
            }
            if (currentPhase.compareTo(Phase.PARSED) < 0 && phase.compareTo(Phase.PARSED) >= 0) {
                if (cancellable && currentRequest.isCanceled()) {
                    Phase phase3 = Phase.MODIFIED;
                    return phase3;
                }
                long start2 = System.currentTimeMillis();
                DefaultParserFile file = new DefaultParserFile(currentInfo.getFileObject(), null, false);
                List<DefaultParserFile> sourceFiles = Collections.singletonList(file);
                FileObject bufferFo = currentInfo.getFileObject();
                final ParserResult[] resultHolder = new ParserResult[1];
                ParseListener listener = new ParseListener(){
                    final List<org.netbeans.modules.gsf.api.Error> errors = new ArrayList<org.netbeans.modules.gsf.api.Error>();

                    public void started(ParseEvent e) {
                        this.errors.clear();
                    }

                    public void error(org.netbeans.modules.gsf.api.Error error) {
                        this.errors.add(error);
                    }

                    public void exception(Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }

                    public void finished(ParseEvent e) {
                        if (e.getKind() == ParseEvent.Kind.PARSE) {
                            ParserResult result = e.getResult();
                            for (org.netbeans.modules.gsf.api.Error error : this.errors) {
                                result.addError(error);
                            }
                            resultHolder[0] = result;
                        }
                    }
                };
                LanguageRegistry registry = LanguageRegistry.getInstance();
                String mimeType = currentInfo.getFileObject().getMIMEType();
                List<Language> languages = registry.getApplicableLanguages(mimeType);
                Source source = currentInfo.getSource();
                currentInfo.setHistory(source.editHistory);
                for (Language language : languages) {
                    IncrementalParser incrementalParser;
                    EmbeddingModel model = registry.getEmbedding(language.getMimeType(), mimeType);
                    assert (language != null);
                    Parser parser = language.getParser();
                    IncrementalParser incrementalParser2 = incrementalParser = parser instanceof IncrementalParser ? (IncrementalParser)parser : null;
                    if (cancellable && currentRequest.isCanceled()) {
                        Phase phase4 = Phase.MODIFIED;
                        return phase4;
                    }
                    long vsTime = -1L;
                    long parseTime = -1L;
                    if (parser != null) {
                        if (model != null) {
                            Document document = currentInfo.getDocument();
                            if (document == null) {
                                GsfUtilities.getDocument((FileObject)currentInfo.getFileObject(), (boolean)true);
                                document = currentInfo.getDocument();
                            } else if ("text/plain".equals(document.getProperty("mimeType"))) {
                                Phase phase5 = Phase.MODIFIED;
                                return phase5;
                            }
                            if (document == null) continue;
                            if (cancellable && currentRequest.isCanceled()) {
                                Phase phase6 = Phase.MODIFIED;
                                return phase6;
                            }
                            long vsStart = System.currentTimeMillis();
                            Collection<? extends TranslatedSource> translations = null;
                            boolean incremental = false;
                            if (model instanceof IncrementalEmbeddingModel && (source.files == null || source.files.size() <= 1)) {
                                incremental = true;
                                IncrementalEmbeddingModel incrementalModel = (IncrementalEmbeddingModel)model;
                                translations = source.recentEmbeddingTranslations.get(model);
                                if (translations != null) {
                                    void var33_49;
                                    EditHistory editHistory = source.editHistory;
                                    if (translations.size() > 0) {
                                        EditHistory editHistory2 = EditHistory.getCombinedEdits((int)translations.iterator().next().getEditVersion(), (EditHistory)source.editHistory);
                                    }
                                    if (var33_49 != null && var33_49.isValid()) {
                                        IncrementalEmbeddingModel.UpdateState updated = incrementalModel.update((EditHistory)var33_49, translations);
                                        if (updated == IncrementalEmbeddingModel.UpdateState.COMPLETED) {
                                            ParserResult result = source.recentParseResult.get(language.getMimeType());
                                            for (TranslatedSource translatedSource : translations) {
                                                translatedSource.setEditVersion(source.editHistory.getVersion());
                                            }
                                            if (result != null) {
                                                currentInfo.addEmbeddingResult(language.getMimeType(), result);
                                                result.setUpdateState(ParserResult.UpdateState.NO_CHANGE);
                                                continue;
                                            }
                                        } else if (updated == IncrementalEmbeddingModel.UpdateState.FAILED) {
                                            translations = null;
                                        } else {
                                            assert (updated == IncrementalEmbeddingModel.UpdateState.UPDATED);
                                            for (TranslatedSource translatedSource : translations) {
                                                translatedSource.setEditVersion(source.editHistory.getVersion());
                                            }
                                        }
                                    } else {
                                        translations = null;
                                    }
                                }
                            }
                            if (translations == null) {
                                translations = model.translate(document);
                                if (incremental) {
                                    source.recentEmbeddingTranslations.put(model, translations);
                                    for (TranslatedSource translatedSource : translations) {
                                        translatedSource.setEditVersion(source.editHistory.getVersion());
                                    }
                                }
                            }
                            if (cancellable && currentRequest.isCanceled()) {
                                Phase i$ = Phase.MODIFIED;
                                return i$;
                            }
                            vsTime = System.currentTimeMillis() - vsStart;
                            parseTime = 0L;
                            for (TranslatedSource translatedSource : translations) {
                                ParserResult.UpdateState state;
                                ParserResult ir;
                                EditHistory history2;
                                ParserResult previousResult;
                                vsStart = System.currentTimeMillis();
                                String buffer = translatedSource.getSource();
                                vsTime += System.currentTimeMillis() - vsStart;
                                long parseStart = System.currentTimeMillis();
                                StringSourceFileReader stringSourceFileReader = new StringSourceFileReader(buffer, bufferFo);
                                ParserResult result = null;
                                if (incrementalParser != null && (source.files == null || source.files.size() <= 1) && (previousResult = source.recentParseResult.get(language.getMimeType())) != null && (history2 = EditHistory.getCombinedEdits((int)previousResult.getEditVersion(), (EditHistory)source.editHistory)) != null && history2.isValid() && (ir = incrementalParser.parse((ParserFile)file, (SourceFileReader)stringSourceFileReader, translatedSource, history2, previousResult)) != null && (state = ir.getUpdateState()) != ParserResult.UpdateState.FAILED) {
                                    result = ir;
                                }
                                if (result == null) {
                                    Parser.Job job = new Parser.Job(sourceFiles, listener, (SourceFileReader)stringSourceFileReader, translatedSource);
                                    parser.parseFiles(job);
                                    result = resultHolder[0];
                                }
                                if (incrementalParser != null || incremental && translations != null) {
                                    source.recentParseResult.put(language.getMimeType(), result);
                                    result.setEditVersion(source.editHistory.getVersion());
                                }
                                parseTime += System.currentTimeMillis() - parseStart;
                                if (cancellable && currentRequest.isCanceled()) {
                                    Phase phase2 = Phase.MODIFIED;
                                    return phase2;
                                }
                                result.setTranslatedSource(translatedSource);
                                assert (result != null);
                                currentInfo.addEmbeddingResult(language.getMimeType(), result);
                            }
                        } else {
                            ParserResult.UpdateState state;
                            EditHistory editHistory;
                            ParserResult previousResult;
                            long parseStart = System.currentTimeMillis();
                            String buffer = currentInfo.getText();
                            StringSourceFileReader reader = new StringSourceFileReader(buffer, bufferFo);
                            ParserResult result = null;
                            if (incrementalParser != null && (source.files == null || source.files.size() <= 1) && (previousResult = source.recentParseResult.get(language.getMimeType())) != null && (editHistory = EditHistory.getCombinedEdits((int)previousResult.getEditVersion(), (EditHistory)source.editHistory)) != null && editHistory.isValid() && (result = incrementalParser.parse((ParserFile)file, (SourceFileReader)reader, null, editHistory, previousResult)) != null && (state = result.getUpdateState()) == ParserResult.UpdateState.FAILED) {
                                result = null;
                            }
                            if (result == null) {
                                Parser.Job job = new Parser.Job(sourceFiles, listener, (SourceFileReader)reader, null);
                                parser.parseFiles(job);
                                result = resultHolder[0];
                            }
                            if (incrementalParser != null) {
                                source.recentParseResult.put(language.getMimeType(), result);
                                result.setEditVersion(source.editHistory.getVersion());
                            }
                            parseTime = System.currentTimeMillis() - parseStart;
                            if (cancellable && currentRequest.isCanceled()) {
                                Phase phase8 = Phase.MODIFIED;
                                return phase8;
                            }
                            assert (result != null);
                            currentInfo.addEmbeddingResult(language.getMimeType(), result);
                        }
                    }
                    if (vsTime > 0L) {
                        Logger.getLogger("TIMER").log(Level.FINE, "Virtual Source (" + language.getMimeType() + ")", new Object[]{currentInfo.getFileObject(), vsTime});
                    }
                    if (parseTime <= 0L) continue;
                    Logger.getLogger("TIMER").log(Level.FINE, "Parsing (" + language.getMimeType() + ")", new Object[]{currentInfo.getFileObject(), parseTime});
                }
                currentPhase = Phase.PARSED;
                if (source.possiblyIncremental) {
                    EditHistory oldHistory = source.editHistory;
                    source.editHistory = new EditHistory();
                    oldHistory.add(source.editHistory);
                }
            }
            if (lmListener != null && lmListener.lowMemory.getAndSet(false)) {
                currentInfo.needsRestart = true;
                Phase start2 = currentPhase;
                return start2;
            }
            if (currentPhase == Phase.PARSED && phase.compareTo(Phase.ELEMENTS_RESOLVED) >= 0) {
                if (cancellable && currentRequest.isCanceled()) {
                    Phase start2 = Phase.MODIFIED;
                    return start2;
                }
                long start3 = System.currentTimeMillis();
                currentPhase = Phase.ELEMENTS_RESOLVED;
                long end = System.currentTimeMillis();
                Source.logTime(currentInfo.getFileObject(), currentPhase, end - start3);
            }
            if (lmListener != null && lmListener.lowMemory.getAndSet(false)) {
                currentInfo.needsRestart = true;
                Phase start3 = currentPhase;
                return start3;
            }
            if (currentPhase == Phase.ELEMENTS_RESOLVED && phase.compareTo(Phase.RESOLVED) >= 0) {
                if (cancellable && currentRequest.isCanceled()) {
                    Phase start3 = Phase.MODIFIED;
                    return start3;
                }
                long start4 = System.currentTimeMillis();
                currentPhase = Phase.RESOLVED;
                long end = System.currentTimeMillis();
                Source.logTime(currentInfo.getFileObject(), currentPhase, end - start4);
            }
            if (lmListener != null && lmListener.lowMemory.getAndSet(false)) {
                currentInfo.needsRestart = true;
                Phase start4 = currentPhase;
                return start4;
            }
            if (currentPhase == Phase.RESOLVED && phase.compareTo(Phase.UP_TO_DATE) >= 0) {
                currentPhase = Phase.UP_TO_DATE;
            }
        }
        catch (RuntimeException ex) {
            Source.dumpSource(currentInfo, ex);
            throw ex;
        }
        catch (Error ex) {
            Source.dumpSource(currentInfo, ex);
            throw ex;
        }
        finally {
            if (isMultiFiles) {
                assert (lm != null);
                assert (lmListener != null);
                lm.removeLowMemoryListener(lmListener);
            }
            currentInfo.setPhase(currentPhase);
        }
        return currentPhase;
    }

    static void logTime(FileObject source, Phase phase, long time) {
        assert (source != null && phase != null);
        String key = phase2Key.get((Object)phase);
        String message = phase2Message.get((Object)phase);
        assert (key != null && message != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetState(boolean invalidate, boolean updateIndex) {
        boolean invalid;
        Source source = this;
        synchronized (source) {
            invalid = (this.flags & 1) != 0;
            this.flags |= 2;
            if (invalidate) {
                this.flags |= 5;
            }
            if (updateIndex) {
                this.flags |= 8;
            }
        }
        if (updateIndex && !invalid) {
            this.updateIndex();
        }
        Request r = currentRequest.getTaskToCancel(this);
        try {
            if (r != null) {
                r.task.cancel();
            }
        }
        finally {
            currentRequest.cancelCompleted(r);
        }
        this.resetTask.schedule(REPARSE_DELAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStateImpl() {
        Class<Source> clazz = Source.class;
        synchronized (Source.class) {
            Collection<Request> cr;
            boolean updateIndex;
            boolean reschedule;
            Source source = this;
            synchronized (source) {
                reschedule = (this.flags & 4) != 0;
                updateIndex = (this.flags & 8) != 0;
                this.flags &= 0xFFFFFFF1;
            }
            if (updateIndex) {
                this.updateIndex();
            }
            if (reschedule && (cr = finishedRequests.remove(this)) != null && cr.size() > 0) {
                requests.addAll(cr);
            }
            if ((cr = waitingRequests.remove(this)) != null && cr.size() > 0) {
                requests.addAll(cr);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void updateIndex() {
        if (this.rootFo != null) {
            try {
                for (Language language : LanguageRegistry.getInstance()) {
                    ClassIndexImpl ciImpl;
                    if (language.getIndexer() == null || (ciImpl = ClassIndexManager.get(language).getUsagesQuery(this.rootFo.getURL())) == null) continue;
                    ciImpl.setDirty(this);
                }
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
    }

    public void testUpdateIndex() {
        this.updateIndex();
    }

    private void assignDocumentListener(FileObject fo) throws IOException {
        EditorCookie.Observable ec = (EditorCookie.Observable)DataLoadersBridge.getDefault().getCookie(fo, EditorCookie.Observable.class);
        if (ec != null) {
            this.listener = new DocListener(ec);
        } else {
            Logger.getLogger("global").log(Level.WARNING, String.format("File: %s has no EditorCookie.Observable", FileUtil.getFileDisplayName((FileObject)fo)));
        }
    }

    private static CompilationInfo createCurrentInfo(Source js, FileObject fo, Object filterListener, ParserTaskImpl javac) throws IOException {
        CompilationInfo info = new CompilationInfo(js, fo, javac);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleAddRequest(Request nr) {
        assert (nr != null);
        requests.add(nr);
        Request request = currentRequest.getTaskToCancel(nr.priority);
        try {
            if (request != null) {
                request.task.cancel();
            }
        }
        finally {
            currentRequest.cancelCompleted(request);
        }
    }

    private static boolean holdsDocumentWriteLock(Iterable<FileObject> files) {
        Class<AbstractDocument> docClass = AbstractDocument.class;
        try {
            Method method = docClass.getDeclaredMethod("getCurrentWriter", new Class[0]);
            method.setAccessible(true);
            Thread currentThread = Thread.currentThread();
            for (FileObject fo : files) {
                try {
                    Object result;
                    StyledDocument doc = DataLoadersBridge.getDefault().getDocument(fo);
                    if (!(doc instanceof AbstractDocument) || (result = method.invoke((Object)doc, new Object[0])) != currentThread) continue;
                    return true;
                }
                catch (Exception e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        }
        catch (NoSuchMethodException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpSource(CompilationInfo info, Throwable exc) {
        String origName;
        String src;
        String dumpDir;
        block16: {
            dumpDir = System.getProperty("netbeans.user") + "/var/log/";
            src = null;
            try {
                src = info.getText();
            }
            catch (IllegalStateException ise) {
                Document doc = info.getDocument();
                if (doc == null) break block16;
                try {
                    src = doc.getText(0, doc.getLength());
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        if (src == null) {
            src = "";
        }
        FileObject file = info.getFileObject();
        String fileName = origName = "unknown";
        if (file != null) {
            fileName = FileUtil.getFileDisplayName((FileObject)file);
            origName = file.getNameExt();
        }
        File f = new File(dumpDir + origName + ".dump");
        boolean dumpSucceeded = false;
        for (int i = 1; i < 255 && f.exists(); ++i) {
            f = new File(dumpDir + origName + '_' + i + ".dump");
        }
        if (!f.exists()) {
            try {
                FileOutputStream os = new FileOutputStream(f);
                PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)os, "UTF-8"));
                try {
                    writer.println(src);
                    writer.println("----- Classpath: ---------------------------------------------");
                    ClassPath bootPath = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.BOOT);
                    ClassPath classPath = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
                    ClassPath sourcePath = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
                    writer.println("bootPath: " + (bootPath != null ? bootPath.toString() : "null"));
                    writer.println("classPath: " + (classPath != null ? classPath.toString() : "null"));
                    writer.println("sourcePath: " + (sourcePath != null ? sourcePath.toString() : "null"));
                    writer.println("----- Original exception ---------------------------------------------");
                    exc.printStackTrace(writer);
                }
                finally {
                    writer.close();
                    dumpSucceeded = true;
                }
            }
            catch (IOException ioe) {
                Logger.getLogger("global").log(Level.INFO, "Error when writing parser dump file!", ioe);
            }
        }
        String language = "ruby";
        if (info.getLanguage() != null) {
            language = info.getLanguage().getDisplayName();
        }
        if (dumpSucceeded) {
            Throwable t = Exceptions.attachMessage((Throwable)exc, (String)("An error occurred during parsing of '" + fileName + "'. Please report a bug against " + language + " and attach dump file '" + f.getAbsolutePath() + "'."));
            Exceptions.printStackTrace((Throwable)t);
        } else {
            Logger.getLogger("global").log(Level.WARNING, "Dump could not be written. Either dump file could not be created or all dump files were already used. Please check that you have write permission to '" + dumpDir + "' and " + "clean all *.dump files in that directory.");
        }
    }

    static {
        SourceAccessor.setINSTANCE(new JavaSourceAccessorImpl());
        phase2Key.put(Phase.PARSED, "parsed");
        phase2Message.put(Phase.PARSED, "Parsed");
        phase2Key.put(Phase.ELEMENTS_RESOLVED, "sig-attributed");
        phase2Message.put(Phase.ELEMENTS_RESOLVED, "Signatures Attributed");
        phase2Key.put(Phase.RESOLVED, "attributed");
        phase2Message.put(Phase.RESOLVED, "Attributed");
        requests = new PriorityBlockingQueue<Request>(10, new RequestComparator());
        finishedRequests = new WeakHashMap<Source, Collection<Request>>();
        waitingRequests = new WeakHashMap<Source, Collection<Request>>();
        toRemove = new LinkedList<CancellableTask>();
        factory = new SingleThreadFactory();
        currentRequest = new CurrentRequestReference();
        editorRegistryListener = new EditorRegistryListener();
        javacLock = new ReentrantLock(true);
        Executors.newSingleThreadExecutor(factory).submit(new CompilationJob());
        file2JavaSource = new WeakHashMap<FileObject, Reference<Source>>();
    }

    private static class LMListener
    implements LowMemoryListener {
        private AtomicBoolean lowMemory = new AtomicBoolean(false);

        private LMListener() {
        }

        @Override
        public void lowMemory(LowMemoryEvent event) {
            this.lowMemory.set(true);
        }
    }

    private static class CurrentRequestReference {
        private Request reference;
        private Request canceledReference;
        private long cancelTime;
        private boolean canceled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean setCurrentTask(Request reference) throws InterruptedException {
            boolean result = false;
            CurrentRequestReference currentRequestReference = this;
            synchronized (currentRequestReference) {
                while (this.canceledReference != null) {
                    this.wait();
                }
                result = this.canceled;
                this.canceled = false;
                this.cancelTime = 0L;
                this.reference = reference;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Request getTaskToCancel(Priority priority) {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    if (this.reference != null && priority.compareTo(this.reference.priority) < 0) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request = this.reference;
                        this.reference = null;
                        this.canceled = true;
                        if (reportSlowTasks) {
                            this.cancelTime = System.currentTimeMillis();
                        }
                    }
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Request getTaskToCancel(Source js) {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    if (this.reference != null && js.equals(this.reference.javaSource)) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request = this.reference;
                        this.reference = null;
                        this.canceled = true;
                        if (reportSlowTasks) {
                            this.cancelTime = System.currentTimeMillis();
                        }
                    }
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Request getTaskToCancel(CancellableTask task) {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    if (this.reference != null && task == this.reference.task) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request = this.reference;
                        this.reference = null;
                        this.canceled = true;
                    }
                }
            }
            return request;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Request getTaskToCancel() {
            Request request = null;
            if (!factory.isDispatchThread(Thread.currentThread())) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    request = this.reference;
                    if (request != null) {
                        assert (this.canceledReference == null);
                        this.canceledReference = request;
                        this.reference = null;
                        this.canceled = true;
                        if (reportSlowTasks) {
                            this.cancelTime = System.currentTimeMillis();
                        }
                    }
                }
            }
            return request;
        }

        public synchronized boolean isCanceled() {
            return this.canceled;
        }

        public synchronized long getCancelTime() {
            return this.cancelTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelCompleted(Request request) {
            if (request != null) {
                CurrentRequestReference currentRequestReference = this;
                synchronized (currentRequestReference) {
                    assert (request == this.canceledReference);
                    this.canceledReference = null;
                    this.notify();
                }
            }
        }
    }

    private static class JavaSourceAccessorImpl
    extends SourceAccessor {
        private StackTraceElement[] javacLockedStackTrace;

        private JavaSourceAccessorImpl() {
        }

        @Override
        protected void runSpecialTaskImpl(CancellableTask<CompilationInfo> task, Priority priority) {
            Source.handleAddRequest(new Request(task, null, null, priority, false));
        }

        @Override
        public ParserTaskImpl createParserTask(Language language, ClasspathInfo cpInfo) {
            boolean backgroundCompilation = true;
            return Source.createParserTask(language, null, cpInfo, backgroundCompilation);
        }

        @Override
        public ParserTaskImpl getParserTask(CompilationInfo compilationInfo) {
            assert (compilationInfo != null);
            return compilationInfo.getParserTask();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompilationInfo getCurrentCompilationInfo(Source js, Phase phase) throws IOException {
            assert (js != null);
            assert (this.isDispatchThread());
            CompilationInfo info = null;
            Source source = js;
            synchronized (source) {
                if ((js.flags & 1) == 0) {
                    info = js.currentInfo;
                }
            }
            if (info == null) {
                return null;
            }
            Phase currentPhase = Source.moveToPhase(phase, info, true);
            return currentPhase.compareTo(phase) < 0 ? null : info;
        }

        @Override
        public void revalidate(Source js) {
            js.revalidate();
        }

        @Override
        public boolean isDispatchThread() {
            return factory.isDispatchThread(Thread.currentThread());
        }

        @Override
        public void lockParser() {
            javacLock.lock();
            try {
                this.javacLockedStackTrace = Thread.currentThread().getStackTrace();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlockParser() {
            try {
                this.javacLockedStackTrace = null;
            }
            finally {
                javacLock.unlock();
            }
        }

        @Override
        public boolean isParserLocked() {
            return javacLock.isLocked();
        }
    }

    private static class SingleThreadFactory
    implements ThreadFactory {
        private Thread t;

        private SingleThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            assert (this.t == null);
            this.t = new Thread(r, "GSF Source Worker Thread");
            return this.t;
        }

        public boolean isDispatchThread(Thread t) {
            assert (t != null);
            return this.t == t;
        }
    }

    private class FileChangeListenerImpl
    extends FileChangeAdapter {
        private FileChangeListenerImpl() {
        }

        public void fileChanged(FileEvent fe) {
            Source.this.resetState(true, false);
        }

        public void fileRenamed(FileRenameEvent fe) {
            Source.this.resetState(true, false);
        }
    }

    private static class EditorRegistryListener
    implements CaretListener {
        private Reference<JTextComponent> lastEditorRef;

        public EditorRegistryListener() {
            EditorRegistry.addPropertyChangeListener((PropertyChangeListener)new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    EditorRegistryListener.this.editorRegistryChanged();
                }
            });
            this.editorRegistryChanged();
        }

        public void editorRegistryChanged() {
            JTextComponent lastEditor;
            JTextComponent editor = EditorRegistry.lastFocusedComponent();
            JTextComponent jTextComponent = lastEditor = this.lastEditorRef == null ? null : this.lastEditorRef.get();
            if (lastEditor != editor) {
                if (lastEditor != null) {
                    lastEditor.removeCaretListener(this);
                    Document doc = lastEditor.getDocument();
                    Source js = null;
                    if (doc != null) {
                        js = Source.forDocument(doc);
                    }
                }
                this.lastEditorRef = new WeakReference<JTextComponent>(editor);
                if (editor != null) {
                    editor.addCaretListener(this);
                }
            }
        }

        @Override
        public void caretUpdate(CaretEvent event) {
            Source js;
            Document doc;
            JTextComponent lastEditor;
            JTextComponent jTextComponent = lastEditor = this.lastEditorRef == null ? null : this.lastEditorRef.get();
            if (lastEditor != null && (doc = lastEditor.getDocument()) != null && (js = Source.forDocument(doc)) != null) {
                js.resetState(false, false);
            }
        }
    }

    private class DocListener
    implements DocumentListener,
    PropertyChangeListener,
    ChangeListener,
    TokenHierarchyListener {
        private EditorCookie.Observable ec;
        private DocumentListener docListener;
        private TokenHierarchyListener lexListener;

        public DocListener(EditorCookie.Observable ec) {
            assert (ec != null);
            this.ec = ec;
            this.ec.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.ec));
            StyledDocument doc = ec.getDocument();
            if (doc != null) {
                this.docListener = (DocumentListener)WeakListeners.create(DocumentListener.class, (EventListener)this, (Object)doc);
                doc.addDocumentListener(this.docListener);
                if (Source.this.possiblyIncremental) {
                    TokenHierarchy th = TokenHierarchy.get((Document)doc);
                    this.lexListener = (TokenHierarchyListener)WeakListeners.create(TokenHierarchyListener.class, (EventListener)this, (Object)th);
                    th.addTokenHierarchyListener(this.lexListener);
                }
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            Source.this.resetState(true, true);
            if (Source.this.possiblyIncremental) {
                Source.this.editHistory.insertUpdate(e);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            Source.this.resetState(true, true);
            if (Source.this.possiblyIncremental) {
                Source.this.editHistory.removeUpdate(e);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("document".equals(evt.getPropertyName())) {
                StyledDocument doc;
                Object old = evt.getOldValue();
                if (old instanceof Document) {
                    if (this.lexListener != null) {
                        TokenHierarchy th = TokenHierarchy.get((Document)((Document)old));
                        th.removeTokenHierarchyListener(this.lexListener);
                        this.lexListener = null;
                    }
                    if (this.docListener != null) {
                        ((Document)old).removeDocumentListener(this.docListener);
                        this.docListener = null;
                        Source.this.recentParseResult.clear();
                        Source.this.recentEmbeddingTranslations.clear();
                    }
                }
                if ((doc = this.ec.getDocument()) != null) {
                    this.docListener = (DocumentListener)WeakListeners.create(DocumentListener.class, (EventListener)this, (Object)doc);
                    doc.addDocumentListener(this.docListener);
                    if (Source.this.possiblyIncremental) {
                        TokenHierarchy th = TokenHierarchy.get((Document)doc);
                        this.lexListener = (TokenHierarchyListener)WeakListeners.create(TokenHierarchyListener.class, (EventListener)this, (Object)th);
                        th.addTokenHierarchyListener(this.lexListener);
                    }
                    Source.this.resetState(true, false);
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Source.this.resetState(true, false);
        }

        public void tokenHierarchyChanged(TokenHierarchyEvent evt) {
            assert (Source.this.possiblyIncremental);
            Source.this.editHistory.tokenHierarchyChanged(evt);
            if (evt.type() == TokenHierarchyEventType.REBUILD) {
                Source.this.resetState(true, true);
            }
        }
    }

    private static class CompilationJob
    implements Runnable {
        private CompilationJob() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                while (true) {
                    try {}
                    catch (Throwable e) {
                        if (e instanceof InterruptedException) {
                            throw (InterruptedException)e;
                        }
                        if (e instanceof ThreadDeath) {
                            throw (ThreadDeath)e;
                        }
                        Exceptions.printStackTrace((Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                return;
            }
            while (true) {
                Collection<Request> rc;
                boolean changeExpected2;
                Source js;
                Request r;
                Object fr;
                block61: {
                    Class<Source> clazz = Source.class;
                    // MONITORENTER : org.netbeans.napi.gsfret.source.Source.class
                    if (!toRemove.isEmpty()) {
                        Iterator it = finishedRequests.values().iterator();
                        while (it.hasNext()) {
                            Collection cr = (Collection)it.next();
                            Iterator it2 = cr.iterator();
                            while (it2.hasNext()) {
                                fr = (Request)it2.next();
                                if (!toRemove.remove(((Request)fr).task)) continue;
                                it2.remove();
                            }
                            if (cr.size() != 0) continue;
                            it.remove();
                        }
                    }
                    // MONITOREXIT : clazz
                    r = (Request)requests.poll(2L, TimeUnit.SECONDS);
                    if (r == null) continue;
                    currentRequest.setCurrentTask(r);
                    js = r.javaSource;
                    if (js == null) {
                        assert (r.phase == null);
                        assert (!r.reschedule);
                        javacLock.lock();
                        try {
                            r.task.run(null);
                            continue;
                        }
                        catch (RuntimeException re) {
                            Exceptions.printStackTrace((Throwable)re);
                            continue;
                        }
                        finally {
                            javacLock.unlock();
                        }
                    }
                    assert (js.files.size() <= 1);
                    fr = Source.class;
                    // MONITORENTER : org.netbeans.napi.gsfret.source.Source.class
                    if (!toRemove.remove(r.task)) break block61;
                    // MONITOREXIT : fr
                    currentRequest.setCurrentTask(null);
                    continue;
                }
                Source source = js;
                // MONITORENTER : source
                boolean bl = changeExpected2 = (js.flags & 2) != 0;
                if (changeExpected2) {
                    rc = (LinkedList<Request>)waitingRequests.get(r.javaSource);
                    if (rc == null) {
                        rc = new LinkedList<Request>();
                        waitingRequests.put(r.javaSource, rc);
                    }
                    rc.add(r);
                    // MONITOREXIT : source
                    // MONITOREXIT : fr
                    currentRequest.setCurrentTask(null);
                    continue;
                }
                try {
                    boolean jsInvalid = (js.flags & 1) != 0;
                    CompilationInfo ci = js.currentInfo;
                    // MONITOREXIT : source
                    // MONITOREXIT : fr
                    try {
                        Object phase;
                        block62: {
                            if (jsInvalid) {
                                ci = Source.createCurrentInfo(js, js.files.isEmpty() ? null : (FileObject)js.files.iterator().next(), js.filterListener, null);
                                fr = js;
                                // MONITORENTER : fr
                                if ((js.flags & 1) != 0) {
                                    js.currentInfo = ci;
                                    js.flags &= -2;
                                } else {
                                    ci = js.currentInfo;
                                }
                                // MONITOREXIT : fr
                            }
                            assert (ci != null);
                            javacLock.lock();
                            try {
                                boolean shouldCall;
                                phase = Source.moveToPhase(r.phase, ci, true);
                                boolean bl2 = shouldCall = phase.compareTo(r.phase) >= 0;
                                if (!shouldCall) break block62;
                                Source changeExpected2 = js;
                                // MONITORENTER : changeExpected2
                                boolean bl3 = (js.flags & 1) == 0;
                                // MONITOREXIT : changeExpected2
                                if (!(shouldCall &= bl3)) break block62;
                                try {
                                    long startTime = System.currentTimeMillis();
                                    r.task.run((Object)ci);
                                    long endTime = System.currentTimeMillis();
                                    if (reportSlowTasks) {
                                        long cancelTime;
                                        if (endTime - startTime > 250L) {
                                            Logger.getLogger("global").log(Level.INFO, String.format("Source executed a slow task: %s in %d ms.", r.task.getClass().toString(), endTime - startTime));
                                        }
                                        if ((cancelTime = currentRequest.getCancelTime()) >= startTime && endTime - cancelTime > 50L) {
                                            Logger.getLogger("global").log(Level.INFO, String.format("Task: %s ignored cancel for %d ms.", r.task.getClass().toString(), endTime - cancelTime));
                                        }
                                    }
                                }
                                catch (RuntimeException re) {
                                    Exceptions.printStackTrace((Throwable)re);
                                }
                            }
                            finally {
                                javacLock.unlock();
                            }
                        }
                        if (!r.reschedule) continue;
                        phase = Source.class;
                        // MONITORENTER : org.netbeans.napi.gsfret.source.Source.class
                        boolean canceled = currentRequest.setCurrentTask(null);
                        Source source2 = js;
                        // MONITORENTER : source2
                        if ((js.flags & 1) != 0 || canceled) {
                            requests.add(r);
                        } else {
                            rc = (Collection)finishedRequests.get(r.javaSource);
                            if (rc == null) {
                                rc = new LinkedList();
                                finishedRequests.put(r.javaSource, rc);
                            }
                            rc.add(r);
                        }
                        // MONITOREXIT : source2
                        // MONITOREXIT : phase
                    }
                    catch (IOException invalidFile) {
                        // empty catch block
                    }
                    continue;
                }
                finally {
                    currentRequest.setCurrentTask(null);
                    continue;
                }
                break;
            }
        }
    }

    private static class RequestComparator
    implements Comparator<Request> {
        private RequestComparator() {
        }

        @Override
        public int compare(Request r1, Request r2) {
            assert (r1 != null && r2 != null);
            return r1.priority.compareTo(r2.priority);
        }
    }

    private static class Request {
        private final CancellableTask<? extends CompilationInfo> task;
        private final Source javaSource;
        private final Phase phase;
        private final Priority priority;
        private final boolean reschedule;

        public Request(CancellableTask<? extends CompilationInfo> task, Source javaSource, Phase phase, Priority priority, boolean reschedule) {
            assert (task != null);
            this.task = task;
            this.javaSource = javaSource;
            this.phase = phase;
            this.priority = priority;
            this.reschedule = reschedule;
        }

        public String toString() {
            if (this.reschedule) {
                return String.format("Periodic request for phase: %s with priority: %s to perform: %s", new Object[]{this.phase.name(), this.priority, this.task.toString()});
            }
            return String.format("One time request for phase: %s with priority: %d to perform: %s", new Object[]{this.phase != null ? this.phase.name() : "<null>", this.priority, this.task.toString()});
        }

        public int hashCode() {
            return this.priority.ordinal();
        }

        public boolean equals(Object other) {
            if (other instanceof Request) {
                Request otherRequest = (Request)other;
                return this.priority == otherRequest.priority && this.reschedule == otherRequest.reschedule && this.phase.equals((Object)otherRequest.phase) && this.task.equals(otherRequest.task);
            }
            return false;
        }
    }

    public static final class InsufficientMemoryException
    extends IOException {
        private FileObject fo;

        private InsufficientMemoryException(String message, FileObject fo) {
            super(message);
            this.fo = fo;
        }

        private InsufficientMemoryException(FileObject fo) {
            this(NbBundle.getMessage(Source.class, (String)"MSG_UnsufficientMemoryException", (Object)FileUtil.getFileDisplayName((FileObject)fo)), fo);
        }

        public FileObject getFile() {
            return this.fo;
        }
    }

    public static enum Priority {
        MAX,
        HIGH,
        ABOVE_NORMAL,
        NORMAL,
        BELOW_NORMAL,
        LOW,
        MIN;

    }
}

