/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.internal.runtime.methods;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.ast.executable.RubiniusCMethod;
import org.jruby.nb.ast.executable.RubiniusMachine;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.internal.runtime.JumpTarget;
import org.jruby.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.Frame;
import org.jruby.nb.runtime.RubyEvent;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class RubiniusMethod
extends DynamicMethod
implements JumpTarget {
    private RubiniusCMethod cmethod;
    private StaticScope staticScope;
    private Arity arity;

    public RubiniusMethod(RubyModule implementationClass, RubiniusCMethod cmethod, StaticScope staticScope, Visibility visibility) {
        super(implementationClass, visibility, CallConfiguration.FRAME_AND_SCOPE);
        this.staticScope = staticScope;
        this.cmethod = cmethod;
        this.arity = Arity.optional();
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name, IRubyObject[] args, Block block) {
        assert (args != null);
        Ruby runtime = context.getRuntime();
        this.callConfig.pre(context, self, klazz, name, block, this.staticScope, this);
        try {
            if (runtime.hasEventHooks()) {
                this.traceCall(context, runtime, name);
            }
            IRubyObject iRubyObject = RubiniusMachine.INSTANCE.exec(context, self, this.cmethod.code, this.cmethod.literals, args);
            return iRubyObject;
        }
        catch (JumpException.ReturnJump rj) {
            if (rj.getTarget() == this) {
                IRubyObject iRubyObject = (IRubyObject)rj.getValue();
                return iRubyObject;
            }
            throw rj;
        }
        finally {
            if (runtime.hasEventHooks()) {
                this.traceReturn(context, runtime, name);
            }
            this.callConfig.post(context);
        }
    }

    private void traceReturn(ThreadContext context, Ruby runtime, String name) {
        if (!runtime.hasEventHooks()) {
            return;
        }
        Frame frame = context.getPreviousFrame();
        runtime.callEventHooks(context, RubyEvent.RETURN, frame.getFile(), frame.getLine(), name, this.getImplementationClass());
    }

    private void traceCall(ThreadContext context, Ruby runtime, String name) {
        if (!runtime.hasEventHooks()) {
            return;
        }
        runtime.callEventHooks(context, RubyEvent.CALL, context.getFile(), context.getLine(), name, this.getImplementationClass());
    }

    @Override
    public Arity getArity() {
        return this.arity;
    }

    @Override
    public DynamicMethod dup() {
        return new RubiniusMethod(this.getImplementationClass(), this.cmethod, this.staticScope, this.getVisibility());
    }
}

