/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.jira.JiraUpdater;
import org.netbeans.modules.bugtracking.kenai.FakeJiraSupport;
import org.netbeans.modules.bugtracking.kenai.KenaiProjectImpl;
import org.netbeans.modules.bugtracking.kenai.Support;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiProject;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiUtil;
import org.netbeans.modules.bugtracking.kenai.spi.RecentIssue;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.kenai.ui.spi.KenaiIssueAccessor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class IssueAccessorImpl
extends KenaiIssueAccessor {
    public void open(final org.netbeans.modules.kenai.api.KenaiProject project, final String issueID) {
        FakeJiraSupport support = FakeJiraSupport.get(project);
        if (support != null && !BugtrackingUtil.isJiraInstalled()) {
            if (JiraUpdater.notifyJiraDownload((String)support.getIssueUrl(issueID))) {
                JiraUpdater.getInstance().downloadAndInstall();
            }
            return;
        }
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(Issue.class, (String)"LBL_GETTING_REPO"));
        handle.start();
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                Repository repo = KenaiUtil.getRepository((KenaiProject)KenaiProjectImpl.getInstance(project));
                handle.finish();
                try {
                    Issue.open((Repository)repo, (String)issueID);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        });
    }

    public KenaiIssueAccessor.IssueHandle[] getRecentIssues() {
        KenaiProjectImpl kenaiProject;
        Map recentIssues = BugtrackingUtil.getAllRecentIssues();
        Repository[] knownRepos = BugtrackingUtil.getKnownRepositories((boolean)false);
        HashMap<String, Repository> repoMap = new HashMap<String, Repository>(knownRepos.length);
        for (Repository repository : knownRepos) {
            repoMap.put(repository.getID(), repository);
        }
        HashMap<String, KenaiProjectImpl> issueToKenaiProject = new HashMap<String, KenaiProjectImpl>();
        ArrayList<RecentIssue> retIssues = new ArrayList<RecentIssue>(5);
        for (Map.Entry entry : recentIssues.entrySet()) {
            Repository repo = (Repository)repoMap.get(entry.getKey());
            if (repo == null) {
                Support.LOG.fine("No repository available with ID " + (String)entry.getKey());
                continue;
            }
            kenaiProject = (KenaiProjectImpl)((Object)repo.getLookup().lookup(KenaiProject.class));
            if (kenaiProject == null) continue;
            block2: for (RecentIssue ri : (List)entry.getValue()) {
                if (retIssues.size() > 5) {
                    retIssues.remove(5);
                }
                if (retIssues.isEmpty()) {
                    retIssues.add(ri);
                    issueToKenaiProject.put(ri.getIssue().getID(), kenaiProject);
                    continue;
                }
                for (int i = 0; i < retIssues.size(); ++i) {
                    if (ri.getTimestamp() > ((RecentIssue)retIssues.get(i)).getTimestamp()) {
                        retIssues.add(i, ri);
                        issueToKenaiProject.put(ri.getIssue().getID(), kenaiProject);
                        continue block2;
                    }
                    if (retIssues.size() >= 5) continue;
                    retIssues.add(retIssues.size(), ri);
                    issueToKenaiProject.put(ri.getIssue().getID(), kenaiProject);
                    continue block2;
                }
            }
        }
        ArrayList<IssueHandleImpl> ret = new ArrayList<IssueHandleImpl>(retIssues.size());
        for (RecentIssue recentIssue : retIssues) {
            kenaiProject = (KenaiProjectImpl)((Object)issueToKenaiProject.get(recentIssue.getIssue().getID()));
            assert (kenaiProject != null);
            ret.add(new IssueHandleImpl(recentIssue.getIssue(), kenaiProject.getProject()));
        }
        return ret.toArray(new KenaiIssueAccessor.IssueHandle[ret.size()]);
    }

    public KenaiIssueAccessor.IssueHandle[] getRecentIssues(org.netbeans.modules.kenai.api.KenaiProject project) {
        assert (project != null);
        if (project == null) {
            return new KenaiIssueAccessor.IssueHandle[0];
        }
        Repository repo = KenaiUtil.getRepository((KenaiProject)KenaiProjectImpl.getInstance(project), (boolean)false);
        if (repo == null) {
            Support.LOG.fine("No issue tracker available for the given kenai project [" + project.getName() + "," + project.getDisplayName() + "]");
            return new KenaiIssueAccessor.IssueHandle[0];
        }
        Collection issues = BugtrackingUtil.getRecentIssues((Repository)repo);
        if (issues == null) {
            return new KenaiIssueAccessor.IssueHandle[0];
        }
        ArrayList<IssueHandleImpl> ret = new ArrayList<IssueHandleImpl>(issues.size());
        for (Issue issue : issues) {
            IssueHandleImpl ih = new IssueHandleImpl(issue, project);
            ret.add(ih);
        }
        return ret.toArray(new KenaiIssueAccessor.IssueHandle[ret.size()]);
    }

    private class IssueHandleImpl
    extends KenaiIssueAccessor.IssueHandle {
        private final Issue issue;
        private final org.netbeans.modules.kenai.api.KenaiProject project;

        public IssueHandleImpl(Issue issue, org.netbeans.modules.kenai.api.KenaiProject project) {
            super((KenaiIssueAccessor)IssueAccessorImpl.this);
            this.issue = issue;
            this.project = project;
        }

        public String getID() {
            return this.issue.getID();
        }

        public org.netbeans.modules.kenai.api.KenaiProject getProject() {
            return this.project;
        }

        public String getShortDisplayName() {
            return this.issue.getShortenedDisplayName();
        }

        public String getDisplayName() {
            return this.issue.getDisplayName();
        }

        public boolean isOpened() {
            return BugtrackingUtil.isOpened((Issue)this.issue);
        }

        public boolean isShowing() {
            return BugtrackingUtil.isShowing((Issue)this.issue);
        }
    }
}

