/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.wizards;

import java.awt.Component;
import java.util.Vector;
import org.netbeans.modules.j2ee.sun.api.restricted.ResourceUtils;
import org.netbeans.modules.j2ee.sun.ide.editors.NameValuePair;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.JMSWizardVisualPanel;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigData;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigHelper;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceWizardPanel;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroup;
import org.netbeans.modules.j2ee.sun.sunresources.beans.FieldGroupHelper;
import org.netbeans.modules.j2ee.sun.sunresources.beans.Wizard;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;

public class JMSWizardPanel
extends ResourceWizardPanel {
    private JMSWizardVisualPanel component;
    private ResourceConfigHelper helper;
    private Wizard wizardInfo;
    private String[] groupNames;
    private boolean setupValid = true;

    public JMSWizardPanel(ResourceConfigHelper resourceConfigHelper, Wizard wizard) {
        this.helper = resourceConfigHelper;
        this.wizardInfo = wizard;
        this.groupNames = new String[]{"general"};
    }

    public Component getComponent() {
        if (this.component == null) {
            FieldGroup[] fieldGroupArray = new FieldGroup[this.groupNames.length];
            for (int i = 0; i < this.groupNames.length; ++i) {
                fieldGroupArray[i] = FieldGroupHelper.getFieldGroup(this.wizardInfo, this.groupNames[i]);
            }
            Object var2_3 = null;
            this.component = new JMSWizardVisualPanel(this, fieldGroupArray);
        }
        return this.component;
    }

    public boolean createNew() {
        return this.component != null;
    }

    @Override
    public HelpCtx getHelp() {
        return new HelpCtx("AS_Wiz_JMS_general");
    }

    public ResourceConfigHelper getHelper() {
        return this.helper;
    }

    public boolean isValid() {
        if (!this.setupValid) {
            this.setErrorMsg(this.bundle.getString("Err_InvalidSetup"));
            return false;
        }
        this.setErrorMsg(this.bundle.getString("Empty_String"));
        String string = this.helper.getData().getString("jndi-name");
        if (string.trim().length() == 0 || string.trim().equals("")) {
            this.setErrorMsg(this.bundle.getString("Err_InvalidJndiName"));
            return false;
        }
        if (!ResourceUtils.isLegalResourceName(string)) {
            this.setErrorMsg(this.bundle.getString("Err_InvalidJndiName"));
            return false;
        }
        if (!ResourceUtils.isUniqueFileName(string, this.helper.getData().getTargetFileObject(), "jms/myQueue")) {
            this.setErrorMsg(this.bundle.getString("Err_DuplFileJndiName"));
            return false;
        }
        return true;
    }

    public FieldGroup getFieldGroup(String string) {
        return FieldGroupHelper.getFieldGroup(this.wizardInfo, string);
    }

    @Override
    public void readSettings(Object object) {
        this.wizDescriptor = (WizardDescriptor)object;
        TemplateWizard templateWizard = (TemplateWizard)object;
        String string = templateWizard.getTargetName();
        FileObject fileObject = ResourceUtils.getResourceDirectory(this.helper.getData().getTargetFileObject());
        this.helper.getData().setTargetFileObject(fileObject);
        if (fileObject != null) {
            String string2 = this.helper.getData().getString("jndi-name");
            if (string2 != null && !string2.equals("")) {
                string = string2;
            }
            string = ResourceUtils.createUniqueFileName(string, fileObject, "jms/myQueue");
            this.helper.getData().setTargetFile(string);
            if (this.component == null) {
                this.getComponent();
            }
            this.component.setHelper(this.helper);
        } else {
            this.setupValid = false;
        }
    }

    @Override
    public boolean isFinishPanel() {
        this.isValid();
        ResourceConfigData resourceConfigData = this.helper.getData();
        Vector vector = resourceConfigData.getProperties();
        for (int i = 0; i < vector.size(); ++i) {
            NameValuePair nameValuePair = (NameValuePair)vector.elementAt(i);
            if (nameValuePair.getParamName() != null && nameValuePair.getParamValue() != null && nameValuePair.getParamName().length() != 0 && nameValuePair.getParamValue().length() != 0) continue;
            return false;
        }
        return true;
    }

    private boolean setupValid() {
        return this.setupValid;
    }
}

