/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.parser.fastparser.FastParser;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.stmtType;

public abstract class PyMethodNavigation
extends PyAction {
    protected abstract boolean getSearchForward();

    public void run(IAction action) {
        PyEdit pyEdit = this.getPyEdit();
        IDocument doc = pyEdit.getDocumentProvider().getDocument((Object)pyEdit.getEditorInput());
        ITextSelection selection = (ITextSelection)pyEdit.getSelectionProvider().getSelection();
        boolean searchForward = this.getSearchForward();
        int startLine = selection.getStartLine();
        startLine = searchForward ? ++startLine : --startLine;
        stmtType goHere = FastParser.firstClassOrFunction((IDocument)doc, (int)startLine, (boolean)searchForward);
        NameTok node = this.getNameNode(goHere);
        if (node != null) {
            pyEdit.revealModelNode((SimpleNode)node);
        } else if (searchForward) {
            pyEdit.selectAndReveal(doc.getLength(), 0);
        } else {
            pyEdit.selectAndReveal(0, 0);
        }
    }

    protected NameTok getNameNode(stmtType defNode) {
        NameTok node = null;
        if (defNode != null) {
            ClassDef def;
            if (defNode instanceof ClassDef) {
                def = (ClassDef)defNode;
                node = (NameTok)def.name;
            }
            if (defNode instanceof FunctionDef) {
                def = (FunctionDef)defNode;
                node = (NameTok)def.name;
            }
        }
        return node;
    }
}

