/*
 * Decompiled with CFR 0.152.
 */
package mx4j.monitor;

import java.math.BigInteger;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import mx4j.log.Logger;
import mx4j.monitor.MX4JCounterMonitorMBean;
import mx4j.monitor.MX4JMonitor;

public class MX4JCounterMonitor
extends MX4JMonitor
implements MX4JCounterMonitorMBean {
    private static Integer ZERO = new Integer(0);
    private Number threshold = ZERO;
    private Number offset = ZERO;
    private Number modulus = ZERO;
    private boolean notify;
    private boolean differenceMode;
    static /* synthetic */ Class class$mx4j$monitor$MX4JCounterMonitorMBean;

    public MX4JCounterMonitor() throws NotCompliantMBeanException {
        super(class$mx4j$monitor$MX4JCounterMonitorMBean == null ? (class$mx4j$monitor$MX4JCounterMonitorMBean = MX4JCounterMonitor.class$("mx4j.monitor.MX4JCounterMonitorMBean")) : class$mx4j$monitor$MX4JCounterMonitorMBean);
    }

    protected MX4JCounterMonitor(Class management) throws NotCompliantMBeanException {
        super(management);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    public synchronized Number getInitThreshold() {
        return this.threshold;
    }

    public void setInitThreshold(Number threshold) throws IllegalArgumentException {
        if (threshold == null || this.compare(threshold, ZERO) < 0) {
            throw new IllegalArgumentException("Threshold cannot be " + threshold);
        }
        this.threshold = threshold;
    }

    public synchronized Number getOffset() {
        return this.offset;
    }

    public void setOffset(Number offset) throws IllegalArgumentException {
        if (offset == null || this.compare(offset, ZERO) < 0) {
            throw new IllegalArgumentException("Offset cannot be " + offset);
        }
        this.offset = offset;
    }

    public Number getModulus() {
        return this.modulus;
    }

    public void setModulus(Number modulus) throws IllegalArgumentException {
        if (modulus == null || this.compare(modulus, ZERO) < 0) {
            throw new IllegalArgumentException("Modulus cannot be " + modulus);
        }
        this.modulus = modulus;
    }

    public boolean getNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
    }

    public boolean getDifferenceMode() {
        return this.differenceMode;
    }

    public void setDifferenceMode(boolean mode) {
        this.differenceMode = mode;
    }

    public Number getDerivedGauge(ObjectName name) {
        CounterMonitorInfo info = (CounterMonitorInfo)this.getMonitorInfo(name);
        return info.getGauge();
    }

    public long getDerivedGaugeTimeStamp(ObjectName name) {
        CounterMonitorInfo info = (CounterMonitorInfo)this.getMonitorInfo(name);
        return info.getTimestamp();
    }

    public Number getThreshold(ObjectName name) {
        CounterMonitorInfo info = (CounterMonitorInfo)this.getMonitorInfo(name);
        return info.getThreshold();
    }

    protected int compare(Number left, Number right) {
        if (left instanceof BigInteger && right instanceof BigInteger) {
            return ((BigInteger)left).compareTo((BigInteger)right);
        }
        if (left.longValue() == right.longValue()) {
            return 0;
        }
        return left.longValue() > right.longValue() ? 1 : -1;
    }

    protected Number sum(Number left, Number right) {
        if (left instanceof BigInteger && right instanceof BigInteger) {
            return ((BigInteger)left).add((BigInteger)right);
        }
        if (left instanceof BigInteger) {
            return ((BigInteger)left).add(BigInteger.valueOf(right.longValue()));
        }
        if (right instanceof BigInteger) {
            return ((BigInteger)right).add(BigInteger.valueOf(left.longValue()));
        }
        if (left instanceof Long || right instanceof Long) {
            return new Long(left.longValue() + right.longValue());
        }
        if (left instanceof Integer || right instanceof Integer) {
            return new Integer(left.intValue() + right.intValue());
        }
        if (left instanceof Short || right instanceof Short) {
            return new Short((short)(left.shortValue() + right.shortValue()));
        }
        if (left instanceof Byte || right instanceof Byte) {
            return new Byte((byte)(left.byteValue() + right.byteValue()));
        }
        return null;
    }

    protected Number sub(Number left, Number right) {
        if (left instanceof BigInteger && right instanceof BigInteger) {
            return ((BigInteger)left).subtract((BigInteger)right);
        }
        if (left instanceof BigInteger) {
            return ((BigInteger)left).subtract(BigInteger.valueOf(right.longValue()));
        }
        if (left instanceof Long || right instanceof Long) {
            return new Long(left.longValue() - right.longValue());
        }
        if (left instanceof Integer || right instanceof Integer) {
            return new Integer(left.intValue() - right.intValue());
        }
        if (left instanceof Short || right instanceof Short) {
            return new Short((short)(left.shortValue() - right.shortValue()));
        }
        if (left instanceof Byte || right instanceof Byte) {
            return new Byte((byte)(left.byteValue() - right.byteValue()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void monitor(ObjectName name, String attribute, Object value, MX4JMonitor.MonitorInfo monitorInfo) {
        boolean notified;
        Number vt;
        boolean rolledOver;
        if (!(value instanceof Number)) {
            this.sendErrorNotification(monitorInfo, "jmx.monitor.error.type", "Attribute type must be a Number, not " + value.getClass(), name, attribute);
            return;
        }
        Number threshold = null;
        Number offset = null;
        Number modulus = null;
        MX4JCounterMonitor mX4JCounterMonitor = this;
        synchronized (mX4JCounterMonitor) {
            threshold = this.getThreshold(name);
            offset = this.getOffset();
            modulus = this.getModulus();
        }
        Number counter = (Number)value;
        Class<?> gaugeClass = counter.getClass();
        if (threshold != ZERO && threshold.getClass() != gaugeClass) {
            this.sendErrorNotification(monitorInfo, "jmx.monitor.error.threshold", "Threshold type " + threshold.getClass() + " must be of same type of the attribute " + gaugeClass, name, attribute);
            return;
        }
        if (offset != ZERO && offset.getClass() != gaugeClass) {
            this.sendErrorNotification(monitorInfo, "jmx.monitor.error.threshold", "Offset type " + offset.getClass() + " must be of same type of the attribute " + gaugeClass, name, attribute);
            return;
        }
        if (modulus != ZERO && modulus.getClass() != gaugeClass) {
            this.sendErrorNotification(monitorInfo, "jmx.monitor.error.threshold", "Modulus type " + modulus.getClass() + " must be of same type of the attribute " + gaugeClass, name, attribute);
            return;
        }
        Logger logger = this.getLogger();
        CounterMonitorInfo info = (CounterMonitorInfo)monitorInfo;
        Number lastCounter = info.getCounter();
        boolean bl = lastCounter != null ? this.compare(counter, lastCounter) < 0 : (rolledOver = false);
        if (this.getDifferenceMode()) {
            if (lastCounter == null) {
                vt = ZERO;
            } else {
                vt = this.sub(counter, lastCounter);
                if (rolledOver) {
                    vt = this.sum(vt, modulus);
                }
                if (rolledOver) {
                    threshold = this.getInitThreshold();
                    if (logger.isEnabledFor(10)) {
                        logger.debug("Threshold has been rolled over, new value = " + threshold);
                    }
                }
            }
        } else {
            vt = counter;
            if (rolledOver && this.compare(modulus, ZERO) > 0 && this.compare(threshold, modulus) > 0) {
                threshold = this.getInitThreshold();
                if (logger.isEnabledFor(10)) {
                    logger.debug("Threshold has been rolled over, new value = " + threshold);
                }
            }
        }
        if (logger.isEnabledFor(10)) {
            logger.debug("Computing gauge, previous values are: " + info);
            logger.debug("Current values are: threshold=" + threshold + ", offset=" + offset + ", modulus=" + modulus);
            logger.debug("V[t] = " + vt + ", rolledOver = " + rolledOver);
        }
        info.setGauge(vt);
        if (this.compare(vt, threshold) >= 0) {
            if (logger.isEnabledFor(10)) {
                logger.debug("Threshold exceeded: V[t]=" + vt + ", threshold=" + threshold);
            }
            if (this.getNotify()) {
                if (info.isThresholdNotified()) {
                    if (logger.isEnabledFor(10)) {
                        logger.debug("Threshold exceeded already notified");
                    }
                } else {
                    if (logger.isEnabledFor(10)) {
                        logger.debug("Sending threshold exceeded notification");
                    }
                    this.sendNotification("jmx.monitor.counter.threshold", "Threshold " + threshold + " exceeded: " + vt, name, attribute, counter, threshold);
                }
                notified = true;
            } else {
                notified = false;
            }
            if (this.compare(offset, ZERO) > 0) {
                while (this.compare(vt, threshold = this.sum(threshold, offset)) >= 0) {
                }
                if (logger.isEnabledFor(10)) {
                    logger.debug("Threshold has been offset, new value = " + threshold);
                }
            }
        } else {
            notified = false;
        }
        CounterMonitorInfo newInfo = (CounterMonitorInfo)this.createMonitorInfo();
        newInfo.setThresholdNotified(notified);
        newInfo.setCounter(counter);
        newInfo.setGauge(vt);
        newInfo.setTimestamp(System.currentTimeMillis());
        newInfo.setThreshold(threshold);
        this.putMonitorInfo(name, newInfo);
    }

    protected MX4JMonitor.MonitorInfo createMonitorInfo() {
        return new CounterMonitorInfo();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class CounterMonitorInfo
    extends MX4JMonitor.MonitorInfo {
        private boolean thresholdNotified;
        private Number counter = null;
        private Number gauge = MX4JCounterMonitor.access$000();
        private long timestamp;
        private Number threshold = MX4JCounterMonitor.access$000();

        protected CounterMonitorInfo() {
            super(MX4JCounterMonitor.this);
        }

        public void setThreshold(Number threshold) {
            this.threshold = threshold;
        }

        public Number getThreshold() {
            if (this.threshold == ZERO) {
                return MX4JCounterMonitor.this.getInitThreshold();
            }
            return this.threshold;
        }

        public void setThresholdNotified(boolean thresholdNotified) {
            this.thresholdNotified = thresholdNotified;
        }

        public boolean isThresholdNotified() {
            return this.thresholdNotified;
        }

        public void setCounter(Number counter) {
            this.counter = counter;
        }

        public Number getCounter() {
            return this.counter;
        }

        public void setGauge(Number gauge) {
            this.gauge = gauge;
        }

        public Number getGauge() {
            return this.gauge;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void clearNotificationStatus() {
            super.clearNotificationStatus();
            this.thresholdNotified = false;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(super.toString());
            buffer.append(", thresholdNotified=").append(this.isThresholdNotified());
            buffer.append(", gauge=").append(this.getGauge());
            buffer.append(", counter=").append(this.getCounter());
            buffer.append(", threshold=").append(this.threshold);
            return buffer.toString();
        }
    }
}

