// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_SQLBUILDER_H
#define _LIBGDAMM_SQLBUILDER_H


#include <glibmm.h>

// -*- C++ -*- //

/* sqlbuilder.h
 *
 * Copyright 2006 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/statement.h>
#include <libgdamm/sqlexpr.h>
#include <libgdamm/sqlstatement.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaSqlBuilder GdaSqlBuilder;
typedef struct _GdaSqlBuilderClass GdaSqlBuilderClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class SqlBuilder_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

/** @addtogroup libgdammEnums libgdamm Enums and Flags */

/**
 * @ingroup libgdammEnums
 */
enum SqlOperatorType
{
  SQL_OPERATOR_TYPE_AND,
  SQL_OPERATOR_TYPE_OR,
  SQL_OPERATOR_TYPE_EQ,
  SQL_OPERATOR_TYPE_IS,
  SQL_OPERATOR_TYPE_LIKE,
  SQL_OPERATOR_TYPE_BETWEEN,
  SQL_OPERATOR_TYPE_GT,
  SQL_OPERATOR_TYPE_LT,
  SQL_OPERATOR_TYPE_GEQ,
  SQL_OPERATOR_TYPE_LEQ,
  SQL_OPERATOR_TYPE_DIFF,
  SQL_OPERATOR_TYPE_REGEXP,
  SQL_OPERATOR_TYPE_REGEXP_CI,
  SQL_OPERATOR_TYPE_NOT_REGEXP,
  SQL_OPERATOR_TYPE_NOT_REGEXP_CI,
  SQL_OPERATOR_TYPE_SIMILAR,
  SQL_OPERATOR_TYPE_ISNULL,
  SQL_OPERATOR_TYPE_ISNOTNULL,
  SQL_OPERATOR_TYPE_NOT,
  SQL_OPERATOR_TYPE_IN,
  SQL_OPERATOR_TYPE_NOTIN,
  SQL_OPERATOR_TYPE_CONCAT,
  SQL_OPERATOR_TYPE_PLUS,
  SQL_OPERATOR_TYPE_MINUS,
  SQL_OPERATOR_TYPE_STAR,
  SQL_OPERATOR_TYPE_DIV,
  SQL_OPERATOR_TYPE_REM,
  SQL_OPERATOR_TYPE_BITAND,
  SQL_OPERATOR_TYPE_BITOR,
  SQL_OPERATOR_TYPE_BITNOT
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::SqlOperatorType> : public Glib::Value_Enum<Gnome::Gda::SqlOperatorType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/**
 * @ingroup libgdammEnums
 */
enum SqlSelectJoinType
{
  SQL_SELECT_JOIN_CROSS,
  SQL_SELECT_JOIN_NATURAL,
  SQL_SELECT_JOIN_INNER,
  SQL_SELECT_JOIN_LEFT,
  SQL_SELECT_JOIN_RIGHT,
  SQL_SELECT_JOIN_FULL
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::SqlSelectJoinType> : public Glib::Value_Enum<Gnome::Gda::SqlSelectJoinType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

class SqlBuilderError : public Glib::Error
{
public:
  enum Code
  {
    SQL_BUILDER_WRONG_TYPE_ERROR,
    SQL_BUILDER_MISUSE_ERROR
  };

  SqlBuilderError(Code error_code, const Glib::ustring& error_message);
  explicit SqlBuilderError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()
#endif //DOXYGEN_SHOULD_SKIP_THIS
};

} // namespace Gda

} // namespace Gnome

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::SqlBuilderError::Code> : public Glib::Value_Enum<Gnome::Gda::SqlBuilderError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

class SqlError : public Glib::Error
{
public:
  enum Code
  {
    SQL_STRUCTURE_CONTENTS_ERROR,
    SQL_MALFORMED_IDENTIFIER_ERROR,
    SQL_MISSING_IDENTIFIER_ERROR,
    SQL_VALIDATION_ERROR
  };

  SqlError(Code error_code, const Glib::ustring& error_message);
  explicit SqlError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()
#endif //DOXYGEN_SHOULD_SKIP_THIS
};

} // namespace Gda

} // namespace Gnome

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::SqlError::Code> : public Glib::Value_Enum<Gnome::Gda::SqlError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


/** SqlBuilder can be used to build a Statement from its structural description, 
 * much in the same way a SqlParser can be used to build a Statement from a SQL string.
 *
 * You may, for instance, pass the SqlBuilder directly to 
 * Connection::statement_execute_select_builder() or 
 * Connection::statement_execute_non_select_builder(). Or you may instead call 
 * get_statement() and use the resulting SqlStatement.
 *
 * During the building process, some pieces of the statement are constructed 
 * and assembled into the final statement. Each of these pieces can be reused 
 * anytime in the same SqlBuilder object, and each is identified using a 
 * single ID. That ID is dynamically allocated by the object.
 * 
 * This simple example builds the equivalent of this SQL query:
 * "SELECT employees.name_first, employees.name_last FROM employees WHERE employees.employee_id = 123".
 *
 * @code
 * Glib::RefPtr<Gnome::Gda::SqlBuilder> builder =
 *   Gnome::Gda::SqlBuilder::create(Gnome::Gda::SQL_STATEMENT_SELECT);
 * builder->select_add_field("name_fist", "employees");
 * builder->select_add_field("name_last", "employees");
 * builder->select_add_target("employees");
 * builder->set_where(
 *   builder->add_cond(Gnome::Gda::SQL_OPERATOR_TYPE_EQ,
 *     builder->add_field_id("employee_id", "employees"),
 *     builder->add_expr(123)));
 * @endcode
 *
 * Note that, in this simple example, it's not necessary to specify the extra 
 * "employees" table name parameter to select_add_field() and add_field_id(),
 * though it's often a good idea to avoid ambiguity in larger queries. 
 */

class SqlBuilder : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef SqlBuilder CppObjectType;
  typedef SqlBuilder_Class CppClassType;
  typedef GdaSqlBuilder BaseObjectType;
  typedef GdaSqlBuilderClass BaseClassType;

private:  friend class SqlBuilder_Class;
  static CppClassType sqlbuilder_class_;

private:
  // noncopyable
  SqlBuilder(const SqlBuilder&);
  SqlBuilder& operator=(const SqlBuilder&);

protected:
  explicit SqlBuilder(const Glib::ConstructParams& construct_params);
  explicit SqlBuilder(GdaSqlBuilder* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~SqlBuilder();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaSqlBuilder*       gobj()       { return reinterpret_cast<GdaSqlBuilder*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaSqlBuilder* gobj() const { return reinterpret_cast<GdaSqlBuilder*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaSqlBuilder* gobj_copy();

private:

protected:
  SqlBuilder(SqlStatementType type);
public:
  
  static Glib::RefPtr<SqlBuilder> create(SqlStatementType type);


  /** Creates a new Gda::Statement statement from @a builder's contents.
   * 
   * @newin{4,2}
   * @return A new Gda::Statement object, or <tt>0</tt> if an error occurred.
   */
  Glib::RefPtr<Statement> get_statement() const;

 
  /** Creates a new Gda::SqlStatement structure from @a builder's contents.
   * 
   * The returned pointer belongs to @a builder's internal representation.
   * Use gda_sql_statement_copy() if you need to keep it.
   * 
   * @newin{4,2}
   * @return A Gda::SqlStatement pointer.
   */
  SqlStatement get_sql_statement() const;

  
  //A duplicate of the GdsSqlBuilderId typedef in libgda's header, to avoid including the header here.
  typedef guint Id;
  
  // Expression API:

  
  /** Defines an expression representing an identifier in @a builder,
   * which may be reused to build other parts of a statement,
   * for instance as a parameter to add_cond() or
   * add_field_value_id().
   * 
   * The new expression will contain the @a string literal.
   * For example:
   * <programlisting>
   * gda_sql_builder_add_id (b, "name")
   * gda_sql_builder_add_id (b, "date")
   * </programlisting>
   * 
   * will be rendered as SQL as:
   * <programlisting>
   * name
   * "date"
   * </programlisting>
   * 
   * because "date" is an SQL reserved keyword.
   * 
   * For fields, see add_field_id().
   * 
   * @newin{4,2}
   * @param string A string.
   * @return The ID of the new expression, or %0 if there was an error.
   */
  Id add_id(const Glib::ustring& string);
  
  
  /** Defines an expression representing a field in @a builder,
   * which may be reused to build other parts of a statement,
   * for instance as a parameter to add_cond() or
   * add_field_value_id().
   * 
   * Calling this with a <tt>0</tt> @a table_name is equivalent to calling add_id().
   * 
   * For SELECT queries, see select_add_field().
   * 
   * @newin{4,2}
   * @param field_name A field name.
   * @param table_name A table name, or <tt>0</tt>.
   * @return The ID of the new expression, or %0 if there was an error.
   */
  Id add_field_id(const Glib::ustring& field_name, const Glib::ustring& table_name = Glib::ustring());

  /** Defines an expression in Builder which may be reused to build other parts of a statement.
   * @param dh The datahandler to use
   * @param value: value to set the expression to
   *
   * See expr() except that no custom datahandler is given
   *
   * @return The ID of the new expression, or 0 if there was an error.
   */
  template <class ValueType>
  Id add_expr(const Glib::RefPtr<DataHandler>& dh, const ValueType& value);

  /** Defines an expression in Builder which may be reused to build other parts of a statement.
   * @param dh The datahandler to use
   * @param value: value to set the expression to
   *
   * See expr() except that no custom datahandler is given
   *
   * @return The ID of the new expression, or 0 if there was an error.
   */
  Id add_expr_as_value(const Glib::RefPtr<DataHandler>& dh, const Value& value);

  /** Defines an expression in Builder which may be reused to build other parts of a statement.
   * @param value: value to set the expression to
   *
   * See expr() except that no custom datahandler is given
   *
   * @return The ID of the new expression, or 0 if there was an error.
   */
  template <class ValueType>
  Id add_expr(const ValueType& value);

  /** Defines an expression in Builder which may be reused to build other parts of a statement.
   * @param value: value to set the expression to
   *
   * See expr() except that no custom datahandler is given
   *
   * @return The ID of the new expression, or 0 if there was an error.
   */
  Id add_expr_as_value(const Value& value);

  /** Defines a parameter which may be reused to build other parts of a statement.
   * @param: param_name: name of the parameter
   * @type: GType of the parameter
   * @nullok True if the parameter can be set to %NULL
   *
   * @return The ID of the new expression, or 0 if there was an error.
   */
  Id add_param(const Glib::ustring& param_name, GType type, bool nullok = false);

  /** Builds a new expression which reprenents a condition (or operation).
   * @param op Type of condition
   * @param op1 The ID of the 1st argument (not 0)
   * @param op2 The ID of the 2st argument (maybe 0 if op only requires one argument)
   * @param op3 The ID of the 3st argument (maybe 0 if op only requires one or two arguments)
   *
   * @return The ID of the new expression, or 0 if there was an error.
   */
  Id add_cond(SqlOperatorType op, Id op1, Id op2 = 0, Id op3 = 0);

  /** Builds a new expression which reprenents a condition (or operation).
   * @param op Type of condition
   * @param op_ids: list of IDs of the operands of the condition
   *
   * @return The ID of the new expression, or 0 if there was an error.
   */
  Id add_cond(SqlOperatorType op, const Glib::ArrayHandle<Id>& op_ids);

  
  /** Builds a new expression which represents a function applied to some arguments.
    *
    * @param function_name The name of the function to embed (e.g. MAX, MIN, ...)
    * @param args: list of ids of the arguments to the function
    *
    * @return The ID of the new target, or 0 if there was an error.
    */
  Id add_function(const Glib::ustring& function_name, const Glib::ArrayHandle<Id>& args);

  /** Builds a new expression which represents a function applied to an argument.
   *
   * @param function_name The name of the function to embed (e.g. MAX, MIN, ...)
   * @param arg: The ids of the argument to the function
   *
   * @return The ID of the new target, or 0 if there was an error.
   */
  Id add_function(const Glib::ustring& function_name, Id arg);


  /** Adds an expression which is a subselect.
   *
   * @param sqlst A SqlStatement, which must be a SELECT or compound SELECT.
   * @return The ID of the new expression, or 0 if there was an error.
   */
  Id add_sub_select(const SqlStatement& sqlst);
  

//TODO:  _WRAP_METHOD(Id gda_sql_builder_add_case (GdaSqlBuilder *builder, Id id,  Id test_expr, Id else_expr, ...);
//TODO:  _WRAP_METHOD(Id gda_sql_builder_add_case_v (GdaSqlBuilder *builder, Id id,  Id test_expr, Id else_expr,  const Id *when_array, const Id *then_array, gint args_size);

  //TODO: Id add_case(Id id, Id test_expr, Id else_expr, const type_case_pairs& case_pairs);
  //__IGNORE(gda_sql_builder_add_case)

   
  /** Valid only for: SELECT statements.
   * 
   * Add a selected selected item to the SELECT statement.
   * 
   * For non-SELECT statements, see add_field_id().
   * 
   * @newin{4,2}
   * @param field_name A field name.
   * @param table_name A table name, or <tt>0</tt>.
   * @param alias An alias (eg. for the "AS" clause), or <tt>0</tt>.
   * @return The ID of the added field, or %0 if there was an error.
   */
  Id select_add_field(const Glib::ustring& field_name, const Glib::ustring& table_name, const Glib::ustring& alias = Glib::ustring());

  // Statement API
  /** Adds a new target to a SELECT statement.
   *
   * @param table_id The ID of the expression holding a table reference.
   * @param alias The alias to give to the target.
   *
   * @return The ID of the new target, or 0 if there was an error.
   */
  Id select_add_target(const Glib::ustring& table_name, const Glib::ustring& alias = Glib::ustring());
  

  /** Adds a new target to a SELECT statement. If there already exists a target representing
   * the same table and the same alias (or with the same absence of alias) then the same target
   * ID is returned instead of the ID of a new target.
   * 
   * @newin{4,2}
   * @param table_id The ID of the expression holding a table reference (not %0).
   * @param alias The alias to give to the target, or <tt>0</tt>.
   * @return The ID of the new (or existing) target, or %0 if there was an error.
   */
  Id select_add_target_id(Id table_id, const Glib::ustring& alias = Glib::ustring());

  /** Joins two targets in a SELECT statement.
   *
   * @param left_target_id The ID of the left target to use (not %0)
   * @param right_target_id The ID of the right target to use (not %0)
   * @param join_type The type of join
   * @param join_expr Joining expression's ID, or %0
   *
   * @return The ID of the new join, or 0 if there was an error.
   */
  Id select_join_targets(Id left_target_id, Id right_target_id, SqlSelectJoinType join_type, Id join_expr = 0);

  
  /** Alter a join in a SELECT statement to make its condition use equal field 
   * values in the fields named @a field_name in both tables, via the USING keyword.
   * 
   * @newin{4,2}
   * @param join_id The ID of the join to modify (not %0).
   * @param field_name The name of the field to use in the join condition (not <tt>0</tt>).
   * @return The ID of the new join, or %0 if there was an error.
   */
  void join_add_field(Id join_id, const Glib::ustring& field_name);
  
  /** Adds a new ORDER BY expression to a SELECT statement.
   * 
   * @newin{4,2}
   * @param expr_id The ID of the expression to use during sorting (not %0).
   * @param asc <tt>true</tt> for an ascending sorting.
   * @param collation_name Name of the collation to use when sorting, or <tt>0</tt>.
   */
  void select_order_by(Id expr_id, bool asc = true, const Glib::ustring& collation_name = Glib::ustring());

  /** Adds or removes a DISTINCT clause for a SELECT statement.
   * @param distinct Whether a DISTINCT clause should be in the SELECT statement.
   * @newin4p2
   */
  void select_set_distinct(bool distinct = true);

  
  /** Defines (if @a distinct is <tt>true</tt>) or removes (if @a distinct is <tt>false</tt>) a DISTINCT clause
   * for a SELECT statement.
   * 
   * If @a distinct is <tt>true</tt>, then the ID of an expression can be specified as the @a expr_id argument:
   * if not %0, this is the expression used to apply the DISTINCT clause on (the resuting SQL
   * will then usually be "... DISTINCT ON <expression>...").
   * 
   * @newin{4,2}
   * @param distinct Set to <tt>true</tt> to have the DISTINCT requirement.
   * @param expr_id The ID of the DISTINCT ON expression, or %0 if no expression is to be used. It is ignored
   * if @a distinct is <tt>false</tt>.
   */
  void select_set_distinct(bool distinct, Id expr_id);

  /** Defines the maximum number of rows in the DataModel resulting from the execution of the built statement.
   *
   * @param limit_count The number of rows that should be returned.
   * @param The offset of the first row that should appear in the result. (note that
   * this feature may not be supported by all the database providers.)
   */
  void select_set_limit(Id limit_count, Id offset = 0);

  
  /** If @a limit_count_expr_id is not %0, defines the maximum number of rows in the Gda::DataModel
   * resulting from the execution of the built statement. In this case, the offset from which the
   * rows must be collected can be defined by the @a limit_offset_expr_id expression if not %0 (note that
   * this feature may not be supported by all the database providers).
   * 
   * If @a limit_count_expr_id is %0, then removes any LIMIT which may have been imposed by a previous
   * call to this method.
   * 
   * @newin{4,2}
   * @param limit_count_expr_id The ID of the LIMIT expression, or %0.
   * @param limit_offset_expr_id The ID of the OFFSET expression, or %0.
   */
  void select_set_limit_id(Id limit_count_expr_id, Id limit_offest_expr_id = 0);

  
  /** Valid only for: SELECT statements
   * 
   * Sets the HAVING condition of the statement
   * 
   * @newin{4,2}
   * @param cond_id The ID of the expression to set as HAVING condition, or 0 to unset any previous HAVING condition.
   */
  void select_set_having(Id cond_id);

  
  /** Valid only for: SELECT statements
   * 
   * Adds the @a expr_id expression to the GROUP BY clause's expressions list
   * 
   * @newin{4,2}
   * @param expr_id The ID of the expression to set use in the GROUP BY clause, or 0 to unset any previous GROUP BY clause.
   */
  void select_group_by(Id expr_id);
  //TODO: Add select_group_by_field()?

  // General Statement API
  
  /** Valid only for: INSERT, UPDATE, DELETE statements
   * 
   * Sets the name of the table on which the built statement operates.
   * 
   * @newin{4,2}
   * @param table_name A table name.
   */
  void set_table(const Glib::ustring& table_name);
  
  /** Valid only for: UPDATE, DELETE, SELECT statements
   * 
   * Sets the WHERE condition of the statement
   * 
   * @newin{4,2}
   * @param cond_id The ID of the expression to set as WHERE condition, or 0 to unset any previous WHERE condition.
   */
  void set_where(Id cond_id);

  //The documentation is hand-written to use doxygen's list/item syntax.
  
  /** Valid only for: INSERT, UPDATE, SELECT statements.
   * - For UPDATE: specifies that the field represented by @a field_id will be set to the value identified
   * by @a value_id.
   * - For SELECT: add a selected item to the statement, and if @a value_id is not %0, then use it as an
   * alias
   * - For INSERT: if @a field_id represents an SQL identifier (obtained using add_id()): then if
   *  @a value_id is not %0 then specifies that the field represented by @a field_id will be set to the
   * value identified by @a value_id, otherwise just specifies a named field to be given a value.
   * If @a field_id represents a sub SELECT (obtained using add_sub_select()), then
   * this method call defines the sub SELECT from which values to insert are taken.
   * 
   * See also add_field_value() and add_field_value_as_gvalue().
   * 
   * @newin{4,2}
   * @param field_id The ID of the field's name or definition.
   * @param value_id The ID of the value to set the field to, or %0.
   */
  void add_field_value_id(Id field_id, Id value_id = 0);

  /** Specifies that the field represented by @a field_name will be set to the @a value.
   * See gadd_expr() for more information.
   * This is valid only for INSERT and UPDATE statements.
   *
   * @parm field_name A field name.
   * @param value The value to set the field to.
   */
  template <class ValueType>
  void add_field_value(const Glib::ustring& field_name, const ValueType& value);

  
  /** Valid only for: INSERT, UPDATE statements.
   * 
   * Specifies that the field represented by @a field_name will be set to the value identified
   * by @a value
   * 
   * @newin{4,2}
   * @param field_name A field name.
   * @param value Value to set the field to, or <tt>0</tt> or a GDA_TYPE_<tt>0</tt> value to represent an SQL <tt>0</tt>.
   */
  void add_field_value_as_value(const Glib::ustring& field_name, const Value& value);
  

/* COMPOUND SELECT Statement API */
  //TODO: Wrap the enum when we wrap GdaSqlStatementCompound _WRAP_METHOD(void compound_set_type(SqlStatementCompoundType compound_type), gda_sql_builder_compound_set_type)
  
  /** Add a sub select to a COMPOUND statement
   * 
   * @newin{4,2}
   * @param sqlst A pointer to a Gda::SqlStatement, which has to be a SELECT or compound SELECT. This will be copied.
   */
  void compound_add_sub_select(const SqlStatement& sqlst);

  
  /** Exports a part managed by @a builder as a new Gda::SqlExpr, which can represent any expression
   * in a statement.
   * 
   * @newin{4,2}
   * @param id The ID of the expression to be exported, (must be a valid ID in @a builder, not %0).
   * @return A pointer to a new Gda::SqlExpr structure, free using gda_sql_expr_free() when not
   * needed anymore. If the part with @a id as ID cannot be found, the returned value is <tt>0</tt>.
   */
  SqlExpr export_expression(Id id) const;

  //TODO: This is a crappy description.
  /** Imports the expression.
   *
   * @param expr A SqlExpr obtained using export_expression().
   * @return The ID of the new expression, or 0 if there was an error.
   */
  Id import_expression(const SqlExpr& expr);
  

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

#ifndef DOXYGEN_SHOULD_SKIP_THIS

template <class ValueType> inline
void SqlBuilder::add_field_value(const Glib::ustring& field_name, const ValueType& value)
{
  Gnome::Gda::Value gdavalue(value);
  this->add_field_value_as_value(field_name, gdavalue);
}

template <class ValueType> inline
SqlBuilder::Id SqlBuilder::add_expr(const Glib::RefPtr<DataHandler>& dh, const ValueType& value)
{
  Gnome::Gda::Value gdavalue(value);
  return this->add_expr_as_value(dh, gdavalue);
}

template <class ValueType> inline
SqlBuilder::Id SqlBuilder::add_expr(const ValueType& value)
{
  Gnome::Gda::Value gdavalue(value);
  return this->add_expr_as_value(gdavalue);
}

#endif //DOXYGEN_SHOULD_SKIP_THIS

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::SqlBuilder
   */
  Glib::RefPtr<Gnome::Gda::SqlBuilder> wrap(GdaSqlBuilder* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_SQLBUILDER_H */

