#if !defined(__MSP430_HEADERS_SFR_H__)
#define __MSP430_HEADERS_SFR_H__

/* sfr.h
 *
 * mspgcc project: MSP430 device headers
 * SFR (Special Function Registers) module header
 *
 * Peter Bigot <pab@peoplepowerco.com>
 * Originally based in part on work by Texas Instruments Inc.
 *
 * $Id: $
 *
 */

/* Switches:
__MSP430_SFR_BASE__ - base address of SFR module
*/

#if defined(__MSP430_SFR_BASE__)

#define SFRIE1_             __MSP430_SFR_BASE__  /* Interrupt Enable 1 */
#define SFRIE1_L_           SFRIE1_
#define SFRIE1_H_           SFRIE1_ + 0x01
sfrw(SFRIE1, SFRIE1_);
sfrb(SFRIE1_L, SFRIE1_L_);
sfrb(SFRIE1_H, SFRIE1_H_);

#define SFRIFG1_            __MSP430_SFR_BASE__ + 0x02  /* Interrupt Flag 1 */
#define SFRIFG1_L_          SFRIFG1_
#define SFRIFG1_H_          SFRIFG1_ + 0x01
sfrw(SFRIFG1, SFRIFG1_);
sfrb(SFRIFG1_L, SFRIFG1_L_);
sfrb(SFRIFG1_H, SFRIFG1_H_);

#define SFRRPCR1_           __MSP430_SFR_BASE__ + 0x04  /* Reset Pin Control */
#define SFRRPCR1_L_         SFRRPCR1_
#define SFRRPCR1_H_         SFRRPCR1_ + 0x01
sfrw(SFRRPCR1, SFRRPCR1_);
sfrb(SFRRPCR1_L, SFRRPCR1_L_);
sfrb(SFRRPCR1_H, SFRRPCR1_H_);

/* SFRIE1 Control Bits */
#define WDTIE                  (0x0001)       /* Watchdog timer interrupt enable */
#define OFIE                   (0x0002)       /* Oscillator fault interrupt enable */
#define VMAIE                  (0x0008)       /* Vacant memory access interrupt enable */
#define NMIIE                  (0x0010)       /* NMI pin interrupt enable */
#define ACCVIE                 (0x0020)       /* Flash controller access violation interrupt enable */
#define JMBINIE                (0x0040)       /* JTAG mailbox input interrupt enable */
#define JMBOUTIE               (0x0080)       /* JTAG mailbox output interrupt enable */

/* SFRIFG1 Control Bits */
#define WDTIFG                 (0x0001)       /* Watchdog timer interrupt flag */
#define OFIFG                  (0x0002)       /* Oscillator fault interrupt flag */
#define VMAIFG                 (0x0008)       /* Vacant memory access interrupt flag */
#define NMIIFG                 (0x0010)       /* NMI pin interrupt flag */
#define JMBINIFG               (0x0040)       /* JTAG mailbox input interrupt flag */
#define JMBOUTIFG              (0x0080)       /* JTAG mailbox output interrupt flag */

/* SFRRPCR Control Bits */
#define SYSNMI                 (0x0001)       /* NMI select */
#define SYSNMIIES              (0x0002)       /* NMI edge select */
#define SYSRSTUP               (0x0004)       /* Reset resistor pin pullup/pulldown */
#define SYSRSTRE               (0x0008)       /* Reset pin resistor enable */

/* Compatibility values for byte access */

#define WDTIE_L WDTIE
#define OFIE_L OFIE
#define VMAIE_L VMAIE
#define NMIIE_L NMIIE
#define ACCVIE_L ACCVIE
#define JMBINIE_L JMBINIE
#define JMBOUTIE_L JMBOUTIE
#define WDTIFG_L WDTIFG
#define OFIFG_L OFIFG
#define VMAIFG_L VMAIFG
#define NMIIFG_L NMIIFG
#define JMBINIFG_L JMBINIFG
#define JMBOUTIFG_L JMBOUTIFG
#define SYSNMI_L SYSNMI
#define SYSNMIIES_L SYSNMIIES
#define SYSRSTUP_L SYSRSTUP
#define SYSRSTRE_L SYSRSTRE

#endif /* __MSP430_SFR_BASE__ */

#endif /* __MSP430_HEADERS_SFR_H__ */
