/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 1999-2004 Ryan Bobko
                       ryan@ostrich-emulators.com

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
*************************** * * * * * * * * * * * * **************************/

#ifndef _RESULTSET_H
#define _RESULTSET_H

#include "qhaccconstants.h"

#include <vector>
using namespace std;

class TableCol;
class TableRow;
class QHaccDBPlugin;

class QHaccResultSet{
 public:
	QHaccResultSet( int cols =0, const ColType * =0, uint init=5, uint growby=5 );
	QHaccResultSet( const QHaccResultSet& );
	QHaccResultSet& operator=( const QHaccResultSet& );
	QHaccResultSet& operator+=( const TableRow& );
	QHaccResultSet& operator+=( const QHaccResultSet& );
	const TableRow& operator[]( uint ) const;
	virtual ~QHaccResultSet();

	virtual void loadRow( const QString& );
	virtual bool load( const QHaccResultSet * );
	void startLoad( uint =0 );
	virtual void stopLoad();

	const TableRow& at( uint idx ) const;
	virtual int add( const TableRow& );

	uint rows() const;
	uint trows() const;
	uint columns() const;
	bool isEmpty() const;
	
	ColType coltype( int ) const;

	static const int VALID;
	static const int COLCOUNT;
	static const int UNKNOWN;
	static const int LOWERROR;
	const char * error( int code ) const;

 protected:
	virtual void iadd( uint pos );
	virtual void iresize();
	virtual void istopLoad();
	virtual void istartLoad( uint );

	virtual int verifyRow( const TableRow& ) const;
	virtual const char * newerror( int code ) const;
	static const char * ERRORS[];

	int cols;
	bool deleter;
	//uint size, capacity, growBy; // how many rows? how big an array? growth?
	ColType * types;
	//TableRow ** data;
	vector<TableRow *>data;

	void resizeTo( uint );
};

#endif
