
#ifndef _SCHRO_BITSTREAM_H_
#define _SCHRO_BITSTREAM_H_

#include <schroedinger/schroutils.h>

SCHRO_BEGIN_DECLS

#define SCHRO_N_WAVELETS 7

typedef enum _SchroParseCode {
  SCHRO_PARSE_CODE_SEQUENCE_HEADER = 0x00,
  SCHRO_PARSE_CODE_END_OF_SEQUENCE = 0x10,
  SCHRO_PARSE_CODE_AUXILIARY_DATA = 0x20,
  SCHRO_PARSE_CODE_PADDING = 0x30,

  SCHRO_PARSE_CODE_INTRA_REF = 0x0c,
  SCHRO_PARSE_CODE_INTRA_NON_REF = 0x08,
  SCHRO_PARSE_CODE_INTRA_REF_NOARITH = 0x4c,
  SCHRO_PARSE_CODE_INTRA_NON_REF_NOARITH = 0x48,

  SCHRO_PARSE_CODE_INTER_REF_1 = 0x0d,
  SCHRO_PARSE_CODE_INTER_REF_1_NOARITH = 0x4d,
  SCHRO_PARSE_CODE_INTER_REF_2 = 0x0e,
  SCHRO_PARSE_CODE_INTER_REF_2_NOARITH = 0x4e,

  SCHRO_PARSE_CODE_INTER_NON_REF_1 = 0x09,
  SCHRO_PARSE_CODE_INTER_NON_REF_1_NOARITH = 0x49,
  SCHRO_PARSE_CODE_INTER_NON_REF_2 = 0x0a,
  SCHRO_PARSE_CODE_INTER_NON_REF_2_NOARITH = 0x4a,

  SCHRO_PARSE_CODE_LD_INTRA_REF = 0xcc,
  SCHRO_PARSE_CODE_LD_INTRA_NON_REF = 0xc8
} SchroParseCode;

#define SCHRO_PARSE_CODE_PICTURE(is_ref,n_refs,is_lowdelay,is_noarith) \
  (8 | ((is_ref)<<2) | (n_refs) | ((is_lowdelay)<<7) | ((is_noarith)<<6))

#define SCHRO_PARSE_CODE_IS_SEQ_HEADER(x) ((x) == SCHRO_PARSE_CODE_SEQUENCE_HEADER)
#define SCHRO_PARSE_CODE_IS_END_OF_SEQUENCE(x) ((x) == SCHRO_PARSE_CODE_END_OF_SEQUENCE)
#define SCHRO_PARSE_CODE_IS_AUXILIARY_DATA(x) ((x) == SCHRO_PARSE_CODE_AUXILIARY_DATA)
#define SCHRO_PARSE_CODE_IS_PADDING(x) ((x) == SCHRO_PARSE_CODE_PADDING)
#define SCHRO_PARSE_CODE_IS_PICTURE(x) ((x) & 0x8)
#define SCHRO_PARSE_CODE_IS_LOW_DELAY(x) (((x) & 0x88) == 0x88)
#define SCHRO_PARSE_CODE_IS_CORE_SYNTAX(x) (((x) & 0x88) == 0x08)
#define SCHRO_PARSE_CODE_USING_AC(x) (((x) & 0x48) == 0x08)
#define SCHRO_PARSE_CODE_IS_REFERENCE(x) (((x) & 0xc) == 0x0c)
#define SCHRO_PARSE_CODE_IS_NON_REFERENCE(x) (((x) & 0xc) == 0x08)
#define SCHRO_PARSE_CODE_NUM_REFS(x) ((x) & 0x3)
#define SCHRO_PARSE_CODE_IS_INTRA(x) (SCHRO_PARSE_CODE_IS_PICTURE(x) && SCHRO_PARSE_CODE_NUM_REFS(x) == 0)
#define SCHRO_PARSE_CODE_IS_INTER(x) (SCHRO_PARSE_CODE_IS_PICTURE(x) && SCHRO_PARSE_CODE_NUM_REFS(x) > 0)

#define SCHRO_PARSE_HEADER_SIZE (4+1+4+4)

typedef enum _SchroVideoFormatEnum {
  SCHRO_VIDEO_FORMAT_CUSTOM = 0,
  SCHRO_VIDEO_FORMAT_QSIF,
  SCHRO_VIDEO_FORMAT_QCIF,
  SCHRO_VIDEO_FORMAT_SIF,
  SCHRO_VIDEO_FORMAT_CIF,
  SCHRO_VIDEO_FORMAT_4SIF,
  SCHRO_VIDEO_FORMAT_4CIF,
  SCHRO_VIDEO_FORMAT_SD480I_60,
  SCHRO_VIDEO_FORMAT_SD576I_50,
  SCHRO_VIDEO_FORMAT_HD720P_60,
  SCHRO_VIDEO_FORMAT_HD720P_50,
  SCHRO_VIDEO_FORMAT_HD1080I_60,
  SCHRO_VIDEO_FORMAT_HD1080I_50,
  SCHRO_VIDEO_FORMAT_HD1080P_60,
  SCHRO_VIDEO_FORMAT_HD1080P_50,
  SCHRO_VIDEO_FORMAT_DC2K_24,
  SCHRO_VIDEO_FORMAT_DC4K_24
} SchroVideoFormatEnum;

typedef enum _SchroChromaFormat {
  SCHRO_CHROMA_444 = 0,
  SCHRO_CHROMA_422,
  SCHRO_CHROMA_420
} SchroChromaFormat;

#define SCHRO_CHROMA_FORMAT_H_SHIFT(format) (((format) == SCHRO_CHROMA_444)?0:1)
#define SCHRO_CHROMA_FORMAT_V_SHIFT(format) (((format) == SCHRO_CHROMA_420)?1:0)

typedef enum _SchroSignalRange {
  SCHRO_SIGNAL_RANGE_CUSTOM = 0,
  SCHRO_SIGNAL_RANGE_8BIT_FULL = 1,
  SCHRO_SIGNAL_RANGE_8BIT_VIDEO = 2,
  SCHRO_SIGNAL_RANGE_10BIT_VIDEO = 3,
  SCHRO_SIGNAL_RANGE_12BIT_VIDEO = 4
} SchroSignalRange;

typedef enum _SchroColourSpec {
  SCHRO_COLOUR_SPEC_CUSTOM = 0,
  SCHRO_COLOUR_SPEC_SDTV_525 = 1,
  SCHRO_COLOUR_SPEC_SDTV_625 = 2,
  SCHRO_COLOUR_SPEC_HDTV = 3,
  SCHRO_COLOUR_SPEC_CINEMA = 4
} SchroColourSpec;

typedef enum _SchroColourPrimaries {
  SCHRO_COLOUR_PRIMARY_HDTV = 0,
  SCHRO_COLOUR_PRIMARY_SDTV_525 = 1,
  SCHRO_COLOUR_PRIMARY_SDTV_625 = 2,
  SCHRO_COLOUR_PRIMARY_CINEMA = 3
} SchroColourPrimaries;

typedef enum _SchroColourMatrix {
  SCHRO_COLOUR_MATRIX_HDTV = 0,
  SCHRO_COLOUR_MATRIX_SDTV = 1,
  SCHRO_COLOUR_MATRIX_REVERSIBLE = 2
}SchroColourMatrix;

typedef enum _SchroTransferFunction {
  SCHRO_TRANSFER_CHAR_TV_GAMMA = 0,
  SCHRO_TRANSFER_CHAR_EXTENDED_GAMUT = 1,
  SCHRO_TRANSFER_CHAR_LINEAR = 2,
  SCHRO_TRANSFER_CHAR_DCI_GAMMA = 3
} SchroTransferFunction;

typedef enum _SchroWaveletIndex {
  SCHRO_WAVELET_DESLAURIERS_DUBUC_9_7,
  SCHRO_WAVELET_LE_GALL_5_3,
  SCHRO_WAVELET_DESLAURIERS_DUBUC_13_7,
  SCHRO_WAVELET_HAAR_0,
  SCHRO_WAVELET_HAAR_1,
  SCHRO_WAVELET_FIDELITY,
  SCHRO_WAVELET_DAUBECHIES_9_7
} SchroWaveletIndex;

#ifndef SCHRO_DISABLE_DEPRECATED
/* misspellings in older versions */
#define SCHRO_WAVELET_DESLAURIES_DUBUC_9_7 SCHRO_WAVELET_DESLAURIERS_DUBUC_9_7
#define SCHRO_WAVELET_DESLAURIES_DUBUC_13_7 SCHRO_WAVELET_DESLAURIERS_DUBUC_13_7
#endif

typedef enum _SchroAuxiliaryDataID {
  SCHRO_AUX_DATA_INVALID,
  SCHRO_AUX_DATA_ENCODER_STRING,
  SCHRO_AUX_DATA_SMPTE_12M_TIMECODE,
  SCHRO_AUX_DATA_MD5_CHECKSUM,
  SCHRO_AUX_DATA_BITRATE,
  SCHRO_AUX_DATA_USER = 0x80
}SchroAuxiliaryDataID;

typedef enum _SchroProfile {
  SCHRO_PROFILE_LOW_DELAY = 0,
  SCHRO_PROFILE_SIMPLE = 1,
  SCHRO_PROFILE_MAIN_INTRA = 2,
  SCHRO_PROFILE_MAIN = 8
} SchroProfile;

SCHRO_END_DECLS

#endif

