/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.appletviewer;

import gnu.classpath.tools.appletviewer.AppletTag;
import gnu.classpath.tools.appletviewer.Main;
import gnu.classpath.tools.appletviewer.StandaloneAppletWindow;
import gnu.classpath.tools.appletviewer.TagParser;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

class StandaloneAppletViewer
extends Main {
    static ArrayList appletTags = new ArrayList();
    static ArrayList appletWindows = new ArrayList();

    StandaloneAppletViewer(String[] stringArray) throws MalformedURLException, IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            TagParser tagParser = new TagParser(stringArray[i]);
            appletTags.addAll(tagParser.parseAppletTags());
        }
        this.printTags();
        this.createWindows();
    }

    StandaloneAppletViewer(String string, String string2, String string3, List list, Dimension dimension) throws IOException {
        Object object;
        if (!string.equals("") && !string.endsWith(".class")) {
            System.err.println("appletviewer: option '--code' requires a class filename");
            System.exit(1);
        }
        String string4 = "<EMBED CODE=\"" + string + "\"" + " WIDTH=" + dimension.width + " HEIGHT=" + dimension.height + " CODEBASE=\"" + string2 + "\"" + " ARCHIVE=\"" + string3 + "\">";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = new StringTokenizer((String)iterator.next(), ",");
            string4 = string4 + new StringBuffer("<PARAM NAME=").append(((StringTokenizer)object).nextToken().trim()).append(" VALUE=").append(((StringTokenizer)object).nextToken().trim()).append(">");
        }
        string4 = string4 + "</EMBED>";
        object = new StringReader(string4);
        String string5 = System.getProperty("user.dir") + File.separator;
        TagParser tagParser = new TagParser((Reader)object, new URL("file", "", string5));
        appletTags.addAll(tagParser.parseAppletTags());
        this.printTags();
        this.createWindows();
    }

    void printTags() {
        if (Main.verbose) {
            System.out.println("parsed applet tags:");
            for (int i = 0; i < appletTags.size(); ++i) {
                AppletTag appletTag = (AppletTag)appletTags.get(i);
                System.out.println(" tag " + i + ":");
                System.out.println(appletTag);
            }
        }
    }

    void createWindows() {
        for (int i = 0; i < appletTags.size(); ++i) {
            AppletTag appletTag = (AppletTag)appletTags.get(i);
            new StandaloneAppletWindow(appletTag, appletWindows);
        }
    }
}

