/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import gnu.classpath.NotImplementedException;
import java.io.IOException;
import java.io.UTFDataFormatException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.imageio.stream.ImageOutputStream;

public abstract class ImageOutputStreamImpl
extends ImageInputStreamImpl
implements ImageOutputStream {
    protected final void flushBits() throws IOException, NotImplementedException {
        throw new Error("not implemented");
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public abstract void write(int var1) throws IOException;

    public void writeBit(int n) throws IOException, NotImplementedException {
        throw new Error("not implemented");
    }

    public void writeBits(long l, int n) throws IOException, NotImplementedException {
        throw new Error("not implemented");
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.writeByte(bl ? 1 : 0);
    }

    public void writeByte(int n) throws IOException {
        this.write(n & 0xFF);
    }

    public void writeBytes(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeByte(string.charAt(i));
        }
    }

    public void writeChar(int n) throws IOException {
        this.writeShort(n);
    }

    public void writeChars(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            this.writeChar(cArray[n + n3]);
            ++n2;
        }
    }

    public void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeDoubles(double[] dArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            this.writeDouble(dArray[n + n3]);
            ++n2;
        }
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeFloats(float[] fArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            this.writeFloat(fArray[n + n3]);
            ++n2;
        }
    }

    public void writeInt(int n) throws IOException {
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            this.buffer[0] = (byte)n;
            this.buffer[1] = (byte)(n >> 8);
            this.buffer[2] = (byte)(n >> 16);
            this.buffer[3] = (byte)(n >> 24);
        } else {
            this.buffer[0] = (byte)(n >> 24);
            this.buffer[1] = (byte)(n >> 16);
            this.buffer[2] = (byte)(n >> 8);
            this.buffer[3] = (byte)n;
        }
        this.write(this.buffer, 0, 4);
    }

    public void writeInts(int[] nArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            this.writeInt(nArray[n + n3]);
            ++n2;
        }
    }

    public void writeLong(long l) throws IOException {
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            this.buffer[0] = (byte)l;
            this.buffer[1] = (byte)(l >> 8);
            this.buffer[2] = (byte)(l >> 16);
            this.buffer[3] = (byte)(l >> 24);
            this.buffer[4] = (byte)(l >> 32);
            this.buffer[5] = (byte)(l >> 40);
            this.buffer[6] = (byte)(l >> 48);
            this.buffer[7] = (byte)(l >> 56);
        } else {
            this.buffer[0] = (byte)(l >> 56);
            this.buffer[1] = (byte)(l >> 48);
            this.buffer[2] = (byte)(l >> 40);
            this.buffer[3] = (byte)(l >> 32);
            this.buffer[4] = (byte)(l >> 24);
            this.buffer[5] = (byte)(l >> 16);
            this.buffer[6] = (byte)(l >> 8);
            this.buffer[7] = (byte)l;
        }
        this.write(this.buffer, 0, 8);
    }

    public void writeLongs(long[] lArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            this.writeLong(lArray[n + n3]);
            ++n2;
        }
    }

    public void writeShort(int n) throws IOException {
        if (this.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
            this.buffer[0] = (byte)n;
            this.buffer[1] = (byte)(n >> 8);
        } else {
            this.buffer[0] = (byte)(n >> 8);
            this.buffer[1] = (byte)n;
        }
        this.write(this.buffer, 0, 2);
    }

    public void writeShorts(short[] sArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            this.writeShort(sArray[n + n3]);
            ++n2;
        }
    }

    public void writeUTF(String string) throws IOException {
        int n;
        int n2 = string.length();
        int n3 = 0;
        for (n = 0; n < n2 && n3 <= 65535; ++n) {
            char c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n3;
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                n3 += 2;
                continue;
            }
            n3 += 3;
        }
        if (n3 > 65535) {
            throw new UTFDataFormatException();
        }
        n = 0;
        byte[] byArray = new byte[n3];
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n++] = (byte)c;
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                byArray[n++] = (byte)(c >> 6) & 0x1F | 0xFFFFFFC0;
                byArray[n++] = (byte)c & 0x3F | 0xFFFFFF80;
                continue;
            }
            byArray[n++] = (byte)(c >> 12) & 0xF | 0xFFFFFFE0;
            byArray[n++] = (byte)(c >> 6) & 0x3F | 0xFFFFFF80;
            byArray[n++] = (byte)c & 0x3F | 0xFFFFFF80;
        }
        this.writeShort(n3);
        this.write(byArray, 0, n3);
    }
}

