/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicSplitPaneUI;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BasicSplitPaneDivider
extends Container
implements PropertyChangeListener {
    static final long serialVersionUID = 1463404307042803342L;
    protected static final int ONE_TOUCH_SIZE = 6;
    protected static final int ONE_TOUCH_OFFSET = 2;
    protected DragController dragger;
    protected BasicSplitPaneUI splitPaneUI;
    protected int dividerSize;
    protected Component hiddenDivider;
    protected JSplitPane splitPane;
    protected MouseHandler mouseHandler;
    protected int orientation;
    protected JButton leftButton;
    protected JButton rightButton;
    private Border border;
    transient int currentDividerLocation;

    public void setBasicSplitPaneUI(BasicSplitPaneUI basicSplitPaneUI) {
        if (this.splitPane != null) {
            this.splitPane.removePropertyChangeListener(this);
            this.removeMouseListener(this.mouseHandler);
            this.removeMouseMotionListener(this.mouseHandler);
            this.splitPane = null;
            this.hiddenDivider = null;
        }
        this.splitPaneUI = basicSplitPaneUI;
        if (this.splitPaneUI != null) {
            this.splitPane = basicSplitPaneUI.getSplitPane();
        }
        if (this.splitPane != null) {
            this.splitPane.addPropertyChangeListener(this);
            this.addMouseListener(this.mouseHandler);
            this.addMouseMotionListener(this.mouseHandler);
            this.hiddenDivider = this.splitPaneUI.getNonContinuousLayoutDivider();
            this.orientation = this.splitPane.getOrientation();
            this.oneTouchExpandableChanged();
        }
    }

    public BasicSplitPaneUI getBasicSplitPaneUI() {
        return this.splitPaneUI;
    }

    public void setDividerSize(int n) {
        this.dividerSize = n;
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setBorder(Border border) {
        if (border != this.border) {
            Border border2 = this.border;
            this.border = border;
            this.firePropertyChange("border", border2, border);
        }
    }

    public Border getBorder() {
        return this.border;
    }

    public Insets getInsets() {
        if (this.border != null) {
            return this.border.getBorderInsets(this);
        }
        return super.getInsets();
    }

    public Dimension getPreferredSize() {
        return this.getLayout().preferredLayoutSize(this);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("oneTouchExpandable")) {
            this.oneTouchExpandableChanged();
        } else if (propertyChangeEvent.getPropertyName().equals("orientation")) {
            this.orientation = this.splitPane.getOrientation();
            if (this.splitPane.isOneTouchExpandable()) {
                this.layout();
                this.repaint();
            }
        } else if (propertyChangeEvent.getPropertyName().equals("dividerSize")) {
            this.dividerSize = this.splitPane.getDividerSize();
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.border != null) {
            Dimension dimension = this.getSize();
            this.border.paintBorder(this, graphics, 0, 0, dimension.width, dimension.height);
        }
        if (this.splitPane.isOneTouchExpandable()) {
            ((BasicArrowButton)this.rightButton).paint(graphics);
            ((BasicArrowButton)this.leftButton).paint(graphics);
        }
    }

    protected void oneTouchExpandableChanged() {
        if (this.splitPane.isOneTouchExpandable()) {
            this.leftButton = this.createLeftOneTouchButton();
            this.rightButton = this.createRightOneTouchButton();
            this.add(this.leftButton);
            this.add(this.rightButton);
            this.leftButton.addMouseListener(this.mouseHandler);
            this.rightButton.addMouseListener(this.mouseHandler);
            this.currentDividerLocation = 1;
        } else if (this.leftButton != null && this.rightButton != null) {
            this.leftButton.removeMouseListener(this.mouseHandler);
            this.rightButton.removeMouseListener(this.mouseHandler);
            this.remove(this.leftButton);
            this.remove(this.rightButton);
            this.leftButton = null;
            this.rightButton = null;
        }
        this.layout();
        this.repaint();
    }

    protected JButton createLeftOneTouchButton() {
        int n = 7;
        if (this.orientation == 0) {
            n = 1;
        }
        BasicArrowButton basicArrowButton = new BasicArrowButton(n);
        basicArrowButton.setBorder(null);
        return basicArrowButton;
    }

    protected JButton createRightOneTouchButton() {
        int n = 3;
        if (this.orientation == 0) {
            n = 5;
        }
        BasicArrowButton basicArrowButton = new BasicArrowButton(n);
        basicArrowButton.setBorder(null);
        return basicArrowButton;
    }

    protected void prepareForDragging() {
        if (this.splitPaneUI != null) {
            this.splitPaneUI.startDragging();
        }
    }

    protected void dragDividerTo(int n) {
        if (this.splitPaneUI != null) {
            this.splitPaneUI.dragDividerTo(n);
        }
    }

    protected void finishDraggingTo(int n) {
        if (this.splitPaneUI != null) {
            this.splitPaneUI.finishDraggingTo(n);
        }
    }

    void moveDividerTo(int n) {
        Insets insets = this.splitPane.getInsets();
        switch (n) {
            case 1: {
                this.splitPane.setDividerLocation(this.splitPane.getLastDividerLocation());
                break;
            }
            case 0: {
                int n2 = this.orientation == 1 ? insets.left : insets.top;
                this.splitPane.setDividerLocation(n2);
                break;
            }
            case 2: {
                int n3 = this.orientation == 1 ? this.splitPane.getBounds().width - insets.right - this.dividerSize : this.splitPane.getBounds().height - insets.bottom - this.dividerSize;
                this.splitPane.setDividerLocation(n3);
                break;
            }
        }
    }

    private final /* synthetic */ void this() {
        this.mouseHandler = new MouseHandler();
        this.currentDividerLocation = 1;
    }

    public BasicSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
        this.this();
        this.setLayout(new DividerLayout());
        this.setBasicSplitPaneUI(basicSplitPaneUI);
        this.setDividerSize(this.splitPane.getDividerSize());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private transient boolean isDragging;

        public void mousePressed(MouseEvent mouseEvent) {
            if (BasicSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                if (mouseEvent.getSource() == BasicSplitPaneDivider.this.leftButton) {
                    --BasicSplitPaneDivider.this.currentDividerLocation;
                    if (BasicSplitPaneDivider.this.currentDividerLocation < 0) {
                        BasicSplitPaneDivider.this.currentDividerLocation = 0;
                    }
                    BasicSplitPaneDivider.this.moveDividerTo(BasicSplitPaneDivider.this.currentDividerLocation);
                    return;
                }
                if (mouseEvent.getSource() == BasicSplitPaneDivider.this.rightButton) {
                    ++BasicSplitPaneDivider.this.currentDividerLocation;
                    if (BasicSplitPaneDivider.this.currentDividerLocation > 2) {
                        BasicSplitPaneDivider.this.currentDividerLocation = 2;
                    }
                    BasicSplitPaneDivider.this.moveDividerTo(BasicSplitPaneDivider.this.currentDividerLocation);
                    return;
                }
            }
            this.isDragging = true;
            BasicSplitPaneDivider.this.currentDividerLocation = 1;
            BasicSplitPaneDivider.this.dragger = BasicSplitPaneDivider.this.orientation == 1 ? new DragController(mouseEvent) : new VerticalDragController(mouseEvent);
            BasicSplitPaneDivider.this.prepareForDragging();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.isDragging) {
                BasicSplitPaneDivider.this.dragger.completeDrag(mouseEvent);
            }
            this.isDragging = false;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (BasicSplitPaneDivider.this.dragger != null) {
                BasicSplitPaneDivider.this.dragger.continueDrag(mouseEvent);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        protected MouseHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class DividerLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            if (BasicSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                this.changeButtonOrientation();
                this.positionButtons();
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(BasicSplitPaneDivider.this.dividerSize, BasicSplitPaneDivider.this.dividerSize);
        }

        public void removeLayoutComponent(Component component) {
        }

        private final void changeButtonOrientation() {
            if (BasicSplitPaneDivider.this.orientation == 1) {
                ((BasicArrowButton)BasicSplitPaneDivider.this.rightButton).setDirection(3);
                ((BasicArrowButton)BasicSplitPaneDivider.this.leftButton).setDirection(7);
            } else {
                ((BasicArrowButton)BasicSplitPaneDivider.this.rightButton).setDirection(5);
                ((BasicArrowButton)BasicSplitPaneDivider.this.leftButton).setDirection(1);
            }
        }

        private final void positionButtons() {
            int n = 0;
            int n2 = 0;
            if (BasicSplitPaneDivider.this.orientation == 1) {
                BasicSplitPaneDivider.this.rightButton.setLocation(2, 2);
                BasicSplitPaneDivider.this.leftButton.setLocation(2, 14);
                n = BasicSplitPaneDivider.this.dividerSize - 4;
                n2 = 12;
            } else {
                BasicSplitPaneDivider.this.leftButton.setLocation(2, 2);
                BasicSplitPaneDivider.this.rightButton.setLocation(14, 2);
                n2 = BasicSplitPaneDivider.this.dividerSize - 4;
                n = 12;
            }
            Dimension dimension = new Dimension(n, n2);
            BasicSplitPaneDivider.this.leftButton.setSize(dimension);
            BasicSplitPaneDivider.this.rightButton.setSize(dimension);
        }

        protected DividerLayout() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class VerticalDragController
    extends DragController {
        protected int getNeededLocation(int n, int n2) {
            return n2;
        }

        protected int positionForMouseEvent(MouseEvent mouseEvent) {
            return mouseEvent.getY() + BasicSplitPaneDivider.this.getY() - this.offset;
        }

        int adjust(int n, int n2) {
            return this.getNeededLocation(n, n2) + BasicSplitPaneDivider.this.getY() - this.offset;
        }

        protected VerticalDragController(MouseEvent mouseEvent) {
            super(mouseEvent);
            this.offset = mouseEvent.getY();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class DragController {
        transient int offset;

        protected boolean isValid() {
            return true;
        }

        protected int positionForMouseEvent(MouseEvent mouseEvent) {
            return mouseEvent.getX() + BasicSplitPaneDivider.this.getX() - this.offset;
        }

        protected int getNeededLocation(int n, int n2) {
            return n;
        }

        protected void continueDrag(int n, int n2) {
            if (this.isValid()) {
                BasicSplitPaneDivider.this.dragDividerTo(this.adjust(n, n2));
            }
        }

        protected void continueDrag(MouseEvent mouseEvent) {
            if (this.isValid()) {
                BasicSplitPaneDivider.this.dragDividerTo(this.positionForMouseEvent(mouseEvent));
            }
        }

        protected void completeDrag(int n, int n2) {
            BasicSplitPaneDivider.this.finishDraggingTo(this.adjust(n, n2));
        }

        protected void completeDrag(MouseEvent mouseEvent) {
            BasicSplitPaneDivider.this.finishDraggingTo(this.positionForMouseEvent(mouseEvent));
        }

        int adjust(int n, int n2) {
            return this.getNeededLocation(n, n2) + BasicSplitPaneDivider.this.getX() - this.offset;
        }

        protected DragController(MouseEvent mouseEvent) {
            this.offset = mouseEvent.getX();
        }
    }
}

