%% Generated by lilypond-book.py
%% Options: [indent=0\mm,verbatim,doctitle,alt=[image of music],texidoc,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************



\paper {
  #(define dump-extents #t)
  
  indent = 0\mm
  line-width = 160\mm
  force-assignment = #""
  line-width = #(- line-width (* mm  3.000000))
}

\layout {
  
}



% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "controlling-tuplet-bracket-visibility.ly"
\sourcefileline 0
%% Do not edit this file; it is auto-generated from LSR http://lsr.dsi.unimi.it
%% This file is in the public domain.
\version "2.12.3"

\header {
  lsrtags = "rhythms, tweaks-and-overrides"

  texidoc = "
The default behavior of tuplet-bracket visibility is to print a bracket
unless there is a beam of the same length as the tuplet. To control the
visibility of tuplet brackets, set the property
@code{'bracket-visibility} to either @code{#t} (always print a
bracket), @code{#f} (never print a bracket) or @code{#'if-no-beam}
(only print a bracket if there is no beam). 

"
  doctitle = "Controlling tuplet bracket visibility"
} % begin verbatim

music = \relative c'' {
  \times 2/3 { c16[ d e } f8]
  \times 2/3 { c8 d e }
  \times 2/3 { c4 d e }
}

\new Voice {
  \relative c' {
    << \music s4^"default" >>
    \override TupletBracket #'bracket-visibility = #'if-no-beam
    << \music s4^"'if-no-beam" >>
    \override TupletBracket #'bracket-visibility = ##t
    << \music s4^"#t" >>
    \override TupletBracket #'bracket-visibility = ##f
    << \music s4^"#f" >>
  }
} 





% ****************************************************************
% end ly snippet
% ****************************************************************
