<?xml version='1.0'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="text" indent="no" encoding="ISO-8859-1"/>

<xsl:strip-space elements="*"/>

<xsl:template match="invitation">
<xsl:text>\documentclass[12pt]{article}
\usepackage{invitation}
\begin{document}
</xsl:text>
<xsl:apply-templates/>
<xsl:text>\end{document}
</xsl:text>
</xsl:template>

<xsl:template match="front">
<xsl:text>\begin{Front}
\To{</xsl:text>
<xsl:value-of select="to"/>
<xsl:text>}
\Date{</xsl:text>
<xsl:value-of select="date"/>
<xsl:text>}
\Where{</xsl:text>
<xsl:value-of select="where"/>
<xsl:text>}
\Why{</xsl:text>
<xsl:value-of select="why"/>
<xsl:text>}
\end{Front}
</xsl:text>
</xsl:template>

<xsl:template match="body">
<xsl:text>\begin{Body}
</xsl:text>
  <xsl:apply-templates/>
<xsl:text>
\end{Body}
</xsl:text>
</xsl:template>

<xsl:template match="par">
<xsl:text>
\par </xsl:text>
<xsl:apply-templates/>
</xsl:template>

<xsl:template match="emph">
<xsl:text>\emph{</xsl:text>
<xsl:apply-templates/>
<xsl:text>}</xsl:text>
</xsl:template>

<xsl:template match="back">
<xsl:text>\begin{Back}
\Signature{</xsl:text>
<xsl:value-of select="signature"/>
<xsl:text>}
\end{Back}
</xsl:text>
</xsl:template>

</xsl:stylesheet>
