/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl;

import gnu.java.security.der.DERReader;
import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import gnu.javax.crypto.mode.IMode;
import gnu.javax.crypto.mode.ModeFactory;
import gnu.javax.crypto.pad.WrongPaddingException;
import gnu.javax.net.ssl.Base64;
import gnu.javax.security.auth.callback.ConsoleCallbackHandler;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.ManagerFactoryParameters;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class PrivateCredentials
implements ManagerFactoryParameters {
    public static final String BEGIN_DSA = "-----BEGIN DSA PRIVATE KEY";
    public static final String END_DSA = "-----END DSA PRIVATE KEY";
    public static final String BEGIN_RSA = "-----BEGIN RSA PRIVATE KEY";
    public static final String END_RSA = "-----END RSA PRIVATE KEY";
    private List privateKeys = new LinkedList();
    private List certChains = new LinkedList();

    public void add(InputStream inputStream, InputStream inputStream2) throws CertificateException, InvalidKeyException, InvalidKeySpecException, IOException, NoSuchAlgorithmException, WrongPaddingException {
        DERReader dERReader;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Collection collection = certificateFactory.generateCertificates(inputStream);
        X509Certificate[] x509CertificateArray = (X509Certificate[])collection.toArray(new X509Certificate[0]);
        String string = null;
        String string2 = this.readLine(inputStream2);
        String string3 = null;
        if (string2.startsWith(BEGIN_DSA)) {
            string = "DSA";
            string3 = END_DSA;
        } else if (string2.startsWith(BEGIN_RSA)) {
            string = "RSA";
            string3 = END_RSA;
        } else {
            throw new IOException("Unknown private key type.");
        }
        boolean bl = false;
        String string4 = null;
        String string5 = null;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            if ((string2 = this.readLine(inputStream2)) == null) {
                throw new EOFException("premature end-of-file");
            }
            if (string2.startsWith("Proc-Type: 4,ENCRYPTED")) {
                bl = true;
                continue;
            }
            if (string2.startsWith("DEK-Info: ")) {
                int n = string2.indexOf(44);
                if (n < 0) {
                    string4 = string2.substring(10).trim();
                    continue;
                }
                string4 = string2.substring(10, n).trim();
                string5 = string2.substring(n + 1).trim();
                continue;
            }
            if (string2.startsWith(string3)) break;
            if (string2.length() <= 0) continue;
            stringBuffer.append(string2);
            stringBuffer.append(System.getProperty("line.separator"));
        }
        byte[] byArray = Base64.decode(stringBuffer.toString());
        if (bl) {
            byArray = this.decryptKey(byArray, string4, this.toByteArray(string5));
        }
        if ((dERReader = new DERReader(byArray)).read().getTag() != 16) {
            throw new IOException("malformed DER sequence");
        }
        dERReader.read();
        KeyFactory keyFactory = KeyFactory.getInstance(string);
        KeySpec keySpec = null;
        if (string.equals("DSA")) {
            BigInteger bigInteger = (BigInteger)dERReader.read().getValue();
            BigInteger bigInteger2 = (BigInteger)dERReader.read().getValue();
            BigInteger bigInteger3 = (BigInteger)dERReader.read().getValue();
            dERReader.read();
            BigInteger bigInteger4 = (BigInteger)dERReader.read().getValue();
            keySpec = new DSAPrivateKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3);
        } else {
            keySpec = new RSAPrivateCrtKeySpec((BigInteger)dERReader.read().getValue(), (BigInteger)dERReader.read().getValue(), (BigInteger)dERReader.read().getValue(), (BigInteger)dERReader.read().getValue(), (BigInteger)dERReader.read().getValue(), (BigInteger)dERReader.read().getValue(), (BigInteger)dERReader.read().getValue(), (BigInteger)dERReader.read().getValue());
        }
        this.privateKeys.add(keyFactory.generatePrivate(keySpec));
        this.certChains.add(x509CertificateArray);
    }

    public List getPrivateKeys() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("this object is destroyed");
        }
        return this.privateKeys;
    }

    public List getCertChains() {
        return this.certChains;
    }

    public void destroy() {
        this.privateKeys.clear();
        this.privateKeys = null;
    }

    public boolean isDestroyed() {
        return this.privateKeys == null;
    }

    private String readLine(InputStream inputStream) throws IOException {
        boolean bl = System.getProperty("line.separator").equals("\r");
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = inputStream.read()) == -1) {
                if (stringBuffer.length() > 0) break;
                return null;
            }
            if (n == 13) {
                if (!bl) continue;
                break;
            }
            if (n == 10) break;
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    private byte[] decryptKey(byte[] byArray, String string, byte[] byArray2) throws IOException, InvalidKeyException, WrongPaddingException {
        int n;
        HashMap hashMap;
        byte[] byArray3 = new byte[byArray.length];
        IMode iMode = null;
        if (string.equals("DES-EDE3-CBC")) {
            iMode = ModeFactory.getInstance("CBC", "TripleDES", 8);
            hashMap = new HashMap();
            hashMap.put("gnu.crypto.cipher.key.material", this.deriveKey(byArray2, 24));
            hashMap.put("gnu.crypto.mode.iv", byArray2);
            hashMap.put("gnu.crypto.mode.state", new Integer(2));
            iMode.init(hashMap);
        } else if (string.equals("DES-CBC")) {
            iMode = ModeFactory.getInstance("CBC", "DES", 8);
            hashMap = new HashMap();
            hashMap.put("gnu.crypto.cipher.key.material", this.deriveKey(byArray2, 8));
            hashMap.put("gnu.crypto.mode.iv", byArray2);
            hashMap.put("gnu.crypto.mode.state", new Integer(2));
            iMode.init(hashMap);
        } else {
            throw new IllegalArgumentException("unknown cipher: " + string);
        }
        for (n = 0; n < byArray.length; n += 8) {
            iMode.update(byArray, n, byArray3, n);
        }
        n = byArray3[byArray3.length - 1];
        if (n < 1 || n > 8) {
            throw new WrongPaddingException();
        }
        for (int i = byArray3.length - n; i < byArray3.length; ++i) {
            if (byArray3[i] == n) continue;
            throw new WrongPaddingException();
        }
        byte[] byArray4 = new byte[byArray3.length - n];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray4.length);
        return byArray4;
    }

    private byte[] deriveKey(byte[] byArray, int n) throws IOException {
        Serializable serializable;
        CallbackHandler callbackHandler = new ConsoleCallbackHandler();
        try {
            serializable = Class.forName(Security.getProperty("jessie.password.handler"));
            callbackHandler = (CallbackHandler)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        serializable = new PasswordCallback("Enter PEM passphrase: ", false);
        try {
            callbackHandler.handle(new Callback[]{serializable});
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new IOException("specified handler cannot handle passwords");
        }
        char[] cArray = ((PasswordCallback)serializable).getPassword();
        IMessageDigest iMessageDigest = HashFactory.getInstance("MD5");
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            for (int i = 0; i < cArray.length; ++i) {
                iMessageDigest.update((byte)cArray[i]);
            }
            iMessageDigest.update(byArray, 0, byArray.length);
            byte[] byArray3 = iMessageDigest.digest();
            int n3 = Math.min(byArray3.length, n - n2);
            System.arraycopy(byArray3, 0, byArray2, n2, n3);
            if ((n2 += n3) >= n) break;
            iMessageDigest.reset();
            iMessageDigest.update(byArray3, 0, byArray3.length);
        }
        ((PasswordCallback)serializable).clearPassword();
        return byArray2;
    }

    private byte[] toByteArray(String string) {
        string = string.toLowerCase();
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)(Character.digit(string.charAt(n++), 16) << 4) | (byte)Character.digit(string.charAt(n++), 16);
        }
        return byArray;
    }
}

