/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.SystemProperties;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.PropertyPermission;

public final class System {
    public static final InputStream in = new BufferedInputStream(new FileInputStream(FileDescriptor.in));
    public static final PrintStream out = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.out)), true);
    public static final PrintStream err = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.err)), true);

    private System() {
    }

    public static void setIn(InputStream inputStream) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setIO"));
        }
        System.setIn0(inputStream);
    }

    public static void setOut(PrintStream printStream) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setIO"));
        }
        System.setOut0(printStream);
    }

    public static void setErr(PrintStream printStream) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setIO"));
        }
        System.setErr0(printStream);
    }

    public static synchronized void setSecurityManager(SecurityManager securityManager) {
        if (SecurityManager.current != null) {
            SecurityManager.current.checkPermission(new RuntimePermission("setSecurityManager"));
        }
        SecurityManager.current = securityManager;
    }

    public static SecurityManager getSecurityManager() {
        return SecurityManager.current;
    }

    public static native long currentTimeMillis();

    public static native long nanoTime();

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    public static native int identityHashCode(Object var0);

    public static Properties getProperties() {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        return SystemProperties.getProperties();
    }

    public static void setProperties(Properties properties) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
        SystemProperties.setProperties(properties);
    }

    public static String getProperty(String string) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPropertyAccess(string);
        } else if (string.length() == 0) {
            throw new IllegalArgumentException("key can't be empty");
        }
        return SystemProperties.getProperty(string);
    }

    public static String getProperty(String string, String string2) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPropertyAccess(string);
        }
        return SystemProperties.getProperty(string, string2);
    }

    public static String setProperty(String string, String string2) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        return SystemProperties.setProperty(string, string2);
    }

    public static String getenv(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getenv." + string));
        }
        return System.getenv0(string);
    }

    public static void exit(int n) {
        Runtime.getRuntime().exit(n);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    public static void runFinalizersOnExit(boolean bl) {
        Runtime.getRuntime();
        Runtime.runFinalizersOnExit(bl);
    }

    public static void load(String string) {
        Runtime.getRuntime().load(string);
    }

    public static void loadLibrary(String string) {
        Runtime.getRuntime().loadLibrary(string);
    }

    public static String mapLibraryName(String string) {
        return Runtime.nativeGetLibname("", string);
    }

    private static native void setIn0(InputStream var0);

    private static native void setOut0(PrintStream var0);

    private static native void setErr0(PrintStream var0);

    static native String getenv0(String var0);
}

