ruleset (	// Adrian Mariano
	// from The Fractal Geometry of Nature by Mandelbrot

	Koch(n)	=> attr (delta, 360/6) F--F--F, n;
	F	=> F+F--F+F;
)

ruleset (	// Adrian Mariano
	// from The Fractal Geometry of Nature by Mandelbrot

	Koch1(n)	=> attr (delta, 360/12) F---F---F---F, n;
	F	=> -F+++F---F+;
)

ruleset (	// Adrian Mariano
	// from The Fractal Geometry of Nature by Mandelbrot

	Koch2(n)	=> attr (delta, 360/4) F-F-F-F, n;
	F	=> F-F+F+FF-F-F+F;
)

ruleset (	// Adrian Mariano
	Koch3(n)	=> attr (delta, 360/4) F+F+F+F, n;
	F	=> F-F F+F F+F+F-F-F F+F+F-F-F F-F F+F;

)

ruleset (	// Adrian Mariano
	// from The Fractal Geometry of Nature by Mandelbrot

	Dragon(n)	=> attr (delta, 360/8) FX, n;
	F	=> ;
	y	=> +FX--FY+;
	x	=> -FX++FY-;
)

ruleset (	// Adrian Mariano
	// from The Fractal Geometry of Nature by Mandelbrot

	Peano(n)	=> attr (delta, 360/4) F-F-F-F, n;
	F	=> F-F+F+F+F-F-F-F+F;
)

ruleset (	// Adrian Mariano
	// from The Fractal Geometry of Nature by Mandelbrot

	Cesaro(n)	=> attr (delta, 360/34) FX, n;
	F	=> ;
	X	=> ----F!X!++++++++F!X!----;
)

ruleset (	// Adrian Mariano
	// from The Fractal Geometry of Nature by Mandelbrot

	Double_cesaro(n)	=> attr (delta, 360/4) F -(90) F -(90) F -(90) F -(90) , n;
	F	=>  -(42) !F! +(84) !F! -(42) ;
)

ruleset (	// Adrian Mariano
	// from The Fractal Geometry of Nature by Mandelbrot
	anfle	=> 6;
	Flow_snake(n)	=> attr (delta, 360/4) FL, n;
	L	=> FL-FR--FR+FL++FLFL+FR-%,;
	R	=> +FL-FRFR--FR-FL++FL+FR%,;
	F	=> ;
)

ruleset (	// Adrian Mariano
	// from The Fractal Geometry of Nature by Mandelbrot

	Cantor_dust(n)	=> attr (delta, 360/6) F, n;
	F	=> FfF;
	f	=> fff;
)

ruleset (	// Adrian Mariano
	// from The Fractal Geometry of Nature by Mandelbrot

	Snowflake(n)	=> attr (delta, 360/12) F, n;
	F	=> ++!F!F--F--F attr (distance, distance/03^0.5) |+F!F--;
	F	=> F--F!+++ attr (distance, distance*03^0.5) F attr (distance, distance/03^0.5) |+F!F attr (distance, distance*03^0.5) |+F!F;
)

ruleset (	// Adrian Mariano
	// from The Fractal Geometry of Nature by Mandelbrot

	Snowflake_color(n)	=> attr (delta, 360/12) F, n;
	F	=> --!F!F++F++F attr (distance, distance/03^0.5) |-F!F++;
	F	=> F++F!--- attr (distance, distance*03^0.5) F attr (distance, distance/03^0.5) |-F!F attr (distance, distance*03^0.5) |-F!F;
	F	=> ;
)

ruleset (	// Adrian Mariano
	// from The Fractal Geometry of Nature by Mandelbrot

	Island(n)	=> attr (delta, 360/4) F+F+F+F, n;
	F	=> FFFF-F+F+F-F[-fFF+F+FF+F]FF;
	f	=>  attr (distance, distance*08) f attr (distance, distance/08) ;
)

ruleset (	// Adrian Mariano
	// from The Fractal Geometry of Nature by Mandelbrot

	Island1(n)	=> attr (delta, 360/4) F+F+F+F, n;
	F	=> F+f F-F F-F-F F+f+F F-f F+F F+F+F F-f-F FF;
	f	=>  attr (distance, distance*06) f attr (distance, distance/06) ;
)

ruleset (	// Adrian Mariano
	// from The Fractal Geometry of Nature by Mandelbrot

	Quartet(n)	=> attr (delta, 360/4) F b, n;
	A	=> FBFA+HFA+FB-FA;
	B	=> FB+FA-FB-JFBFA;
	F	=> ;
	H	=> -;
	J	=> +;
)

ruleset (	// Adrian Mariano
	// from The Fractal Geometry of Nature by Mandelbrot

	Snow_flake(n)	=> attr (delta, 360/12) FR, n;
	R	=> ++!FRFU++FU++FU!--- attr (distance, distance*03^0.5) FU|- attr (distance, distance/03^0.5) !FRFU!;
	U	=> !FRFU!|+ attr (distance, distance*03^0.5) FR attr (distance, distance/03^0.5) +++!FR--FR--FRFU!--;
	F	=> ;
)

ruleset (	// Adrian Mariano
	// from The Fractal Geometry of Nature by Mandelbrot

	Snow_flake1(n)	=> attr (delta, 360/12) F x, n;
	x	=> ++F!x!F y--F x--F y|+ attr (distance, distance/03^0.5) F yF!x!++F!y!++F!y!F x attr (distance, distance*03^0.5) +++F!y!F x;
	y	=> F yF!x!+++ attr (distance, distance/03^0.5) F yF!x!++F!x!++F!y!F x attr (distance, distance*03^0.5) |+F x--F y--F xF!y!++;
	F	=> ;
)

ruleset (	// Adrian Mariano
	// from The Fractal Geometry of Nature by Mandelbrot
	anfle	=> 12;
	Tree(n)	=> attr (delta, 360/12) +++FX, n;
	X	=>  attr (distance, distance*0.6) [-FX]+FX;
)

ruleset (	// Adrian Mariano
	// from The Fractal Geometry of Nature by Mandelbrot

	Peano1(n)	=> attr (delta, 360/8) FXY++F++FXY++F, n;
	X	=> XY attr (distance, distance*02^0.5) -F attr (distance, distance/02^0.5) -FXY++F++FXY;
	Y	=> - attr (distance, distance*02^0.5) F- attr (distance, distance/02^0.5) FXY;
)

ruleset (	// Adrian Mariano
	// from The Fractal Geometry of Nature by Mandelbrot

	Sierpinski(n)	=> attr (delta, 360/3) F, n;
	F	=> FXF;
	X	=> +FXF-FXF-FXF+;
)

ruleset (	// Adrian Mariano
	// from The Fractal Geometry of Nature by Mandelbrot

	Koch4(n)	=> attr (delta, 360/12) F++++F++++F, n;
	F	=> +F--F++F-;
)


ruleset (	// Ken Philip, from The Science of Fractal Images p.285b
	Plant(n)	=> attr (delta, 360/12) Z, n;
	z	=> zFX[+Z][-Z];
	x	=> x[-FFF][+FFF]FX;

)

ruleset (	// Ken Philip, from The Science of Fractal Images, p.286
	Plant1(n)	=> attr (delta, 360/14) SLFFF, n;
	s	=> [+++Z][---Z]TS;
	z	=> +H[-Z]L;
	h	=> -Z[+H]L;
	t	=> TL;
	l	=> [-FFF][+FFF]F;

)

ruleset (	// Ken Philip, from The Science of Fractal Images
	Hilbert(n)	=> attr (delta, 360/20) x, n;
	x	=> -YF+XFX+FY-;
	y	=> +XF-YFY-FX+;

)

ruleset (	// From Jim Hanan via Corbit
	Sierpinski1(n)	=> attr (delta, 360/4) F-F-F, n;
	F	=> F[-F]F;

)


ruleset (
	Peano2(n)	=> attr (delta, 360/3) x, n;
	x	=> XFYFX+F+YFXFY-F-XFYFX;
	y	=> YFXFY-F-XFYFX+F+YFXFY;

)

ruleset (
	Koch5(n)	=> attr (delta, 360/4) F+F+F+F, n;
	F	=> F+F-F-FFF+F+F-F;

)

ruleset (	// from The Science of Fractal Images
	Sierpinski2(n)	=> attr (delta, 360/4) FXF--FF--FF, n;
	F	=> FF;
	x	=> --FXF++FXF++FXF--;

)

ruleset (
	Sierpinski_square(n)	=> attr (delta, 360/6) F+F+F+F, n;
	F	=> FF+F+F+F+FF;

)


ruleset (	// created by Adrian Mariano

	Pentagram(n)	=> attr (delta, 360/10) F x++F x++F x++F x++F x, n;
	// f=f[++++@1.618033989f]
	x	=> [++++ attr (distance, distance/01.618033989) F attr (distance, distance*0.618033989) F!x! attr (distance, distance/0.618033989) F];
)


ruleset (	// Adrian Mariano, from the Algorithmic Beauty of Plants
	// Quadratic Koch island, Figure 1.7a p.9

	Quad_koch(n)	=> attr (delta, 360/4) F-F-F-F-, n;
	F	=> F+FF-FF-F-F+F+FF-F-F+F+FF+FF-F;
)

ruleset (	// Adrian Mariano, from the Algorithmic Beauty of Plants
	// FASS curve (3x3 tiles form macrotile), Figure 1.16a p.17
	Fass(n)	=> attr (delta, 360/4) -l, n;

	L	=> LF+RFR+FL-F-LFLFL-FRFR+;
	R	=> -LFLF+RFRFR+F+RF-LFL-FR;
)

ruleset (	// Adrian Mariano, from the Algorithmic Beauty of Plants
	// FASS curve (4x4 tiles form macrotile), Figure 1.16b p.17

	Fass1(n)	=> attr (delta, 360/4) -l, n;
	L	=> LFLF+RFR+FLFL-FRF-LFL-FR+F+RF-LFL-FRFRFR+;
	R	=> -LFLFLF+RFR+FL-F-LF+RFR+FLF+RFRF-LFL-FRFR;
)

ruleset (	// Adrian Mariano, from the Algorithmic Beauty of Plants
	// Quadratic Gosper curve, Figure 1.11b p.12

	Quad_gosper(n)	=> attr (delta, 360/4) -F r, n;
	l	=> F lF l-F r-F r+F l+F l-F r-F rF l+F r+F lF lF r-F l+F r+F lF l+F r-F lF r-F r-F l+F l+F rF r-;
	r	=> +F lF l-F r-F r+F l+F lF r+F l-F rF r-F l-F r+F lF rF r-F l-F rF l+F l+F r-F r-F l+F l+F rF r;
	F	=> ;
)

ruleset (	// Adrian Mariano, from the Algorithmic Beauty of Plants
	// Plant-like structure, figure 1.24a p.25
	// also p.285a The Science of Fractal Images

	Plant2(n)	=> attr (delta, 360/14) F, n;
	F	=> F[+F]F[-F]F;
)

ruleset (	// Adrian Mariano, from the Algorithmic Beauty of Plants
	// Plant-like structure, figure 1.24b p.25

	Plant3(n)	=> attr (delta, 360/18) F, n;
	F	=> F[+F]F[-F][F];
)

ruleset (	// Adrian Mariano, from the Algorithmic Beauty of Plants
	// Plant-like structure, figure 1.24c p.25

	Plant4(n)	=> attr (delta, 360/16) F, n;
	F	=> FF-[-F+F+F]+[+F-F-F];
)

ruleset (	// Adrian Mariano, from the Algorithmic Beauty of Plants
	// Plant-like structure, figure 1.24d p.25

	Plant5(n)	=> attr (delta, 360/18) x, n;
	X	=> F[+X]F[-X]+X;
	F	=> FF;
)

ruleset (	// Adrian Mariano, from the Algorithmic Beauty of Plants
	// Plant-like structure, figure 1.24e p.25

	Plant6(n)	=> attr (delta, 360/14) x, n;
	X	=> F[+X][-X]FX;
	F	=> FF;
)

ruleset (	// Adrian Mariano, from the Algorithmic Beauty of Plants
	// Plant-like structure, figure 1.24f p.25

	Plant7(n)	=> attr (delta, 360/16) x, n;
	X	=> F-[[X]+X]+F[+FX]-X;
	F	=> FF;
)

ruleset (	// Adrian Mariano
	Plant8(n)	=> attr (delta, 360/16) y, n;
	x	=> X[-FFF][+FFF]FX;
	y	=> YFX[+Y][-Y];

)

ruleset (	// Adrian Mariano
	Plant9(n)	=> attr (delta, 360/14) F, n;
	F	=> F[+F F][-F F]F[+F F][-F F]F;

)


ruleset (	// Adrian Mariano
	Plant10(n)	=> attr (delta, 360/10) F, n;
	F	=> F[+F[+F][-F]F][-F[+F][-F]F]F[+F][-F]F;

)

ruleset (	// Adrian Mariano, from the Algorithmic Beauty of Plants
	// curve from figure 1.9a p.10

	Curve(n)	=> attr (delta, 360/4) F-F-F-F-, n;
	F	=> FF-F-F-F-F-F+F;
)

ruleset (	// Adrian Mariano, from the Algorithmic Beauty of Plants

	Curve1(n)	=> attr (delta, 360/4) F-F-F-F-, n;
	F	=> FF-F+F-F-FF;
)

ruleset (	// Adrian Mariano, from the Algorithmic Beauty of Plants
	// curve from figure 1.9e p.10
	Curve2(n)	=> attr (delta, 360/4) F-F-F-F-, n;

	F	=> F-FF--F-F;
)

ruleset (	// Adrian Mariano
	Curve3(n)	=> attr (delta, 360/4) y F, n;
	x	=> YF+XF+Y;
	y	=> XF-YF-X;

)

ruleset (	// Adrian Mariano, from the Algorithmic Beauty of Plants
	// Compound leaf with alternating branches, Figure 5.12b p.130

	Leaf(n)	=> attr (delta, 360/8) x, n;
	a	=> n;
	n	=> o;
	o	=> p;
	p	=> x;
	b	=> e;
	e	=> h;
	h	=> j;
	j	=> y;
	x	=> F[+A(4)]F y;
	y	=> F[-B(4)]F x;
	F	=>  attr (distance, distance*01.18) F attr (distance, distance/01.18) ;
)

ruleset (	// Adrian Mariano, from the Algorithmic Beauty of Plants
	// Compound leaf with alternating branches, Figure 5.12a p.130

	Leaf1(n)	=> attr (delta, 360/8) a, n;
	a	=> F[+x]F b;
	b	=> F[-y]F a;
	x	=> a;
	y	=> b;
	F	=>  attr (distance, distance*01.36) F attr (distance, distance/01.36) ;
)

ruleset (	// Adrian Mariano

	Bush(n)	=> attr (delta, 360/16) ++++F, n;
	F	=> FF-[-F+F+F]+[+F-F-F];
)

ruleset (	// Adrian Mariano

	My_tree(n)	=> attr (delta, 360/16) ++++F, n;
	F	=> FF-[XY]+[XY];
	X	=> +FY;
	Y	=> -FX;
)

ruleset (	// Adrian Mariano

	Color_triang_gasket(n)	=> attr (delta, 360/6) --X, n;
	X	=> ++FXF++FXF++FXF;
	F	=> FF;
)

ruleset (	// Adrian Mariano

	Square_gasket(n)	=> attr (delta, 360/4) X, n;
	X	=> +FXF+FXF+FXF+FXF;
	F	=> FF;
)

ruleset (	// Adrian Mariano

	Dragon_curve(n)	=> attr (delta, 360/4) X, n;
	X	=> X-YF-;
	Y	=> +FX+Y;
)

ruleset (	// Adrian Mariano

	Square(n)	=> attr (delta, 360/4) F+F+F+F, n;
	F	=> FF+F+F+F+FF;
)

ruleset (	// Adrian Mariano

	Koch_curve(n)	=> attr (delta, 360/6) F, n;
	F	=> F+F--F+F;
)


ruleset (	// by Herb Savage
	// based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
	// Roger Penrose's rhombuses

	Penrose(n)	=> attr (delta, 360/10) +WF--XF---YF--ZF, n;
	W	=> YF++ZF----XF[-YF----WF]++;
	X	=> +YF--ZF[---WF--XF]+;
	Y	=> -WF++XF[+++YF++ZF]-;
	Z	=> --YF++++WF[+ZF++++XF]--XF;
	F	=> ;
)

ruleset (	// by Herb Savage
	// based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
	// Roger Penrose's rhombuses
	// Uses color to show the edge matching rules to force nonperiodicy

	Color_penrose(n)	=> attr (delta, 360/10) +WF--XF---YF--ZF, n;
	W	=> YF++ZF----XF[-YF----WF]++;
	X	=> +YF--ZF[---WF--XF]+;
	Y	=> -WF++XF[+++YF++ZF]-;
	Z	=> --YF++++WF[+ZF++++XF]--XF;
	F	=> ;
)

ruleset (	// by Herb Savage
	// based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
	// Roger Penrose's rhombuses

	Penrose1(n)	=> attr (delta, 360/10) ++ZF----XF-YF----WF, n;
	W	=> YF++ZF----XF[-YF----WF]++;
	X	=> +YF--ZF[---WF--XF]+;
	Y	=> -WF++XF[+++YF++ZF]-;
	Z	=> --YF++++WF[+ZF++++XF]--XF;
	F	=> ;
)

ruleset (	// by Herb Savage
	// based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
	// Roger Penrose's rhombuses

	Penrose2(n)	=> attr (delta, 360/10) [X]++[X]++[X]++[X]++[X], n;
	W	=> YF++ZF----XF[-YF----WF]++;
	X	=> +YF--ZF[---WF--XF]+;
	Y	=> -WF++XF[+++YF++ZF]-;
	Z	=> --YF++++WF[+ZF++++XF]--XF;
	F	=> ;
)

ruleset (	// by Herb Savage
	// based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
	// Roger Penrose's rhombuses

	Penrose3(n)	=> attr (delta, 360/10) [Y]++[Y]++[Y]++[Y]++[Y], n;
	W	=> YF++ZF----XF[-YF----WF]++;
	X	=> +YF--ZF[---WF--XF]+;
	Y	=> -WF++XF[+++YF++ZF]-;
	Z	=> --YF++++WF[+ZF++++XF]--XF;
	F	=> ;
)

ruleset (	// by Herb Savage
	// This is Penrose3 and Penrose4 superimposed

	Double_penrose(n)	=> attr (delta, 360/10) [X][Y]++[X][Y]++[X][Y]++[X][Y]++[X][Y], n;
	W	=> YF++ZF----XF[-YF----WF]++;
	X	=> +YF--ZF[---WF--XF]+;
	Y	=> -WF++XF[+++YF++ZF]-;
	Z	=> --YF++++WF[+ZF++++XF]--XF;
	F	=> ;
)

ruleset (	// by Herb Savage
	// based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers"
	// This is an example of a "reptile"

	Sphinx(n)	=> attr (delta, 360/6) X, n;
	X	=> +FF-YFF+FF--FFF|X|F--YFFFYFFF|;
	Y	=> -FF+XFF-FF++FFF|Y|F++XFFFXFFF|;
	F	=> ff;
	f	=> ff;
)

ruleset (
	// Manual construction by Roger Penrose as a prelude to his development of
	// the famous Penrose tiles (the kites and darts) that tile the plane
	// only non-periodically.
	// Translated first to a "dragon curve" and finally to an L-system
	// by Joe Saverino.

	Penta_plexity(n)	=> attr (delta, 360/10) F++F++F++F++F, n;
	F	=> F++F++F|F-F++F;
)

	// old PentaPlexity:
	// Angle 10
	// Axiom F++F++F++F++Fabxjeabxykabxyelbxyeahxyeabiye
	// F=
	// a=Fabxjea
	// b=++F--bxykab
	// x=++++F----xyelbx
	// y=----F++++yeahxy
	// e=--F++eabiye
	// h=+++++F-----hijxlh
	// i=---F+++ijkyhi
	// j=-F+jkleij
	// k=+F-klhajk
	// l=+++F---lhibkl

ruleset (	// Adrian Mariano
	Circular_tile(n)	=> attr (delta, 360/10) X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X+X, n;
	x	=> [F+F+F+F[---X-Y]+++++F++++++++F-F-F-F];
	y	=> [F+F+F+F[---Y]+++++F++++++++F-F-F-F];

)

