require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&PAGE_SHIFT_4M)) {
    sub PAGE_SHIFT_4M () {	22;}
}
unless(defined(&PAGE_MASK_4M)) {
    sub PAGE_MASK_4M () {	( &NBPD - 1);}
}
unless(defined(&PMAP_PA_MASK_4M)) {
    sub PMAP_PA_MASK_4M () {	~(( &paddr_t) &PAGE_MASK_4M);}
}
unless(defined(&HIBERNATE_STACK_PAGE)) {
    sub HIBERNATE_STACK_PAGE () {	( &PAGE_SIZE * 5);}
}
unless(defined(&HIBERNATE_IO_PAGE)) {
    sub HIBERNATE_IO_PAGE () {	( &PAGE_SIZE * 6);}
}
unless(defined(&HIBERNATE_TEMP_PAGE)) {
    sub HIBERNATE_TEMP_PAGE () {	( &PAGE_SIZE * 10);}
}
unless(defined(&HIBERNATE_TEMP_PAGE2)) {
    sub HIBERNATE_TEMP_PAGE2 () {	( &PAGE_SIZE * 11);}
}
unless(defined(&HIBERNATE_PD_PAGE)) {
    sub HIBERNATE_PD_PAGE () {	( &PAGE_SIZE * 12);}
}
unless(defined(&HIBERNATE_PT_PAGE)) {
    sub HIBERNATE_PT_PAGE () {	( &PAGE_SIZE * 13);}
}
unless(defined(&HIBERNATE_ALLOC_PAGE)) {
    sub HIBERNATE_ALLOC_PAGE () {	( &PAGE_SIZE * 14);}
}
unless(defined(&HIBERNATE_CHUNKS_PAGE)) {
    sub HIBERNATE_CHUNKS_PAGE () {	( &PAGE_SIZE * 15);}
}
unless(defined(&HIBERNATE_CHUNK_SIZE)) {
    sub HIBERNATE_CHUNK_SIZE () {	0x400000;}
}
unless(defined(&HIBERNATE_CHUNK_TABLE_START)) {
    sub HIBERNATE_CHUNK_TABLE_START () {	0x100000;}
}
unless(defined(&HIBERNATE_CHUNK_TABLE_END)) {
    sub HIBERNATE_CHUNK_TABLE_END () {	0x200000;}
}
unless(defined(&HIBERNATE_CHUNK_TABLE_SIZE)) {
    sub HIBERNATE_CHUNK_TABLE_SIZE () {	( &HIBERNATE_CHUNK_TABLE_END -  &HIBERNATE_CHUNK_TABLE_START);}
}
unless(defined(&HIBERNATE_ZLIB_SCRATCH)) {
    sub HIBERNATE_ZLIB_SCRATCH () {	( &PAGE_SIZE * 20);}
}
unless(defined(&HIBERNATE_ZLIB_START)) {
    sub HIBERNATE_ZLIB_START () {	( &PAGE_SIZE * 21);}
}
unless(defined(&HIBERNATE_ZLIB_END)) {
    sub HIBERNATE_ZLIB_END () {	( &PAGE_SIZE * (21+ 80));}
}
unless(defined(&HIBERNATE_ZLIB_SIZE)) {
    sub HIBERNATE_ZLIB_SIZE () {	( &HIBERNATE_ZLIB_END -  &HIBERNATE_ZLIB_START);}
}
unless(defined(&HIBERNATE_STACK_OFFSET)) {
    sub HIBERNATE_STACK_OFFSET () {	0xf00;}
}
unless(defined(&atop_4m)) {
    sub atop_4m {
	my($x) = @_;
	eval q((($x) >>  &PAGE_SHIFT_4M));
    }
}
unless(defined(&atop_4k)) {
    sub atop_4k {
	my($x) = @_;
	eval q((($x) >>  &PAGE_SHIFT));
    }
}
unless(defined(&s4pde_4m)) {
    sub s4pde_4m {
	my($va) = @_;
	eval q((( &pt_entry_t *) &HIBERNATE_PD_PAGE +  &atop_4m($va)));
    }
}
unless(defined(&s4pde_4k)) {
    sub s4pde_4k {
	my($va) = @_;
	eval q((( &pt_entry_t *) &HIBERNATE_PD_PAGE +  &atop_4k($va)));
    }
}
unless(defined(&s4pte_4k)) {
    sub s4pte_4k {
	my($va) = @_;
	eval q((( &pt_entry_t *) &HIBERNATE_PT_PAGE +  &atop_4k($va)));
    }
}
1;
