/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.delay;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.delay.DelayData;
import org.pentaho.di.trans.steps.delay.DelayMeta;
import org.pentaho.di.trans.steps.delay.Messages;

public class Delay
extends BaseStep
implements StepInterface {
    private DelayMeta meta;
    private DelayData data;

    public Delay(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (DelayMeta)smi;
        this.data = (DelayData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            String msgScale;
            this.first = false;
            switch (this.meta.getScaleTimeCode()) {
                case 0: {
                    msgScale = Messages.getString("DelayDialog.MSScaleTime.Label");
                    this.data.Multiple = 1;
                    break;
                }
                case 1: {
                    msgScale = Messages.getString("DelayDialog.SScaleTime.Label");
                    this.data.Multiple = 1000;
                    break;
                }
                case 2: {
                    msgScale = Messages.getString("DelayDialog.MnScaleTime.Label");
                    this.data.Multiple = 60000;
                    break;
                }
                case 3: {
                    msgScale = Messages.getString("DelayDialog.HrScaleTime.Label");
                    this.data.Multiple = 3600000;
                    break;
                }
                default: {
                    msgScale = "Unknown Scale";
                    this.data.Multiple = 1;
                }
            }
            String timeOut = this.environmentSubstitute(this.meta.getTimeOut());
            this.data.timeout = Const.toInt((String)timeOut, (int)0);
            if (this.log.isDebug()) {
                this.log.logDebug(this.toString(), Messages.getString("Delay.Log.TimeOut", "" + this.data.timeout, msgScale), new Object[0]);
            }
        }
        if (this.data.Multiple < 1000 && this.data.timeout > 0) {
            try {
                Thread.sleep(this.data.timeout);
            }
            catch (Exception e) {}
        } else {
            long timeStart = System.currentTimeMillis();
            boolean continueLoop = true;
            while (continueLoop && !this.isStopped()) {
                long now = System.currentTimeMillis();
                if (now >= timeStart + (long)(this.data.timeout * this.data.Multiple)) {
                    continueLoop = false;
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {}
            }
        }
        if (this.log.isDebug()) {
            this.log.logDebug(this.toString(), Messages.getString("Delay.WaitTimeIsElapsed.Label"), new Object[0]);
        }
        this.putRow(this.getInputRowMeta(), r);
        if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
            this.logDetailed(Messages.getString("Delay.Log.LineNumber", "" + this.getLinesRead()));
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (DelayMeta)smi;
        this.data = (DelayData)sdi;
        return super.init(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

